/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyRational;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Integer"}, parent="Numeric", include={"Precision"})
public abstract class RubyInteger
extends RubyNumeric {
    public static RubyClass createIntegerClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Integer", ruby.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setInteger(rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyInteger;
            }
        };
        rubyClass.getSingletonClass().undefineMethod("new");
        rubyClass.includeModule(ruby.getPrecision());
        rubyClass.defineAnnotatedMethods(RubyInteger.class);
        return rubyClass;
    }

    public RubyInteger(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyInteger(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, rubyClass, bl);
    }

    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"upto"}, frame=true)
    public IRubyObject upto(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = this.getRuntime();
        if (this instanceof RubyFixnum && iRubyObject instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
            long l = rubyFixnum.getLongValue();
            long l2 = this.getLongValue();
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject iRubyObject2 = ruby.getNil();
                for (long i = l2; i <= l; ++i) {
                    block.yield(threadContext, iRubyObject2);
                }
            } else {
                for (long i = l2; i <= l; ++i) {
                    block.yield(threadContext, RubyFixnum.newFixnum(ruby, i));
                }
            }
        } else {
            RubyNumeric rubyNumeric = this;
            while (!rubyNumeric.callMethod(threadContext, MethodIndex.OP_GT, ">", iRubyObject).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(ruby));
            }
        }
        return this;
    }

    @JRubyMethod(name={"downto"}, frame=true)
    public IRubyObject downto(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        Ruby ruby = this.getRuntime();
        if (this instanceof RubyFixnum && iRubyObject instanceof RubyFixnum) {
            RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
            long l = rubyFixnum.getLongValue();
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject iRubyObject2 = ruby.getNil();
                for (long i = this.getLongValue(); i >= l; --i) {
                    block.yield(threadContext, iRubyObject2);
                }
            } else {
                for (long i = this.getLongValue(); i >= l; --i) {
                    block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else {
            RubyNumeric rubyNumeric = this;
            while (!rubyNumeric.callMethod(threadContext, MethodIndex.OP_LT, "<", iRubyObject).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_MINUS, "-", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    @JRubyMethod(name={"times"}, frame=true)
    public IRubyObject times(ThreadContext threadContext, Block block) {
        Ruby ruby = threadContext.getRuntime();
        if (this instanceof RubyFixnum) {
            long l = this.getLongValue();
            if (block.getBody().getArgumentType() == 0) {
                IRubyObject iRubyObject = ruby.getNil();
                for (long i = 0L; i < l; ++i) {
                    block.yield(threadContext, iRubyObject);
                }
            } else {
                for (long i = 0L; i < l; ++i) {
                    block.yield(threadContext, RubyFixnum.newFixnum(ruby, i));
                }
            }
        } else {
            RubyNumeric rubyNumeric = RubyFixnum.zero(ruby);
            while (rubyNumeric.callMethod(threadContext, MethodIndex.OP_LT, "<", this).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(ruby));
            }
        }
        return this;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext threadContext) {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(threadContext, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw this.getRuntime().newRangeError(this.toString() + " out of char range");
        }
        return RubyString.newString(this.getRuntime(), new ByteList(new byte[]{(byte)this.getLongValue()}, false));
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "round", "truncate"})
    public RubyInteger to_i() {
        return this;
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext threadContext) {
        return RubyRational.newRationalCanonicalize(threadContext, this);
    }

    @JRubyMethod(name={"odd?"})
    public static RubyBoolean odd_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.callMethod(threadContext, "%", iRubyObject.getRuntime().newFixnum(2)) != RubyFixnum.zero(iRubyObject.getRuntime())) {
            return iRubyObject.getRuntime().getTrue();
        }
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"even?"})
    public static RubyBoolean even_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.callMethod(threadContext, "%", iRubyObject.getRuntime().newFixnum(2)) == RubyFixnum.zero(iRubyObject.getRuntime())) {
            return iRubyObject.getRuntime().getTrue();
        }
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod
    public static IRubyObject pred(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "-", iRubyObject.getRuntime().newFixnum(1));
    }

    @JRubyMethod(name={"induced_from"}, meta=true)
    public static IRubyObject induced_from(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum) {
            return iRubyObject2;
        }
        if (iRubyObject2 instanceof RubyFloat || iRubyObject2 instanceof RubyRational) {
            return iRubyObject2.callMethod(threadContext, MethodIndex.TO_I, "to_i");
        }
        throw iRubyObject.getRuntime().newTypeError("failed to convert " + iRubyObject2.getMetaClass().getName() + " into Integer");
    }
}

