/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyUnboundMethod;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallbackFactory;
import org.jruby.nb.runtime.MethodBlock;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Method"})
public class RubyMethod
extends RubyObject {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;
    protected IRubyObject receiver;

    protected RubyMethod(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Method", ruby.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setMethod(rubyClass);
        rubyClass.defineAnnotatedMethods(RubyMethod.class);
        return rubyClass;
    }

    public static RubyMethod newMethod(RubyModule rubyModule, String string, RubyModule rubyModule2, String string2, DynamicMethod dynamicMethod, IRubyObject iRubyObject) {
        Ruby ruby = rubyModule.getRuntime();
        RubyMethod rubyMethod = new RubyMethod(ruby, ruby.getMethod());
        rubyMethod.implementationModule = rubyModule;
        rubyMethod.methodName = string;
        rubyMethod.originModule = rubyModule2;
        rubyMethod.originName = string2;
        rubyMethod.method = dynamicMethod.getRealMethod();
        rubyMethod.receiver = iRubyObject;
        return rubyMethod;
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext threadContext, Block block) {
        return this.method.call(threadContext, this.receiver, this.implementationModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.method.call(threadContext, this.receiver, this.implementationModule, this.methodName, iRubyObject, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return this.method.call(threadContext, this.receiver, this.implementationModule, this.methodName, iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        return this.method.call(threadContext, this.receiver, this.implementationModule, this.methodName, iRubyObject, iRubyObject2, iRubyObject3, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        return this.method.call(threadContext, this.receiver, this.implementationModule, this.methodName, iRubyObjectArray, block);
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyMethod)) {
            return threadContext.getRuntime().getFalse();
        }
        RubyMethod rubyMethod = (RubyMethod)iRubyObject;
        return threadContext.getRuntime().newBoolean(this.implementationModule == rubyMethod.implementationModule && this.originModule == rubyMethod.originModule && this.receiver == rubyMethod.receiver && this.method.getRealMethod() == rubyMethod.method.getRealMethod());
    }

    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod(name={"to_proc"}, frame=true)
    public IRubyObject to_proc(ThreadContext threadContext, Block block) {
        Ruby ruby = threadContext.getRuntime();
        CallbackFactory callbackFactory = ruby.callbackFactory(RubyMethod.class);
        Block block2 = MethodBlock.createMethodBlock(threadContext, threadContext.getCurrentScope(), callbackFactory.getBlockMethod("bmcall"), this, ruby.getTopSelf());
        while (true) {
            try {
                return this.mproc(threadContext, block2);
            }
            catch (JumpException.BreakJump breakJump) {
                return (IRubyObject)breakJump.getValue();
            }
            catch (JumpException.ReturnJump returnJump) {
                return (IRubyObject)returnJump.getValue();
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject mproc(ThreadContext threadContext, Block block) {
        try {
            threadContext.preMproc();
            RubyProc rubyProc = RubyKernel.proc(threadContext, threadContext.getRuntime().getNil(), block);
            return rubyProc;
        }
        finally {
            threadContext.postMproc();
        }
    }

    public static IRubyObject bmcall(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        if (iRubyObject instanceof RubyArray) {
            return ((RubyMethod)iRubyObject2).call(threadContext, ((RubyArray)iRubyObject).toJavaArray(), Block.NULL_BLOCK);
        }
        return ((RubyMethod)iRubyObject2).call(threadContext, new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"unbind"}, frame=true)
    public RubyUnboundMethod unbind(Block block) {
        RubyUnboundMethod rubyUnboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        rubyUnboundMethod.infectBy(this);
        return rubyUnboundMethod;
    }

    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        IRubyObject iRubyObject;
        StringBuilder stringBuilder = new StringBuilder("#<");
        int n = 35;
        stringBuilder.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            iRubyObject = ((MetaClass)this.implementationModule).getAttached();
            if (this.receiver == null) {
                stringBuilder.append(this.implementationModule.inspect().toString());
            } else if (this.receiver == iRubyObject) {
                stringBuilder.append(iRubyObject.inspect().toString());
                n = 46;
            } else {
                stringBuilder.append(this.receiver.inspect().toString());
                stringBuilder.append('(').append(iRubyObject.inspect().toString()).append(')');
                n = 46;
            }
        } else {
            stringBuilder.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                stringBuilder.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        stringBuilder.append((char)n).append(this.methodName).append('>');
        iRubyObject = this.getRuntime().newString(stringBuilder.toString());
        ((RubyObject)iRubyObject).setTaint(this.isTaint());
        return iRubyObject;
    }
}

