/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.math.BigInteger;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyComparable;
import org.jruby.nb.RubyComplex;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyRational;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.Convert;
import org.jruby.nb.util.Numeric;
import org.jruby.util.ByteList;

@JRubyClass(name={"Numeric"}, include={"Comparable"})
public class RubyNumeric
extends RubyObject {
    protected static final ObjectAllocator NUMERIC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubyNumeric(ruby, rubyClass);
        }
    };
    public static double DBL_EPSILON = 2.220446049250313E-16;

    public static RubyClass createNumericClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Numeric", ruby.getObject(), NUMERIC_ALLOCATOR);
        ruby.setNumeric(rubyClass);
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyNumeric;
            }
        };
        rubyClass.includeModule(ruby.getComparable());
        rubyClass.defineAnnotatedMethods(RubyNumeric.class);
        return rubyClass;
    }

    private static IRubyObject convertToNum(double d, Ruby ruby) {
        if (d >= 9.223372036854776E18 || d < -9.223372036854776E18) {
            return RubyBignum.newBignum(ruby, d);
        }
        return RubyFixnum.newFixnum(ruby, (long)d);
    }

    public RubyNumeric(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public RubyNumeric(Ruby ruby, RubyClass rubyClass, boolean bl) {
        super(ruby, rubyClass, bl);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public static RubyNumeric newNumeric(Ruby ruby) {
        return new RubyNumeric(ruby, ruby.getNumeric());
    }

    public static int num2int(IRubyObject iRubyObject) {
        long l = RubyNumeric.num2long(iRubyObject);
        RubyNumeric.checkInt(iRubyObject, l);
        return (int)l;
    }

    public static void checkInt(IRubyObject iRubyObject, long l) {
        String string;
        if (l < Integer.MIN_VALUE) {
            string = "small";
        } else if (l > Integer.MAX_VALUE) {
            string = "big";
        } else {
            return;
        }
        throw iRubyObject.getRuntime().newRangeError("integer " + l + " too " + string + " to convert to `int'");
    }

    public static byte num2chr(IRubyObject iRubyObject) {
        String string;
        if (iRubyObject instanceof RubyString && (string = ((RubyString)iRubyObject).toString()) != null && string.length() > 0) {
            return (byte)string.charAt(0);
        }
        return (byte)RubyNumeric.num2int(iRubyObject);
    }

    public static long num2long(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return ((RubyFixnum)iRubyObject).getLongValue();
        }
        if (iRubyObject.isNil()) {
            throw iRubyObject.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        if (iRubyObject instanceof RubyFloat) {
            double d = ((RubyFloat)iRubyObject).getDoubleValue();
            if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                return (long)d;
            }
            throw iRubyObject.getRuntime().newRangeError("float " + d + " out of range of integer");
        }
        if (iRubyObject instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)iRubyObject);
        }
        return iRubyObject.convertToInteger().getLongValue();
    }

    public static IRubyObject dbl2num(Ruby ruby, double d) {
        if (Double.isInfinite(d)) {
            throw ruby.newFloatDomainError(d < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(d)) {
            throw ruby.newFloatDomainError("NaN");
        }
        return RubyNumeric.convertToNum(d, ruby);
    }

    public static double num2dbl(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFloat) {
            return ((RubyFloat)iRubyObject).getDoubleValue();
        }
        if (iRubyObject instanceof RubyString) {
            throw iRubyObject.getRuntime().newTypeError("no implicit conversion to float from string");
        }
        if (iRubyObject == iRubyObject.getRuntime().getNil()) {
            throw iRubyObject.getRuntime().newTypeError("no implicit conversion to float from nil");
        }
        return iRubyObject.convertToFloat().getDoubleValue();
    }

    public static IRubyObject dbl_cmp(Ruby ruby, double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return ruby.getNil();
        }
        if (d > d2) {
            return RubyFixnum.one(ruby);
        }
        if (d < d2) {
            return RubyFixnum.minus_one(ruby);
        }
        return RubyFixnum.zero(ruby);
    }

    public static long fix2long(IRubyObject iRubyObject) {
        return ((RubyFixnum)iRubyObject).getLongValue();
    }

    public static int fix2int(IRubyObject iRubyObject) {
        long l = iRubyObject instanceof RubyFixnum ? RubyNumeric.fix2long(iRubyObject) : RubyNumeric.num2long(iRubyObject);
        RubyNumeric.checkInt(iRubyObject, l);
        return (int)l;
    }

    public static RubyInteger str2inum(Ruby ruby, RubyString rubyString, int n) {
        return RubyNumeric.str2inum(ruby, rubyString, n, false);
    }

    public static RubyNumeric int2fix(Ruby ruby, long l) {
        return RubyFixnum.newFixnum(ruby, l);
    }

    public static IRubyObject num2fix(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyBignum) {
            throw iRubyObject.getRuntime().newRangeError("integer " + iRubyObject + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(iRubyObject.getRuntime(), RubyNumeric.num2long(iRubyObject));
    }

    public static RubyInteger str2inum(Ruby ruby, RubyString rubyString, int n, boolean bl) {
        if (n != 0 && (n < 2 || n > 36)) {
            throw ruby.newArgumentError("illegal radix " + n);
        }
        ByteList byteList = rubyString.getByteList();
        try {
            return ruby.newFixnum(Convert.byteListToLong(byteList, n, bl));
        }
        catch (InvalidIntegerException invalidIntegerException) {
            return RubyNumeric.str2inumIIE(bl, ruby, rubyString);
        }
        catch (NumberTooLargeException numberTooLargeException) {
            return RubyNumeric.str2inumNTLE(bl, ruby, rubyString, byteList, n);
        }
    }

    private static RubyInteger str2inumIIE(boolean bl, Ruby ruby, RubyString rubyString) throws RaiseException {
        if (bl) {
            throw ruby.newArgumentError("invalid value for Integer: " + rubyString.callMethod(ruby.getCurrentContext(), "inspect").toString());
        }
        return RubyFixnum.zero(ruby);
    }

    private static RubyInteger str2inumNTLE(boolean bl, Ruby ruby, RubyString rubyString, ByteList byteList, int n) {
        try {
            BigInteger bigInteger = Convert.byteListToBigInteger(byteList, n, bl);
            return new RubyBignum(ruby, bigInteger);
        }
        catch (InvalidIntegerException invalidIntegerException) {
            return RubyNumeric.str2inumIIE(bl, ruby, rubyString);
        }
    }

    public static RubyFloat str2fnum(Ruby ruby, RubyString rubyString) {
        return RubyNumeric.str2fnum(ruby, rubyString, false);
    }

    public static RubyFloat str2fnum(Ruby ruby, RubyString rubyString, boolean bl) {
        try {
            return new RubyFloat(ruby, Convert.byteListToDouble(rubyString.getByteList(), bl));
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                throw ruby.newArgumentError("invalid value for Float(): " + rubyString.callMethod(ruby.getCurrentContext(), "inspect").toString());
            }
            return new RubyFloat(ruby, 0.0);
        }
    }

    protected IRubyObject[] getCoerced(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl) {
        IRubyObject iRubyObject2;
        try {
            iRubyObject2 = iRubyObject.callMethod(threadContext, "coerce", this);
        }
        catch (RaiseException raiseException) {
            if (bl) {
                throw this.getRuntime().newTypeError(iRubyObject.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(iRubyObject2 instanceof RubyArray) || ((RubyArray)iRubyObject2).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)iRubyObject2).toJavaArray();
    }

    protected IRubyObject callCoerced(ThreadContext threadContext, String string, IRubyObject iRubyObject, boolean bl) {
        IRubyObject[] iRubyObjectArray = this.getCoerced(threadContext, iRubyObject, bl);
        if (iRubyObjectArray == null) {
            return this.getRuntime().getNil();
        }
        return iRubyObjectArray[0].callMethod(threadContext, string, iRubyObjectArray[1]);
    }

    protected IRubyObject callCoerced(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = this.getCoerced(threadContext, iRubyObject, false);
        if (iRubyObjectArray == null) {
            return this.getRuntime().getNil();
        }
        return iRubyObjectArray[0].callMethod(threadContext, string, iRubyObjectArray[1]);
    }

    protected final IRubyObject coerceBody(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "coerce", this);
    }

    protected final RubyArray doCoerce(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl) {
        IRubyObject iRubyObject2;
        try {
            iRubyObject2 = this.coerceBody(threadContext, iRubyObject);
        }
        catch (RaiseException raiseException) {
            if (bl) {
                throw this.getRuntime().newTypeError(iRubyObject.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(iRubyObject2 instanceof RubyArray) || ((RubyArray)iRubyObject2).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return (RubyArray)iRubyObject2;
    }

    protected final IRubyObject coerceBin(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        RubyArray rubyArray = this.doCoerce(threadContext, iRubyObject, true);
        return rubyArray.eltInternal(0).callMethod(threadContext, string, rubyArray.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        RubyArray rubyArray = this.doCoerce(threadContext, iRubyObject, false);
        if (rubyArray == null) {
            return this.getRuntime().getNil();
        }
        return rubyArray.eltInternal(0).callMethod(threadContext, string, rubyArray.eltInternal(1));
    }

    protected final IRubyObject coerceRelOp(ThreadContext threadContext, String string, IRubyObject iRubyObject) {
        RubyArray rubyArray = this.doCoerce(threadContext, iRubyObject, false);
        if (rubyArray == null) {
            return RubyComparable.cmperr(this, iRubyObject);
        }
        return this.unwrapCoerced(threadContext, string, iRubyObject, rubyArray);
    }

    private final IRubyObject unwrapCoerced(ThreadContext threadContext, String string, IRubyObject iRubyObject, RubyArray rubyArray) {
        IRubyObject iRubyObject2 = rubyArray.eltInternal(0).callMethod(threadContext, string, rubyArray.eltInternal(1));
        if (iRubyObject2.isNil()) {
            return RubyComparable.cmperr(this, iRubyObject);
        }
        return iRubyObject2;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @JRubyMethod(name={"singleton_method_added"})
    public IRubyObject sadded(IRubyObject iRubyObject) {
        throw this.getRuntime().newTypeError("can't define singleton method " + iRubyObject + " for " + this.getType().getName());
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject iRubyObject) {
        throw this.getRuntime().newTypeError("can't copy " + this.getType().getName());
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(IRubyObject iRubyObject) {
        if (this.getClass() == iRubyObject.getClass()) {
            return this.getRuntime().newArray(iRubyObject, this);
        }
        IRubyObject iRubyObject2 = RubyKernel.new_float(this, this);
        IRubyObject iRubyObject3 = RubyKernel.new_float(this, iRubyObject);
        return this.getRuntime().newArray(iRubyObject3, iRubyObject2);
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus(ThreadContext threadContext) {
        RubyFixnum rubyFixnum = RubyFixnum.zero(this.getRuntime());
        RubyArray rubyArray = rubyFixnum.doCoerce(threadContext, this, true);
        return rubyArray.eltInternal(0).callMethod(threadContext, MethodIndex.OP_MINUS, "-", rubyArray.eltInternal(1));
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.getClass() != iRubyObject.getClass()) {
            return this.getRuntime().getFalse();
        }
        return RubyNumeric.equalInternal(threadContext, this, iRubyObject) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"quo"})
    public IRubyObject quo(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.callMethod(threadContext, "/", iRubyObject);
    }

    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject quo_19(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyRational.newRationalRaw(threadContext.getRuntime(), this).callMethod(threadContext, "/", iRubyObject);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.callMethod(threadContext, "/", iRubyObject).convertToFloat().floor();
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RubyArray.newArray(this.getRuntime(), this.div(threadContext, iRubyObject), this.modulo(threadContext, iRubyObject));
    }

    @JRubyMethod(name={"fdiv"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject fdiv(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RuntimeHelpers.invoke(threadContext, (IRubyObject)this.convertToFloat(), "/", iRubyObject);
    }

    @JRubyMethod(name={"modulo"})
    public IRubyObject modulo(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.callMethod(threadContext, "%", iRubyObject);
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = this.callMethod(threadContext, "%", iRubyObject);
        RubyNumeric rubyNumeric = this;
        RubyFixnum rubyFixnum = RubyFixnum.zero(this.getRuntime());
        if (!RubyNumeric.equalInternal(threadContext, iRubyObject2, rubyFixnum) && (rubyNumeric.callMethod(threadContext, MethodIndex.OP_LT, "<", rubyFixnum).isTrue() && iRubyObject.callMethod(threadContext, MethodIndex.OP_GT, ">", rubyFixnum).isTrue() || rubyNumeric.callMethod(threadContext, MethodIndex.OP_GT, ">", rubyFixnum).isTrue() && iRubyObject.callMethod(threadContext, MethodIndex.OP_LT, "<", rubyFixnum).isTrue())) {
            return iRubyObject2.callMethod(threadContext, MethodIndex.OP_MINUS, "-", iRubyObject);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs(ThreadContext threadContext) {
        if (this.callMethod(threadContext, MethodIndex.OP_LT, "<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return this.callMethod(threadContext, "-@");
        }
        return this;
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int(ThreadContext threadContext) {
        return RuntimeHelpers.invoke(threadContext, this, "to_i");
    }

    @JRubyMethod(name={"scalar?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject scalar_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext threadContext) {
        return RubyNumeric.equalInternal(threadContext, this, RubyFixnum.zero(this.getRuntime())) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p(ThreadContext threadContext) {
        if (this.callMethod(threadContext, "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return this.convertToFloat().floor();
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return this.convertToFloat().ceil();
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return this.convertToFloat().round();
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate() {
        return this.convertToFloat().truncate();
    }

    @JRubyMethod(name={"step"}, required=1, optional=1, frame=true)
    public IRubyObject step(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        switch (iRubyObjectArray.length) {
            case 0: {
                throw threadContext.getRuntime().newArgumentError(0, 1);
            }
            case 1: {
                return this.step(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.step(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
        }
        throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
    }

    @JRubyMethod(name={"step"}, frame=true)
    public IRubyObject step(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return this.step(threadContext, iRubyObject, RubyFixnum.one(threadContext.getRuntime()), block);
    }

    @JRubyMethod(name={"step"}, frame=true)
    public IRubyObject step(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (this instanceof RubyFixnum && iRubyObject instanceof RubyFixnum && iRubyObject2 instanceof RubyFixnum) {
            long l = this.getLongValue();
            long l2 = ((RubyFixnum)iRubyObject).getLongValue();
            long l3 = ((RubyFixnum)iRubyObject2).getLongValue();
            if (l3 == 0L) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            if (l3 > 0L) {
                for (long i = l; i <= l2; i += l3) {
                    block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            } else {
                for (long i = l; i >= l2; i += l3) {
                    block.yield(threadContext, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else if (this instanceof RubyFloat || iRubyObject instanceof RubyFloat || iRubyObject2 instanceof RubyFloat) {
            double d = RubyNumeric.num2dbl(this);
            double d2 = RubyNumeric.num2dbl(iRubyObject);
            double d3 = RubyNumeric.num2dbl(iRubyObject2);
            if (d3 == 0.0) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            double d4 = (d2 - d) / d3;
            double d5 = (Math.abs(d) + Math.abs(d2) + Math.abs(d2 - d)) / Math.abs(d3) * DBL_EPSILON;
            if (d5 > 0.5) {
                d5 = 0.5;
            }
            d4 = Math.floor(d4 + d5) + 1.0;
            for (double d6 = 0.0; d6 < d4; d6 += 1.0) {
                block.yield(threadContext, RubyFloat.newFloat(this.getRuntime(), d6 * d3 + d));
            }
        } else {
            RubyNumeric rubyNumeric = this;
            int n = ((RubyBoolean)iRubyObject2.callMethod(threadContext, MethodIndex.OP_GT, ">", RubyFixnum.zero(this.getRuntime()))).isTrue() ? MethodIndex.OP_GT : MethodIndex.OP_LT;
            String string = MethodIndex.NAMES.get(n);
            while (!rubyNumeric.callMethod(threadContext, n, string, iRubyObject).isTrue()) {
                block.yield(threadContext, rubyNumeric);
                rubyNumeric = (RubyNumeric)rubyNumeric.callMethod(threadContext, MethodIndex.OP_PLUS, "+", iRubyObject2);
            }
        }
        return this;
    }

    protected final IRubyObject op_num_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this == iRubyObject) {
            return this.getRuntime().getTrue();
        }
        return iRubyObject.callMethod(threadContext, MethodIndex.EQUALEQUAL, "==", this);
    }

    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext threadContext) {
        return RubyRational.newRationalConvert(threadContext, this).callMethod(threadContext, "numerator");
    }

    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext threadContext) {
        return RubyRational.newRationalConvert(threadContext, this).callMethod(threadContext, "denominator");
    }

    @JRubyMethod(name={"to_c"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_c(ThreadContext threadContext) {
        return RubyComplex.newComplexCanonicalize(threadContext, this);
    }

    @JRubyMethod(name={"re"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject re(ThreadContext threadContext) {
        return RubyComplex.newComplexConvert(threadContext, this);
    }

    @JRubyMethod(name={"im"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject im(ThreadContext threadContext) {
        return RubyComplex.newComplexConvert(threadContext, RubyFixnum.zero(threadContext.getRuntime()), this);
    }

    @JRubyMethod(name={"real"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject real(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"image", "imag"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject image(ThreadContext threadContext) {
        return RubyFixnum.zero(threadContext.getRuntime());
    }

    @JRubyMethod(name={"arg"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject arg(ThreadContext threadContext) {
        if (!Numeric.f_negative_p(threadContext, this)) {
            return RubyFixnum.zero(threadContext.getRuntime());
        }
        return threadContext.getRuntime().getMath().fastFetchConstant("PI");
    }

    @JRubyMethod(name={"polar"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject polar(ThreadContext threadContext) {
        return threadContext.getRuntime().newArray(Numeric.f_abs(threadContext, this), Numeric.f_arg(threadContext, this));
    }

    @JRubyMethod(name={"conjugate"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject conjugate(ThreadContext threadContext) {
        return this;
    }

    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String string) {
            super(string);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String string) {
            super(string);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

