/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.IArityNode;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstVarNode
extends Node
implements IArityNode,
INameNode {
    private String name;

    public InstVarNode(ISourcePosition iSourcePosition, String string) {
        super(iSourcePosition, NodeType.INSTVARNODE);
        this.name = string;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitInstVarNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.noArguments();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable(this.name);
        if (iRubyObject2 != null) {
            return iRubyObject2;
        }
        ruby.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, this.getPosition(), "instance variable " + this.name + " not initialized", this.name);
        return ruby.getNil();
    }

    @Override
    public String definition(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        return iRubyObject.getInstanceVariables().fastHasInstanceVariable(this.name) ? "instance-variable" : null;
    }

    @Override
    public String toString() {
        return "InstVarnode: " + this.name;
    }
}

