/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"AbstractMemoryPointer"}, parent="AbstractMemory")
public abstract class AbstractMemoryPointer
extends AbstractMemory {
    public static final String className = "AbstractMemoryPointer";
    private static final Map<AbstractMemoryPointer, Object> pointerSet = new ConcurrentHashMap<AbstractMemoryPointer, Object>();

    public static RubyClass createMemoryPointerClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = rubyModule.defineClassUnder(className, rubyModule.getClass("AbstractMemory"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(AbstractMemoryPointer.class);
        rubyClass.defineAnnotatedConstants(AbstractMemoryPointer.class);
        return rubyClass;
    }

    protected AbstractMemoryPointer(Ruby ruby, RubyClass rubyClass, MemoryIO memoryIO, long l, long l2) {
        super(ruby, rubyClass, memoryIO, l, l2);
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.getMemoryIO().isNull());
    }

    @JRubyMethod(name={"read_pointer"})
    public IRubyObject read_pointer(ThreadContext threadContext) {
        return this.getMemoryPointer(threadContext.getRuntime(), 0L);
    }

    @JRubyMethod(name={"get_buffer"}, required=2)
    public IRubyObject get_buffer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = Util.int32Value(iRubyObject2);
        ByteList byteList = new ByteList(n);
        this.getMemoryIO().get(this.getOffset(iRubyObject), byteList.unsafeBytes(), byteList.begin(), n);
        byteList.length(n);
        return threadContext.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"put_buffer"}, required=3)
    public IRubyObject put_buffer(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ByteList byteList = iRubyObject2.convertToString().getByteList();
        int n = Math.min(byteList.length(), Util.int32Value(iRubyObject3));
        this.getMemoryIO().put(this.getOffset(iRubyObject), byteList.unsafeBytes(), byteList.begin(), n);
        return threadContext.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"free"})
    public IRubyObject free(ThreadContext threadContext) {
        pointerSet.remove(this);
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public IRubyObject autorelease(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.isTrue()) {
            pointerSet.remove(this);
        } else {
            pointerSet.put(this, Boolean.TRUE);
        }
        return threadContext.getRuntime().getNil();
    }
}

