/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.AbstractMemory;
import org.jruby.nb.ext.ffi.AbstractMemoryPointer;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.NativeType;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.nb.ext.ffi.StructLayout;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"StructLayoutBuilder"}, parent="Object")
public final class StructLayoutBuilder
extends RubyObject {
    public static final String CLASS_NAME = "StructLayoutBuilder";
    static final int LONG_SIZE = Platform.getPlatform().longSize();
    static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
    static final int LONG_ALIGN = StructLayoutBuilder.isSparc() ? 64 : LONG_SIZE;
    static final int ADDRESS_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    static final int DOUBLE_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    static final int FLOAT_ALIGN = StructLayoutBuilder.isSparc() ? 64 : ADDRESS_SIZE;
    private final Map<IRubyObject, StructLayout.Member> fields = new LinkedHashMap<IRubyObject, StructLayout.Member>();
    private int size = 0;

    private static final boolean isSparc() {
        return false;
    }

    public static RubyClass createStructLayoutBuilderClass(Ruby ruby) {
        RubyModule rubyModule = FFIProvider.getModule(ruby);
        RubyClass rubyClass = ruby.defineClassUnder(CLASS_NAME, ruby.getObject(), Allocator.INSTANCE, rubyModule);
        rubyClass.defineAnnotatedMethods(StructLayoutBuilder.class);
        rubyClass.defineAnnotatedConstants(StructLayoutBuilder.class);
        return rubyClass;
    }

    StructLayoutBuilder(Ruby ruby) {
        this(ruby, FFIProvider.getModule(ruby).fastGetClass(CLASS_NAME));
    }

    StructLayoutBuilder(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static StructLayoutBuilder newInstance(ThreadContext threadContext, IRubyObject iRubyObject) {
        return new StructLayoutBuilder(threadContext.getRuntime());
    }

    @JRubyMethod(name={"build"})
    public StructLayout build(ThreadContext threadContext) {
        return new StructLayout(threadContext.getRuntime(), this.fields, this.size);
    }

    private static int alignMember(int n, int n2) {
        int n3 = n;
        int n4 = n2 >> 3;
        int n5 = n4 - 1;
        if ((n3 & n5) != 0) {
            n3 = (n3 & ~n5) + n4;
        }
        return n3;
    }

    @JRubyMethod(name={"add_field"}, required=2, optional=1)
    public IRubyObject add(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        StructLayout.Member member;
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject = iRubyObjectArray[0];
        NativeType nativeType = NativeType.valueOf(Util.int32Value(iRubyObjectArray[1]));
        int n = iRubyObjectArray.length > 2 ? Util.int32Value(iRubyObjectArray[2]) : -1;
        int n2 = 8;
        int n3 = 8;
        switch (nativeType) {
            case INT8: 
            case UINT8: {
                n2 = 8;
                n3 = 8;
                break;
            }
            case INT16: 
            case UINT16: {
                n2 = 16;
                n3 = 16;
                break;
            }
            case INT32: 
            case UINT32: {
                n2 = 32;
                n3 = 32;
                break;
            }
            case INT64: 
            case UINT64: {
                n2 = LONG_ALIGN;
                n3 = 64;
                break;
            }
            case LONG: 
            case ULONG: {
                n2 = LONG_ALIGN;
                n3 = LONG_SIZE;
                break;
            }
            case FLOAT32: {
                n2 = FLOAT_ALIGN;
                n3 = 32;
                break;
            }
            case FLOAT64: {
                n2 = DOUBLE_ALIGN;
                n3 = 64;
                break;
            }
            case POINTER: {
                n2 = Platform.getPlatform().addressSize();
                n3 = LONG_ALIGN;
                break;
            }
            case STRING: 
            case RBXSTRING: {
                n2 = ADDRESS_ALIGN;
                n3 = ADDRESS_SIZE;
            }
        }
        if (n < 0) {
            n = StructLayoutBuilder.alignMember(this.size, n2);
        }
        if ((member = this.createMember(nativeType, n)) == null) {
            throw ruby.newArgumentError("Unknown field type: " + (Object)((Object)nativeType));
        }
        this.fields.put(StructLayoutBuilder.createKey(ruby, iRubyObject), member);
        this.size = n + n3 / 8;
        return ruby.getNil();
    }

    @JRubyMethod(name={"add_char_array"}, required=2, optional=1)
    public IRubyObject add_char_array(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        long l;
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject = iRubyObjectArray[0];
        int n = Util.int32Value(iRubyObjectArray[1]);
        long l2 = l = iRubyObjectArray.length > 2 ? Util.int64Value(iRubyObjectArray[2]) : -1L;
        if (l < 0L) {
            l = StructLayoutBuilder.alignMember(this.size, 8);
        }
        StructLayout.Member member = CharArrayMember.create(l, n);
        this.fields.put(StructLayoutBuilder.createKey(ruby, iRubyObject), member);
        this.size += n;
        return ruby.getNil();
    }

    private static IRubyObject createKey(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubySymbol) {
            return iRubyObject;
        }
        return ruby.getSymbolTable().getSymbol(iRubyObject.asJavaString());
    }

    StructLayout.Member createMember(NativeType nativeType, long l) {
        switch (nativeType) {
            case INT8: {
                return Signed8Member.create(l);
            }
            case UINT8: {
                return Unsigned8Member.create(l);
            }
            case INT16: {
                return Signed16Member.create(l);
            }
            case UINT16: {
                return Unsigned16Member.create(l);
            }
            case INT32: {
                return Signed32Member.create(l);
            }
            case UINT32: {
                return Unsigned32Member.create(l);
            }
            case INT64: 
            case UINT64: {
                return Signed64Member.create(l);
            }
            case LONG: {
                return LONG_SIZE == 32 ? Signed32Member.create(l) : Signed64Member.create(l);
            }
            case ULONG: {
                return LONG_SIZE == 32 ? Unsigned32Member.create(l) : Signed64Member.create(l);
            }
            case FLOAT32: {
                return Float32Member.create(l);
            }
            case FLOAT64: {
                return Float64Member.create(l);
            }
            case POINTER: {
                return PointerMember.create(l);
            }
            case STRING: 
            case RBXSTRING: {
                return StringMember.create(l);
            }
        }
        return null;
    }

    static final class CharArrayMember
    extends StructLayout.Member {
        private final int size;

        CharArrayMember(long l, int n) {
            super(l);
            this.size = n;
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            MemoryIO memoryIO = CharArrayMember.getMemoryIO(iRubyObject);
            ByteList byteList = iRubyObject2.convertToString().getByteList();
            int n = Math.min(byteList.length(), this.size - 1);
            memoryIO.put(this.offset, byteList.unsafeBytes(), byteList.begin(), n);
            memoryIO.putByte(this.offset + (long)n, (byte)0);
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            MemoryIO memoryIO = CharArrayMember.getMemoryIO(iRubyObject);
            int n = memoryIO.indexOf(this.offset, (byte)0, this.size);
            if (n < 0) {
                n = this.size;
            }
            ByteList byteList = new ByteList(n);
            byteList.length(n);
            memoryIO.get(0L, byteList.unsafeBytes(), byteList.begin(), n);
            return ruby.newString(byteList);
        }

        static StructLayout.Member create(long l, int n) {
            return new CharArrayMember(l, n);
        }
    }

    static final class StringMember
    extends StructLayout.Member {
        StringMember(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            MemoryIO memoryIO = StringMember.getMemoryIO(iRubyObject).getMemoryIO(this.offset);
            if (!memoryIO.isNull()) {
                ByteList byteList = iRubyObject2.convertToString().getByteList();
                memoryIO.put(0L, byteList.unsafeBytes(), byteList.begin(), byteList.length());
                memoryIO.putByte(byteList.length(), (byte)0);
            }
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            MemoryIO memoryIO = StringMember.getMemoryIO(iRubyObject).getMemoryIO(this.offset);
            if (memoryIO.isNull()) {
                return ruby.getNil();
            }
            int n = memoryIO.indexOf(0L, (byte)0, Integer.MAX_VALUE);
            ByteList byteList = new ByteList(n);
            byteList.length(n);
            memoryIO.get(0L, byteList.unsafeBytes(), byteList.begin(), n);
            return ruby.newString(byteList);
        }

        static StructLayout.Member create(long l) {
            return new StringMember(l);
        }
    }

    static final class Float64Member
    extends StructLayout.Member {
        Float64Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Float64Member.getMemoryIO(iRubyObject).putDouble(this.offset, Util.doubleValue(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return RubyFloat.newFloat(ruby, Float64Member.getMemoryIO(iRubyObject).getDouble(this.offset));
        }

        static StructLayout.Member create(long l) {
            return new Float64Member(l);
        }
    }

    static final class Float32Member
    extends StructLayout.Member {
        Float32Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Float32Member.getMemoryIO(iRubyObject).putFloat(this.offset, Util.floatValue(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return RubyFloat.newFloat(ruby, Float32Member.getMemoryIO(iRubyObject).getFloat(this.offset));
        }

        static StructLayout.Member create(long l) {
            return new Float32Member(l);
        }
    }

    static final class PointerMember
    extends StructLayout.Member {
        PointerMember(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (iRubyObject2 instanceof AbstractMemoryPointer) {
                PointerMember.getMemoryIO(iRubyObject).putMemoryIO(this.offset, ((AbstractMemoryPointer)iRubyObject2).getMemoryIO());
            } else if (Platform.getPlatform().addressSize() == 32) {
                PointerMember.getMemoryIO(iRubyObject).putInt(this.offset, Util.int32Value(iRubyObject2));
            } else if (Platform.getPlatform().addressSize() == 64) {
                PointerMember.getMemoryIO(iRubyObject).putLong(this.offset, Util.int64Value(iRubyObject2));
            }
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return ((AbstractMemory)iRubyObject).getMemoryPointer(ruby, this.offset);
        }

        static StructLayout.Member create(long l) {
            return new PointerMember(l);
        }
    }

    static final class Signed64Member
    extends StructLayout.Member {
        Signed64Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Signed64Member.getMemoryIO(iRubyObject).putLong(this.offset, Util.int64Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return RubyFixnum.newFixnum(ruby, Signed64Member.getMemoryIO(iRubyObject).getLong(this.offset));
        }

        static StructLayout.Member create(long l) {
            return new Signed64Member(l);
        }
    }

    static final class Unsigned32Member
    extends StructLayout.Member {
        Unsigned32Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Unsigned32Member.getMemoryIO(iRubyObject).putInt(this.offset, (int)Util.uint32Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            long l = Unsigned32Member.getMemoryIO(iRubyObject).getInt(this.offset);
            return RubyFixnum.newFixnum(ruby, l < 0L ? (l & Integer.MAX_VALUE) + 0x80000000L : l);
        }

        static StructLayout.Member create(long l) {
            return new Unsigned32Member(l);
        }
    }

    static final class Signed32Member
    extends StructLayout.Member {
        Signed32Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Signed32Member.getMemoryIO(iRubyObject).putInt(this.offset, Util.int32Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return RubyFixnum.newFixnum(ruby, Signed32Member.getMemoryIO(iRubyObject).getInt(this.offset));
        }

        static StructLayout.Member create(long l) {
            return new Signed32Member(l);
        }
    }

    static final class Unsigned16Member
    extends StructLayout.Member {
        Unsigned16Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Unsigned16Member.getMemoryIO(iRubyObject).putShort(this.offset, (short)Util.uint16Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            short s = Unsigned16Member.getMemoryIO(iRubyObject).getShort(this.offset);
            return RubyFixnum.newFixnum(ruby, s < 0 ? (long)((s & Short.MAX_VALUE) + 32768) : (long)s);
        }

        static StructLayout.Member create(long l) {
            return new Unsigned16Member(l);
        }
    }

    static final class Signed16Member
    extends StructLayout.Member {
        Signed16Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Signed16Member.getMemoryIO(iRubyObject).putShort(this.offset, Util.int16Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return RubyFixnum.newFixnum(ruby, Signed16Member.getMemoryIO(iRubyObject).getShort(this.offset));
        }

        static StructLayout.Member create(long l) {
            return new Signed16Member(l);
        }
    }

    static final class Unsigned8Member
    extends StructLayout.Member {
        Unsigned8Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Unsigned8Member.getMemoryIO(iRubyObject).putByte(this.offset, (byte)Util.uint8Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            byte by = Unsigned8Member.getMemoryIO(iRubyObject).getByte(this.offset);
            return RubyFixnum.newFixnum(ruby, by < 0 ? (long)((short)((by & 0x7F) + 128)) : (long)by);
        }

        static StructLayout.Member create(long l) {
            return new Unsigned8Member(l);
        }
    }

    static final class Signed8Member
    extends StructLayout.Member {
        Signed8Member(long l) {
            super(l);
        }

        public void put(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Signed8Member.getMemoryIO(iRubyObject).putByte(this.offset, Util.int8Value(iRubyObject2));
        }

        public IRubyObject get(Ruby ruby, IRubyObject iRubyObject) {
            return RubyFixnum.newFixnum(ruby, Signed8Member.getMemoryIO(iRubyObject).getByte(this.offset));
        }

        static StructLayout.Member create(long l) {
            return new Signed8Member(l);
        }
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new StructLayoutBuilder(ruby, rubyClass);
        }
    }
}

