/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyClassPathVariable;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.java.MiniJava;
import org.jruby.nb.java.addons.ArrayJavaAddons;
import org.jruby.nb.java.addons.IOJavaAddons;
import org.jruby.nb.java.addons.KernelJavaAddons;
import org.jruby.nb.java.addons.StringJavaAddons;
import org.jruby.nb.java.proxies.ArrayJavaProxy;
import org.jruby.nb.java.proxies.ConcreteJavaProxy;
import org.jruby.nb.java.proxies.JavaInterfaceTemplate;
import org.jruby.nb.java.proxies.JavaProxy;
import org.jruby.nb.javasupport.JavaArray;
import org.jruby.nb.javasupport.JavaArrayUtilities;
import org.jruby.nb.javasupport.JavaCallable;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaConstructor;
import org.jruby.nb.javasupport.JavaField;
import org.jruby.nb.javasupport.JavaMethod;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaProxyMethods;
import org.jruby.nb.javasupport.JavaSupport;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.ParameterTypes;
import org.jruby.nb.javasupport.proxy.JavaProxyClass;
import org.jruby.nb.javasupport.proxy.JavaProxyConstructor;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.util.ClassProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"Java"})
public class Java
implements Library {
    private static final ClassProvider JAVA_PACKAGE_CLASS_PROVIDER;
    private static final Map<String, Boolean> JAVA_PRIMITIVES;
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER;
    private static final CallableAcceptor Exact;
    private static final CallableAcceptor AssignableAndPrimitivable;
    private static final CallableAcceptor AssignableOrDuckable;

    @Override
    public void load(Ruby ruby, boolean bl) throws IOException {
        Java.createJavaModule(ruby);
        ruby.getLoadService().smartLoad("builtin/javasupport");
        RubyClassPathVariable.createClassPathVariable(ruby);
    }

    public static RubyModule createJavaModule(Ruby ruby) {
        ThreadContext threadContext = ruby.getCurrentContext();
        RubyModule rubyModule = ruby.defineModule("Java");
        rubyModule.defineAnnotatedMethods(Java.class);
        JavaObject.createJavaObjectClass(ruby, rubyModule);
        JavaArray.createJavaArrayClass(ruby, rubyModule);
        JavaClass.createJavaClassClass(ruby, rubyModule);
        JavaMethod.createJavaMethodClass(ruby, rubyModule);
        JavaConstructor.createJavaConstructorClass(ruby, rubyModule);
        JavaField.createJavaFieldClass(ruby, rubyModule);
        JavaProxyMethods.createJavaProxyMethods(threadContext);
        JavaProxy.createJavaProxy(threadContext);
        ConcreteJavaProxy.createConcreteJavaProxy(threadContext);
        ArrayJavaProxy.createArrayJavaProxy(threadContext);
        JavaProxyClass.createJavaProxyModule(ruby);
        JavaInterfaceTemplate.createJavaInterfaceTemplateModule(threadContext);
        RubyModule rubyModule2 = ruby.defineModule("JavaUtilities");
        rubyModule2.defineAnnotatedMethods(JavaUtilities.class);
        ruby.getJavaSupport().setConcreteProxyCallback(new Callback(){

            public IRubyObject execute(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
                Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, 1);
                return Java.concrete_proxy_inherited(iRubyObject, iRubyObjectArray[0]);
            }

            public Arity getArity() {
                return Arity.ONE_ARGUMENT;
            }
        });
        JavaArrayUtilities.createJavaArrayUtilitiesModule(ruby);
        RubyClass rubyClass = ruby.defineClass("JavaProxy", ruby.getObject(), ruby.getObject().getAllocator());
        rubyClass.defineAnnotatedMethods(JavaProxy.class);
        ruby.getArray().defineAnnotatedMethods(ArrayJavaAddons.class);
        ruby.getKernel().defineAnnotatedMethods(KernelJavaAddons.class);
        ruby.getString().defineAnnotatedMethods(StringJavaAddons.class);
        ruby.getIO().defineAnnotatedMethods(IOJavaAddons.class);
        Java.addNameClassMappings(ruby, ruby.getJavaSupport().getNameClassMap());
        ruby.getJavaSupport().setObjectJavaClass(JavaClass.get(ruby, Object.class));
        ruby.getJavaSupport().setActive(true);
        return rubyModule;
    }

    private static void addNameClassMappings(Ruby ruby, Map<String, JavaClass> map) {
        JavaClass javaClass = JavaClass.get(ruby, Boolean.TYPE);
        JavaClass javaClass2 = JavaClass.get(ruby, Boolean.class);
        map.put("boolean", javaClass);
        map.put("Boolean", javaClass2);
        map.put("java.lang.Boolean", javaClass2);
        JavaClass javaClass3 = JavaClass.get(ruby, Byte.TYPE);
        JavaClass javaClass4 = JavaClass.get(ruby, Byte.class);
        map.put("byte", javaClass3);
        map.put("Byte", javaClass4);
        map.put("java.lang.Byte", javaClass4);
        JavaClass javaClass5 = JavaClass.get(ruby, Short.TYPE);
        JavaClass javaClass6 = JavaClass.get(ruby, Short.class);
        map.put("short", javaClass5);
        map.put("Short", javaClass6);
        map.put("java.lang.Short", javaClass6);
        JavaClass javaClass7 = JavaClass.get(ruby, Character.TYPE);
        JavaClass javaClass8 = JavaClass.get(ruby, Character.class);
        map.put("char", javaClass7);
        map.put("Character", javaClass8);
        map.put("Char", javaClass8);
        map.put("java.lang.Character", javaClass8);
        JavaClass javaClass9 = JavaClass.get(ruby, Integer.TYPE);
        JavaClass javaClass10 = JavaClass.get(ruby, Integer.class);
        map.put("int", javaClass9);
        map.put("Integer", javaClass10);
        map.put("Int", javaClass10);
        map.put("java.lang.Integer", javaClass10);
        JavaClass javaClass11 = JavaClass.get(ruby, Long.TYPE);
        JavaClass javaClass12 = JavaClass.get(ruby, Long.class);
        map.put("long", javaClass11);
        map.put("Long", javaClass12);
        map.put("java.lang.Long", javaClass12);
        JavaClass javaClass13 = JavaClass.get(ruby, Float.TYPE);
        JavaClass javaClass14 = JavaClass.get(ruby, Float.class);
        map.put("float", javaClass13);
        map.put("Float", javaClass14);
        map.put("java.lang.Float", javaClass14);
        JavaClass javaClass15 = JavaClass.get(ruby, Double.TYPE);
        JavaClass javaClass16 = JavaClass.get(ruby, Double.class);
        map.put("double", javaClass15);
        map.put("Double", javaClass16);
        map.put("java.lang.Double", javaClass16);
        JavaClass javaClass17 = JavaClass.get(ruby, BigInteger.class);
        map.put("big_int", javaClass17);
        map.put("big_integer", javaClass17);
        map.put("BigInteger", javaClass17);
        map.put("java.math.BigInteger", javaClass17);
        JavaClass javaClass18 = JavaClass.get(ruby, BigDecimal.class);
        map.put("big_decimal", javaClass18);
        map.put("BigDecimal", javaClass18);
        map.put("java.math.BigDecimal", javaClass18);
        JavaClass javaClass19 = JavaClass.get(ruby, Object.class);
        map.put("object", javaClass19);
        map.put("Object", javaClass19);
        map.put("java.lang.Object", javaClass19);
        JavaClass javaClass20 = JavaClass.get(ruby, String.class);
        map.put("string", javaClass20);
        map.put("String", javaClass20);
        map.put("java.lang.String", javaClass20);
    }

    public static IRubyObject is_primitive_type(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return iRubyObject.getRuntime().newBoolean(JAVA_PRIMITIVES.containsKey(iRubyObject2.asJavaString()));
    }

    public static IRubyObject create_proxy_class(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        if (!(iRubyObject4 instanceof RubyModule)) {
            throw iRubyObject.getRuntime().newTypeError(iRubyObject4, iRubyObject.getRuntime().getModule());
        }
        return ((RubyModule)iRubyObject4).const_set(iRubyObject2, Java.get_proxy_class(iRubyObject, iRubyObject3));
    }

    public static IRubyObject get_java_class(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            return JavaClass.for_name(iRubyObject, iRubyObject2);
        }
        catch (Exception exception) {
            return iRubyObject.getRuntime().getNil();
        }
    }

    public static IRubyObject new_instance_for(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof JavaObject) {
            return Java.getInstance(((JavaObject)iRubyObject2).getValue(), (RubyClass)iRubyObject);
        }
        IRubyObject iRubyObject3 = ((RubyClass)iRubyObject).allocate();
        iRubyObject3.getInstanceVariables().fastSetInstanceVariable("@java_object", iRubyObject2);
        iRubyObject3.dataWrapStruct(iRubyObject2);
        return iRubyObject3;
    }

    public static IRubyObject getInstance(Object object, RubyClass rubyClass) {
        return rubyClass.getRuntime().getJavaSupport().getObjectProxyCache().getOrCreate(object, rubyClass);
    }

    public static IRubyObject getInstance(Ruby ruby, Object object) {
        if (object != null) {
            return ruby.getJavaSupport().getObjectProxyCache().getOrCreate(object, (RubyClass)Java.getProxyClass(ruby, JavaClass.get(ruby, object.getClass())));
        }
        return ruby.getNil();
    }

    public static IRubyObject to_java_object(IRubyObject iRubyObject) {
        return iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_class");
    }

    @Deprecated
    public static IRubyObject add_proxy_extender(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "JavaUtilities.add_proxy_extender is deprecated - use JavaUtilities.extend_proxy instead", "add_proxy_extender", "JavaUtilities.extend_proxy");
        IRubyObject iRubyObject3 = iRubyObject2.getInstanceVariables().fastGetInstanceVariable("@java_class");
        if (!(iRubyObject3 instanceof JavaClass)) {
            throw iRubyObject.getRuntime().newArgumentError("extender does not have a valid @java_class");
        }
        ((JavaClass)iRubyObject3).addProxyExtender(iRubyObject2);
        return iRubyObject.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getInterfaceModule(Ruby ruby, JavaClass javaClass) {
        if (!javaClass.javaClass().isInterface()) {
            throw ruby.newArgumentError(javaClass.toString() + " is not an interface");
        }
        RubyModule rubyModule = javaClass.getProxyModule();
        if (rubyModule != null) {
            return rubyModule;
        }
        javaClass.lockProxy();
        try {
            rubyModule = javaClass.getProxyModule();
            if (rubyModule == null) {
                rubyModule = (RubyModule)ruby.getJavaSupport().getJavaInterfaceTemplate().dup();
                rubyModule.fastSetInstanceVariable("@java_class", javaClass);
                Java.addToJavaPackageModule(rubyModule, javaClass);
                javaClass.setupInterfaceModule(rubyModule);
                Class<?>[] classArray = javaClass.javaClass().getInterfaces();
                int n = classArray.length;
                while (--n >= 0) {
                    JavaClass javaClass2 = JavaClass.get(ruby, classArray[n]);
                    RubyModule rubyModule2 = Java.getInterfaceModule(ruby, javaClass2);
                    rubyModule.includeModule(rubyModule2);
                }
            }
            Object var8_7 = null;
            javaClass.unlockProxy();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            javaClass.unlockProxy();
            throw throwable;
        }
        return rubyModule;
    }

    public static IRubyObject get_interface_module(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject2 instanceof RubyString) {
            javaClass = JavaClass.for_name(iRubyObject, iRubyObject2);
        } else if (iRubyObject2 instanceof JavaClass) {
            javaClass = (JavaClass)iRubyObject2;
        } else {
            throw ruby.newArgumentError("expected JavaClass, got " + iRubyObject2);
        }
        return Java.getInterfaceModule(ruby, javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject get_deprecated_interface_proxy(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass;
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject2 instanceof RubyString) {
            javaClass = JavaClass.for_name(iRubyObject, iRubyObject2);
        } else if (iRubyObject2 instanceof JavaClass) {
            javaClass = (JavaClass)iRubyObject2;
        } else {
            throw ruby.newArgumentError("expected JavaClass, got " + iRubyObject2);
        }
        if (!javaClass.javaClass().isInterface()) {
            throw ruby.newArgumentError("expected Java interface class, got " + iRubyObject2);
        }
        RubyClass rubyClass = javaClass.getProxyClass();
        if (rubyClass != null) {
            return rubyClass;
        }
        javaClass.lockProxy();
        try {
            rubyClass = javaClass.getProxyClass();
            if (rubyClass == null) {
                RubyModule rubyModule = Java.getInterfaceModule(ruby, javaClass);
                RubyClass rubyClass2 = ruby.fastGetClass("InterfaceJavaProxy");
                rubyClass = RubyClass.newClass(ruby, rubyClass2);
                rubyClass.setAllocator(rubyClass2.getAllocator());
                rubyClass.makeMetaClass(rubyClass2.getMetaClass());
                rubyClass.inherit(rubyClass2);
                rubyClass.callMethod(threadContext, "java_class=", javaClass);
                rubyClass.includeModule(rubyModule);
                javaClass.setupProxy(rubyClass);
                if (rubyClass.fastGetConstantAt("Includable") == null) {
                    rubyClass.fastSetConstant("Includable", rubyModule);
                }
            }
            Object var9_8 = null;
            javaClass.unlockProxy();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            javaClass.unlockProxy();
            throw throwable;
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getProxyClass(Ruby ruby, JavaClass javaClass) {
        RubyClass rubyClass = javaClass.getProxyClass();
        if (rubyClass != null) {
            return rubyClass;
        }
        Class clazz = javaClass.javaClass();
        if (clazz.isInterface()) {
            return Java.getInterfaceModule(ruby, javaClass);
        }
        javaClass.lockProxy();
        try {
            rubyClass = javaClass.getProxyClass();
            if (rubyClass == null) {
                if (clazz.isArray()) {
                    rubyClass = Java.createProxyClass(ruby, ruby.getJavaSupport().getArrayProxyClass(), javaClass, true);
                } else if (clazz.isPrimitive()) {
                    rubyClass = Java.createProxyClass(ruby, ruby.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                } else if (clazz == Object.class) {
                    rubyClass = Java.createProxyClass(ruby, ruby.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                    rubyClass.getMetaClass().defineFastMethod("inherited", ruby.getJavaSupport().getConcreteProxyCallback());
                    Java.addToJavaPackageModule(rubyClass, javaClass);
                } else {
                    rubyClass = Java.createProxyClass(ruby, (RubyClass)Java.getProxyClass(ruby, JavaClass.get(ruby, clazz.getSuperclass())), javaClass, false);
                    Class<?>[] classArray = clazz.getInterfaces();
                    int n = classArray.length;
                    while (--n >= 0) {
                        JavaClass javaClass2 = JavaClass.get(ruby, classArray[n]);
                        rubyClass.includeModule(Java.getInterfaceModule(ruby, javaClass2));
                    }
                    if (Modifier.isPublic(clazz.getModifiers())) {
                        Java.addToJavaPackageModule(rubyClass, javaClass);
                    }
                }
            }
            Object var8_7 = null;
            javaClass.unlockProxy();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            javaClass.unlockProxy();
            throw throwable;
        }
        return rubyClass;
    }

    public static IRubyObject get_proxy_class(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        JavaClass javaClass;
        Ruby ruby = iRubyObject.getRuntime();
        if (iRubyObject2 instanceof RubyString) {
            javaClass = JavaClass.for_name(iRubyObject, iRubyObject2);
        } else if (iRubyObject2 instanceof JavaClass) {
            javaClass = (JavaClass)iRubyObject2;
        } else {
            throw ruby.newTypeError(iRubyObject2, ruby.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(ruby, javaClass);
    }

    private static RubyClass createProxyClass(Ruby ruby, RubyClass rubyClass, JavaClass javaClass, boolean bl) {
        RubyClass rubyClass2 = javaClass.getProxyClass();
        if (rubyClass2 != null) {
            return rubyClass2;
        }
        RubyClass.checkInheritable(rubyClass);
        RubyClass rubyClass3 = rubyClass;
        rubyClass2 = RubyClass.newClass(ruby, rubyClass3);
        rubyClass2.makeMetaClass(rubyClass3.getMetaClass());
        rubyClass2.setAllocator(rubyClass3.getAllocator());
        if (bl) {
            rubyClass2.inherit(rubyClass3);
        }
        rubyClass2.callMethod(ruby.getCurrentContext(), "java_class=", javaClass);
        javaClass.setupProxy(rubyClass2);
        return rubyClass2;
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        JavaSupport javaSupport = ruby.getJavaSupport();
        RubyClass rubyClass = javaSupport.getJavaProxyClass().getMetaClass();
        RuntimeHelpers.invokeAs(threadContext, rubyClass, iRubyObject, "inherited", new IRubyObject[]{iRubyObject2}, CallType.SUPER, Block.NULL_BLOCK);
        return Java.setupJavaSubclass(threadContext, iRubyObject2, iRubyObject.callMethod(threadContext, "java_class"));
    }

    private static IRubyObject setupJavaSubclass(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        if (!(iRubyObject instanceof RubyClass)) {
            throw ruby.newTypeError(iRubyObject, ruby.getClassClass());
        }
        RubyClass rubyClass = (RubyClass)iRubyObject;
        rubyClass.getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", ruby.getNil());
        RubyClass rubyClass2 = rubyClass.getSingletonClass();
        rubyClass2.addReadWriteAttribute(threadContext, "java_proxy_class");
        rubyClass2.addMethod("java_interfaces", new JavaMethod.JavaMethodZero(rubyClass2, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string) {
                IRubyObject iRubyObject2 = iRubyObject.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                if (iRubyObject2 != null) {
                    return iRubyObject2.dup();
                }
                return threadContext.getRuntime().getNil();
            }
        });
        rubyClass.addMethod("__jcreate!", new JavaMethod.JavaMethodNoBlock(rubyClass2, Visibility.PUBLIC){
            private final Map<Integer, ParameterTypes> methodCache = new HashMap<Integer, ParameterTypes>();

            public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray) {
                Object[] objectArray;
                IRubyObject iRubyObject2 = iRubyObject.getMetaClass().getInstanceVariables().fastGetInstanceVariable("@java_proxy_class");
                if (iRubyObject2 == null || iRubyObject2.isNil()) {
                    iRubyObject2 = JavaProxyClass.get_with_class(iRubyObject, iRubyObject.getMetaClass());
                    iRubyObject.getMetaClass().getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", iRubyObject2);
                }
                JavaProxyClass javaProxyClass = (JavaProxyClass)iRubyObject2;
                RubyArray rubyArray = javaProxyClass.constructors();
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                for (int i = 0; i < rubyArray.size(); ++i) {
                    objectArray = (Object[])rubyArray.eltInternal(i);
                    if (objectArray.getParameterTypes().length != iRubyObjectArray.length) continue;
                    arrayList.add(objectArray);
                }
                if (arrayList.size() == 0) {
                    throw threadContext.getRuntime().newArgumentError("wrong # of arguments for constructor");
                }
                JavaProxyConstructor javaProxyConstructor = (JavaProxyConstructor)Java.matchingCallableArityN(iRubyObject, this.methodCache, arrayList.toArray(new JavaProxyConstructor[arrayList.size()]), iRubyObjectArray, iRubyObjectArray.length);
                objectArray = new Object[iRubyObjectArray.length];
                Class<?>[] classArray = javaProxyConstructor.getParameterTypes();
                for (int i = 0; i < iRubyObjectArray.length; ++i) {
                    objectArray[i] = JavaUtil.convertArgumentToType(threadContext, iRubyObjectArray[i], classArray[i]);
                }
                JavaObject javaObject = javaProxyConstructor.newInstance(iRubyObject, objectArray);
                return JavaUtilities.set_java_object(iRubyObject, iRubyObject, javaObject);
            }
        });
        return ruby.getNil();
    }

    private static void addToJavaPackageModule(RubyModule rubyModule, JavaClass javaClass) {
        String string;
        String string2;
        Class clazz = javaClass.javaClass();
        String string3 = clazz.getName();
        if (string3 == null) {
            return;
        }
        int n = string3.lastIndexOf(46);
        if (string3.indexOf(36) != -1 || !Character.isUpperCase(string3.charAt(n + 1))) {
            return;
        }
        Ruby ruby = rubyModule.getRuntime();
        RubyModule rubyModule2 = Java.getJavaPackageModule(ruby, string2 = n < 0 ? "" : string3.substring(0, n));
        if (rubyModule2 != null && rubyModule2.getConstantAt(string = string3.substring(n + 1)) == null) {
            rubyModule2.const_set(ruby.newSymbol(string), rubyModule);
        }
    }

    private static RubyModule getJavaPackageModule(Ruby ruby, String string) {
        Serializable serializable;
        String string2;
        int n = string.length();
        if (n == 0) {
            string2 = "Default";
        } else {
            serializable = new StringBuilder();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                n3 = string.indexOf(46, n2);
                if (n3 == -1) {
                    n3 = n;
                }
                ((StringBuilder)serializable).append(Character.toUpperCase(string.charAt(n2))).append(string.substring(n2 + 1, n3));
                n2 = n3 + 1;
            }
            string2 = ((StringBuilder)serializable).toString();
        }
        serializable = ruby.getJavaSupport().getJavaModule();
        IRubyObject iRubyObject = ((RubyModule)serializable).getConstantAt(string2);
        if (iRubyObject == null) {
            return Java.createPackageModule((RubyModule)serializable, string2, string);
        }
        if (iRubyObject instanceof RubyModule) {
            return (RubyModule)iRubyObject;
        }
        return null;
    }

    private static RubyModule createPackageModule(RubyModule rubyModule, String string, String string2) {
        Ruby ruby = rubyModule.getRuntime();
        RubyModule rubyModule2 = (RubyModule)ruby.getJavaSupport().getPackageModuleTemplate().dup();
        rubyModule2.fastSetInstanceVariable("@package_name", ruby.newString(string2.length() > 0 ? string2 + '.' : string2));
        rubyModule2.addClassProvider(JAVA_PACKAGE_CLASS_PROVIDER);
        rubyModule.const_set(ruby.newSymbol(string), rubyModule2);
        MetaClass metaClass = (MetaClass)rubyModule2.getMetaClass();
        metaClass.setAttached(rubyModule2);
        return rubyModule2;
    }

    public static RubyModule getPackageModule(Ruby ruby, String string) {
        String string2;
        RubyModule rubyModule = ruby.getJavaSupport().getJavaModule();
        IRubyObject iRubyObject = rubyModule.getConstantAt(string);
        if (iRubyObject instanceof RubyModule) {
            return (RubyModule)iRubyObject;
        }
        if ("Default".equals(string)) {
            string2 = "";
        } else {
            Matcher matcher = CAMEL_CASE_PACKAGE_SPLITTER.matcher(string);
            string2 = matcher.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(rubyModule, string, string2);
    }

    public static IRubyObject get_package_module(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.getPackageModule(iRubyObject.getRuntime(), iRubyObject2.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        RubyModule rubyModule = Java.getJavaPackageModule(ruby, iRubyObject2.asJavaString());
        return rubyModule == null ? ruby.getNil() : rubyModule;
    }

    public static RubyModule getProxyOrPackageUnderPackage(ThreadContext threadContext, final Ruby ruby, RubyModule rubyModule, String string) {
        IRubyObject iRubyObject = rubyModule.fastGetInstanceVariable("@package_name");
        if (iRubyObject == null) {
            throw ruby.newArgumentError("invalid package module");
        }
        String string2 = iRubyObject.asJavaString();
        String string3 = string.trim().intern();
        if (string3.length() == 0) {
            throw ruby.newArgumentError("empty class or package name");
        }
        String string4 = string2 + string3;
        if (Character.isLowerCase(string3.charAt(0))) {
            Object object;
            if (JAVA_PRIMITIVES.containsKey(string3)) {
                throw ruby.newArgumentError("illegal package name component: " + string3);
            }
            try {
                return Java.getProxyClass(ruby, JavaClass.forNameQuiet(ruby, string4));
            }
            catch (RaiseException raiseException) {
                object = raiseException.getException();
                if (((RubyObject)object).kind_of_p(threadContext, ruby.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(ruby, ruby.getNil());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            RubyModule rubyModule2 = Java.getJavaPackageModule(ruby, string4);
            if (rubyModule2 == null) {
                return null;
            }
            object = ("@__pkg__" + string3).intern();
            rubyModule.fastSetInstanceVariable((String)object, rubyModule2);
            RubyClass rubyClass = rubyModule.getSingletonClass();
            rubyClass.addMethod(string3, new org.jruby.nb.internal.runtime.methods.JavaMethod(rubyClass, Visibility.PUBLIC, (String)object){
                final /* synthetic */ String val$ivarName;
                {
                    this.val$ivarName = string;
                    super(rubyModule, visibility);
                }

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    IRubyObject iRubyObject2;
                    if (iRubyObjectArray.length != 0) {
                        Arity.raiseArgumentError(ruby, iRubyObjectArray.length, 0, 0);
                    }
                    if ((iRubyObject2 = ((RubyModule)iRubyObject).fastGetInstanceVariable(this.val$ivarName)) != null) {
                        return iRubyObject2;
                    }
                    return ruby.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return rubyModule2;
        }
        return Java.getProxyClass(ruby, JavaClass.forNameVerbose(ruby, string4));
    }

    public static IRubyObject get_proxy_or_package_under_package(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Ruby ruby = iRubyObject.getRuntime();
        if (!(iRubyObject2 instanceof RubyModule)) {
            throw ruby.newTypeError(iRubyObject2, ruby.getModule());
        }
        RubyModule rubyModule = Java.getProxyOrPackageUnderPackage(threadContext, ruby, (RubyModule)iRubyObject2, iRubyObject3.asJavaString());
        if (rubyModule != null) {
            return rubyModule;
        }
        return ruby.getNil();
    }

    public static RubyModule getTopLevelProxyOrPackage(ThreadContext threadContext, final Ruby ruby, String string) {
        String string2 = string.trim().intern();
        if (string2.length() == 0) {
            throw ruby.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(string2.charAt(0))) {
            RubyObject rubyObject;
            try {
                return Java.getProxyClass(ruby, JavaClass.forNameQuiet(ruby, string2));
            }
            catch (RaiseException raiseException) {
                rubyObject = raiseException.getException();
                if (rubyObject.kind_of_p(threadContext, ruby.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(ruby, ruby.getNil());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            RubyModule rubyModule = Java.getJavaPackageModule(ruby, string2);
            if (rubyModule == null) {
                return null;
            }
            rubyObject = ruby.getJavaSupport().getJavaModule();
            if (rubyObject.getMetaClass().isMethodBound(string2, false)) {
                return rubyModule;
            }
            final String string3 = ("@__pkg__" + string2).intern();
            rubyObject.fastSetInstanceVariable(string3, rubyModule);
            RubyClass rubyClass = rubyObject.getSingletonClass();
            rubyClass.addMethod(string2, new org.jruby.nb.internal.runtime.methods.JavaMethod(rubyClass, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    IRubyObject iRubyObject2;
                    if (iRubyObjectArray.length != 0) {
                        Arity.raiseArgumentError(ruby, iRubyObjectArray.length, 0, 0);
                    }
                    if ((iRubyObject2 = ((RubyModule)iRubyObject).fastGetInstanceVariable(string3)) != null) {
                        return iRubyObject2;
                    }
                    return ruby.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return rubyModule;
        }
        try {
            return Java.getProxyClass(ruby, JavaClass.forNameQuiet(ruby, string2));
        }
        catch (RaiseException raiseException) {
            RubyException rubyException = raiseException.getException();
            if (rubyException.kind_of_p(threadContext, ruby.getStandardError()).isTrue()) {
                RuntimeHelpers.setErrorInfo(ruby, ruby.getNil());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Java.getPackageModule(ruby, string2);
    }

    public static IRubyObject get_top_level_proxy_or_package(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        RubyModule rubyModule = Java.getTopLevelProxyOrPackage(threadContext, ruby, iRubyObject2.asJavaString());
        if (rubyModule != null) {
            return rubyModule;
        }
        return ruby.getNil();
    }

    public static IRubyObject matching_method(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        Map map = iRubyObject.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arrayList = new ArrayList();
        int n = ((RubyArray)iRubyObject3).getLength();
        IRubyObject[] iRubyObjectArray = ((RubyArray)iRubyObject3).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < n; ++i) {
            if (iRubyObjectArray[i] instanceof JavaObject) {
                arrayList.add(((JavaClass)((JavaObject)iRubyObjectArray[i]).java_class()).javaClass());
                continue;
            }
            arrayList.add(iRubyObjectArray[i].getClass());
        }
        HashMap hashMap = (HashMap)map.get(iRubyObject2);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(iRubyObject2, hashMap);
        } else {
            IRubyObject iRubyObject4 = (IRubyObject)hashMap.get(arrayList);
            if (iRubyObject4 != null) {
                return iRubyObject4;
            }
        }
        int n2 = ((RubyArray)iRubyObject2).getLength();
        IRubyObject[] iRubyObjectArray2 = ((RubyArray)iRubyObject2).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < n2; ++j) {
                IRubyObject iRubyObject5 = iRubyObjectArray2[j];
                List<Class<?>> list = Arrays.asList(((ParameterTypes)((Object)iRubyObject5)).getParameterTypes());
                if (arrayList.size() != list.size()) continue;
                if (((Object)list).equals(arrayList)) {
                    hashMap.put(arrayList, iRubyObject5);
                    return iRubyObject5;
                }
                boolean bl = true;
                for (int k = 0; k < list.size(); ++k) {
                    if (JavaClass.assignable(list.get(k), (Class)arrayList.get(k)) && (i > 0 || Java.primitive_match(list.get(k), arrayList.get(k))) || JavaUtil.isDuckTypeConvertable((Class)arrayList.get(k), list.get(k))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                hashMap.put(arrayList, iRubyObject5);
                return iRubyObject5;
            }
        }
        IRubyObject iRubyObject6 = iRubyObjectArray2[0];
        if (iRubyObject6 instanceof JavaConstructor || iRubyObject6 instanceof JavaProxyConstructor) {
            throw iRubyObject.getRuntime().newNameError("no constructor with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
        }
        throw iRubyObject.getRuntime().newNameError("no " + ((JavaMethod)iRubyObject6).name() + " with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
    }

    public static int argsHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            n = 31 * n + (object == null ? 0 : object.getClass().hashCode());
        }
        return n;
    }

    public static int argsHashCode(Class[] classArray) {
        if (classArray == null) {
            return 0;
        }
        int n = 1;
        for (Class clazz : classArray) {
            n = 31 * n + (clazz == null ? 0 : clazz.hashCode());
        }
        return n;
    }

    public static int argsHashCode(IRubyObject iRubyObject) {
        return 31 + Java.classHashCode(iRubyObject);
    }

    public static int argsHashCode(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return 31 * (31 + Java.classHashCode(iRubyObject)) + Java.classHashCode(iRubyObject2);
    }

    public static int argsHashCode(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return 31 * (31 * (31 + Java.classHashCode(iRubyObject)) + Java.classHashCode(iRubyObject2)) + Java.classHashCode(iRubyObject3);
    }

    public static int argsHashCode(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        return 31 * (31 * (31 * (31 + Java.classHashCode(iRubyObject)) + Java.classHashCode(iRubyObject2)) + Java.classHashCode(iRubyObject3)) + Java.classHashCode(iRubyObject4);
    }

    private static int classHashCode(IRubyObject iRubyObject) {
        return iRubyObject == null ? 0 : iRubyObject.getJavaClass().hashCode();
    }

    public static int argsHashCode(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray == null) {
            return 0;
        }
        int n = 1;
        for (IRubyObject iRubyObject : iRubyObjectArray) {
            n = 31 * n + Java.classHashCode(iRubyObject);
        }
        return n;
    }

    public static Class argClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        return object.getClass();
    }

    public static Class argClass(IRubyObject iRubyObject) {
        if (iRubyObject == null) {
            return Void.TYPE;
        }
        return iRubyObject.getJavaClass();
    }

    public static JavaCallable matching_method_internal(IRubyObject iRubyObject, Map map, JavaCallable[] javaCallableArray, Object[] objectArray, int n) {
        int n2;
        int n3;
        Object object;
        int n4;
        int n5 = Java.argsHashCode(objectArray);
        JavaCallable javaCallable = (JavaCallable)map.get(n5);
        if (javaCallable != null) {
            return javaCallable;
        }
        int n6 = javaCallableArray.length;
        block0: for (n4 = 0; n4 < n6; ++n4) {
            javaCallable = javaCallableArray[n4];
            object = javaCallable.getParameterTypes();
            if (n != ((Class<?>[])object).length) continue;
            n3 = 1;
            int n7 = n;
            for (n2 = 0; n2 < n7; ++n2) {
                if (object[n2].equals(Java.argClass(objectArray[n2]))) continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                map.put(n5, javaCallable);
                return javaCallable;
            }
            n7 = n;
            for (n2 = 0; n2 < n7; ++n2) {
                if (!JavaClass.assignable(object[n2], Java.argClass(objectArray[n2])) || !Java.primitive_match(object[n2], Java.argClass(objectArray[n2]))) continue block0;
            }
            map.put(n5, javaCallable);
            return javaCallable;
        }
        block3: for (n4 = 0; n4 < n6; ++n4) {
            javaCallable = javaCallableArray[n4];
            object = javaCallable.getParameterTypes();
            if (n != ((Class<?>[])object).length) continue;
            n2 = n;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!JavaClass.assignable(object[n3], Java.argClass(objectArray[n3])) && !JavaUtil.isDuckTypeConvertable(Java.argClass(objectArray[n3]), (Class)object[n3])) continue block3;
            }
            map.put(n5, javaCallable);
            return javaCallable;
        }
        JavaCallable javaCallable2 = javaCallableArray[0];
        object = new ArrayList(objectArray.length);
        for (Object object2 : objectArray) {
            ((ArrayList)object).add(Java.argClass(object2));
        }
        if (javaCallable2 instanceof JavaConstructor || javaCallable2 instanceof JavaProxyConstructor) {
            throw iRubyObject.getRuntime().newNameError("no constructor with arguments matching " + object + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
        }
        Thread.dumpStack();
        throw iRubyObject.getRuntime().newNameError("no " + ((JavaMethod)javaCallable2).name() + " with arguments matching " + object + " on object " + iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "inspect"), null);
    }

    private static JavaCallable findMatchingCallableForArgs(IRubyObject iRubyObject, Map map, int n, JavaCallable[] javaCallableArray, IRubyObject ... iRubyObjectArray) {
        JavaCallable javaCallable = Java.findCallable(javaCallableArray, Exact, iRubyObjectArray);
        if (javaCallable == null) {
            javaCallable = Java.findCallable(javaCallableArray, AssignableAndPrimitivable, iRubyObjectArray);
        }
        if (javaCallable == null) {
            javaCallable = Java.findCallable(javaCallableArray, AssignableOrDuckable, iRubyObjectArray);
        }
        if (javaCallable == null) {
            throw Java.argTypesDoNotMatch(iRubyObject.getRuntime(), iRubyObject, javaCallableArray, iRubyObjectArray);
        }
        map.put(n, javaCallable);
        return javaCallable;
    }

    public static ParameterTypes matchingCallableArityN(IRubyObject iRubyObject, Map map, ParameterTypes[] parameterTypesArray, IRubyObject[] iRubyObjectArray, int n) {
        int n2 = Java.argsHashCode(iRubyObjectArray);
        ParameterTypes parameterTypes = (ParameterTypes)map.get(n2);
        if (parameterTypes == null) {
            parameterTypes = Java.findMatchingCallableForArgs(iRubyObject, map, n2, parameterTypesArray, iRubyObjectArray);
        }
        return parameterTypes;
    }

    private static ParameterTypes findMatchingCallableForArgs(IRubyObject iRubyObject, Map map, int n, ParameterTypes[] parameterTypesArray, IRubyObject ... iRubyObjectArray) {
        ParameterTypes parameterTypes = Java.findCallable(parameterTypesArray, Exact, iRubyObjectArray);
        if (parameterTypes == null) {
            parameterTypes = Java.findCallable(parameterTypesArray, AssignableAndPrimitivable, iRubyObjectArray);
        }
        if (parameterTypes == null) {
            parameterTypes = Java.findCallable(parameterTypesArray, AssignableOrDuckable, iRubyObjectArray);
        }
        if (parameterTypes == null) {
            throw Java.argTypesDoNotMatch(iRubyObject.getRuntime(), iRubyObject, parameterTypesArray, iRubyObjectArray);
        }
        map.put(n, parameterTypes);
        return parameterTypes;
    }

    private static ParameterTypes findCallable(ParameterTypes[] parameterTypesArray, CallableAcceptor callableAcceptor, IRubyObject ... iRubyObjectArray) {
        ParameterTypes parameterTypes = null;
        int n = -1;
        for (int i = 0; i < parameterTypesArray.length; ++i) {
            int n2;
            ParameterTypes parameterTypes2 = parameterTypesArray[i];
            Class<?>[] classArray = parameterTypes2.getParameterTypes();
            if (!callableAcceptor.accept(classArray, iRubyObjectArray) || (n2 = Java.getExactnessScore(classArray, iRubyObjectArray)) <= n) continue;
            parameterTypes = parameterTypes2;
            n = n2;
        }
        return parameterTypes;
    }

    private static int getExactnessScore(Class<?>[] classArray, IRubyObject[] iRubyObjectArray) {
        int n = 0;
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            if (classArray[i].equals(Java.argClass(iRubyObjectArray[i]))) continue;
            ++n;
        }
        return n;
    }

    private static RaiseException argTypesDoNotMatch(Ruby ruby, IRubyObject iRubyObject, ParameterTypes[] parameterTypesArray, IRubyObject ... iRubyObjectArray) {
        ParameterTypes parameterTypes = parameterTypesArray[0];
        ArrayList<Class> arrayList = new ArrayList<Class>(iRubyObjectArray.length);
        for (IRubyObject iRubyObject2 : iRubyObjectArray) {
            arrayList.add(Java.argClass((Object)iRubyObject2));
        }
        if (parameterTypes instanceof JavaConstructor || parameterTypes instanceof JavaProxyConstructor) {
            throw ruby.newNameError("no constructor with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(ruby.getCurrentContext(), "inspect"), null);
        }
        throw ruby.newNameError("no " + ((JavaMethod)parameterTypes).name() + " with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(ruby.getCurrentContext(), "inspect"), null);
    }

    public static JavaCallable matchingCallableArityN(IRubyObject iRubyObject, Map map, JavaCallable[] javaCallableArray, IRubyObject[] iRubyObjectArray, int n) {
        int n2 = Java.argsHashCode(iRubyObjectArray);
        JavaCallable javaCallable = (JavaCallable)map.get(n2);
        if (javaCallable == null) {
            javaCallable = Java.findMatchingCallableForArgs(iRubyObject, map, n2, javaCallableArray, iRubyObjectArray);
        }
        return javaCallable;
    }

    public static JavaCallable matchingCallableArityOne(IRubyObject iRubyObject, Map map, JavaCallable[] javaCallableArray, IRubyObject iRubyObject2) {
        int n = Java.argsHashCode(iRubyObject2);
        JavaCallable javaCallable = (JavaCallable)map.get(n);
        if (javaCallable == null) {
            javaCallable = Java.findMatchingCallableForArgs(iRubyObject, map, n, javaCallableArray, iRubyObject2);
        }
        return javaCallable;
    }

    public static JavaCallable matchingCallableArityTwo(IRubyObject iRubyObject, Map map, JavaCallable[] javaCallableArray, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        int n = Java.argsHashCode(iRubyObject2, iRubyObject3);
        JavaCallable javaCallable = (JavaCallable)map.get(n);
        if (javaCallable == null) {
            javaCallable = Java.findMatchingCallableForArgs(iRubyObject, map, n, javaCallableArray, iRubyObject2, iRubyObject3);
        }
        return javaCallable;
    }

    public static JavaCallable matchingCallableArityThree(IRubyObject iRubyObject, Map map, JavaCallable[] javaCallableArray, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        int n = Java.argsHashCode(iRubyObject2, iRubyObject3, iRubyObject4);
        JavaCallable javaCallable = (JavaCallable)map.get(n);
        if (javaCallable == null) {
            javaCallable = Java.findMatchingCallableForArgs(iRubyObject, map, n, javaCallableArray, iRubyObject2, iRubyObject3, iRubyObject4);
        }
        return javaCallable;
    }

    public static JavaCallable matchingCallableArityFour(IRubyObject iRubyObject, Map map, JavaCallable[] javaCallableArray, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5) {
        int n = Java.argsHashCode(iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5);
        JavaCallable javaCallable = (JavaCallable)map.get(n);
        if (javaCallable == null) {
            javaCallable = Java.findMatchingCallableForArgs(iRubyObject, map, n, javaCallableArray, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5);
        }
        return javaCallable;
    }

    private static JavaCallable findCallable(JavaCallable[] javaCallableArray, CallableAcceptor callableAcceptor, IRubyObject ... iRubyObjectArray) {
        for (int i = 0; i < javaCallableArray.length; ++i) {
            JavaCallable javaCallable = javaCallableArray[i];
            Class<?>[] classArray = javaCallable.getParameterTypes();
            if (!callableAcceptor.accept(classArray, iRubyObjectArray)) continue;
            return javaCallable;
        }
        return null;
    }

    private static boolean exactMatch(Class[] classArray, IRubyObject ... iRubyObjectArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].equals(Java.argClass(iRubyObjectArray[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivable(Class[] classArray, IRubyObject ... iRubyObjectArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (Java.assignable(classArray[i], iRubyObjectArray[i]) && Java.primitivable(classArray[i], iRubyObjectArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableOrDuckable(Class[] classArray, IRubyObject ... iRubyObjectArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (Java.assignable(classArray[i], iRubyObjectArray[i]) || Java.duckable(classArray[i], iRubyObjectArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignable(Class clazz, IRubyObject iRubyObject) {
        return JavaClass.assignable(clazz, Java.argClass(iRubyObject));
    }

    private static boolean primitivable(Class clazz, IRubyObject iRubyObject) {
        Class clazz2 = Java.argClass(iRubyObject);
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE || clazz == Character.TYPE) {
                return clazz2 == Long.TYPE || clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Character.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.class || clazz2 == Byte.class || clazz2 == Short.class || clazz2 == Character.class || clazz2 == Integer.class;
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE) {
                return clazz2 == Double.TYPE || clazz2 == Float.TYPE || clazz2 == Float.class || clazz2 == Double.class;
            }
            if (clazz == Boolean.TYPE) {
                return clazz2 == Boolean.TYPE || clazz2 == Boolean.class;
            }
        }
        return false;
    }

    private static boolean duckable(Class clazz, IRubyObject iRubyObject) {
        return JavaUtil.isDuckTypeConvertable(Java.argClass(iRubyObject), clazz);
    }

    private static RaiseException argTypesDoNotMatch(Ruby ruby, IRubyObject iRubyObject, JavaCallable[] javaCallableArray, IRubyObject ... iRubyObjectArray) {
        JavaCallable javaCallable = javaCallableArray[0];
        ArrayList<Class> arrayList = new ArrayList<Class>(iRubyObjectArray.length);
        for (IRubyObject iRubyObject2 : iRubyObjectArray) {
            arrayList.add(Java.argClass((Object)iRubyObject2));
        }
        if (javaCallable instanceof JavaConstructor || javaCallable instanceof JavaProxyConstructor) {
            throw ruby.newNameError("no constructor with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(ruby.getCurrentContext(), "inspect"), null);
        }
        throw ruby.newNameError("no " + ((JavaMethod)javaCallable).name() + " with arguments matching " + arrayList + " on object " + iRubyObject.callMethod(ruby.getCurrentContext(), "inspect"), null);
    }

    public static IRubyObject access(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = ((JavaClass)iRubyObject2).javaClass().getModifiers();
        return iRubyObject.getRuntime().newString(Modifier.isPublic(n) ? "public" : (Modifier.isProtected(n) ? "protected" : "private"));
    }

    public static IRubyObject valid_constant_name_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyString rubyString = iRubyObject2.convertToString();
        if (rubyString.getByteList().length() == 0) {
            return iRubyObject.getRuntime().getFalse();
        }
        return Character.isUpperCase(rubyString.getByteList().charAt(0)) ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
    }

    public static boolean primitive_match(Object object, Object object2) {
        if (((Class)object).isPrimitive()) {
            if (object == Integer.TYPE || object == Long.TYPE || object == Short.TYPE || object == Character.TYPE) {
                return object2 == Integer.class || object2 == Long.class || object2 == Short.class || object2 == Character.class;
            }
            if (object == Float.TYPE || object == Double.TYPE) {
                return object2 == Float.class || object2 == Double.class;
            }
            if (object == Boolean.TYPE) {
                return object2 == Boolean.class;
            }
            return false;
        }
        return true;
    }

    public static IRubyObject primitive_match(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        if (((JavaClass)iRubyObject2).primitive_p().isTrue()) {
            Object object;
            Object object2 = ((JavaObject)iRubyObject2).getValue();
            return Java.primitive_match(object2, object = ((JavaObject)iRubyObject3).getValue()) ? iRubyObject.getRuntime().getTrue() : iRubyObject.getRuntime().getFalse();
        }
        return iRubyObject.getRuntime().getTrue();
    }

    public static IRubyObject wrap(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Java.getInstance(iRubyObject.getRuntime(), ((JavaObject)iRubyObject2).getValue());
    }

    public static IRubyObject wrap(Ruby ruby, IRubyObject iRubyObject) {
        return Java.getInstance(ruby, ((JavaObject)iRubyObject).getValue());
    }

    @JRubyMethod(required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_exception_handler(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        String string = iRubyObjectArray[0].toString();
        RubyProc rubyProc = null;
        rubyProc = iRubyObjectArray.length > 1 ? (RubyProc)iRubyObjectArray[1] : iRubyObject.getRuntime().newProc(Block.Type.PROC, block);
        iRubyObject.getRuntime().getJavaSupport().defineExceptionHandler(string, rubyProc);
        return iRubyObject;
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject primitive_to_java(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return JavaUtil.primitive_to_java(iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return JavaUtil.java_to_ruby(iRubyObject.getRuntime(), iRubyObject2);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return JavaUtil.ruby_to_java(iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return JavaUtil.java_to_primitive(iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    @Deprecated
    public static IRubyObject new_proxy_instance(final IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyProc rubyProc;
        int n = Arity.checkArgumentCount(iRubyObject.getRuntime(), iRubyObjectArray, 1, -1) - 1;
        if (iRubyObjectArray[n] instanceof RubyProc) {
            rubyProc = (RubyProc)iRubyObjectArray[n];
        } else {
            rubyProc = iRubyObject.getRuntime().newProc(Block.Type.PROC, block);
            ++n;
        }
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            if (!(iRubyObjectArray[i] instanceof JavaClass) || !((JavaClass)iRubyObjectArray[i]).interface_p().isTrue()) {
                throw iRubyObject.getRuntime().newArgumentError("Java interface expected. got: " + iRubyObjectArray[i]);
            }
            classArray[i] = ((JavaClass)iRubyObjectArray[i]).javaClass();
        }
        return JavaObject.wrap(iRubyObject.getRuntime(), Proxy.newProxyInstance(iRubyObject.getRuntime().getJRubyClassLoader(), classArray, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                Class[] classArray = (Class[])this.parameterTypeCache.get(method);
                if (classArray == null) {
                    classArray = method.getParameterTypes();
                    this.parameterTypeCache.put(method, classArray);
                }
                int n = classArray.length;
                String string = method.getName();
                if (string.equals("toString") && n == 0) {
                    return object.getClass().getName();
                }
                if (string.equals("hashCode") && n == 0) {
                    return new Integer(object.getClass().hashCode());
                }
                if (string.equals("equals") && n == 1 && classArray[0].equals(Object.class)) {
                    return object == objectArray[0];
                }
                Ruby ruby = iRubyObject.getRuntime();
                int n2 = objectArray == null ? 0 : objectArray.length;
                IRubyObject[] iRubyObjectArray = new IRubyObject[n2 + 2];
                iRubyObjectArray[0] = JavaObject.wrap(ruby, object);
                iRubyObjectArray[1] = new JavaMethod(ruby, method);
                for (int i = 0; i < n2; ++i) {
                    iRubyObjectArray[i + 2] = JavaObject.wrap(ruby, objectArray[i]);
                }
                return JavaUtil.convertArgument(ruby, rubyProc.call(ruby.getCurrentContext(), iRubyObjectArray), method.getReturnType());
            }
        }));
    }

    @JRubyMethod(required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance2(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        Class clazz;
        int n;
        IRubyObject[] iRubyObjectArray = ((RubyArray)iRubyObject3).toJavaArray();
        Ruby ruby = iRubyObject.getRuntime();
        Class[] classArray = new Class[iRubyObjectArray.length];
        for (n = 0; n < iRubyObjectArray.length; ++n) {
            if (!(iRubyObjectArray[n] instanceof JavaClass) || !((JavaClass)iRubyObjectArray[n]).interface_p().isTrue()) {
                throw iRubyObject.getRuntime().newArgumentError("Java interface expected. got: " + iRubyObjectArray[n]);
            }
            classArray[n] = ((JavaClass)iRubyObjectArray[n]).javaClass();
        }
        n = Java.argsHashCode(classArray);
        n = iRubyObject2.getMetaClass().isSingleton() && iRubyObject2.getMetaClass().getRealClass() == ruby.getProc() ? 31 * n + ruby.getProc().hashCode() : 31 * n + iRubyObject2.getMetaClass().hashCode();
        String string = "InterfaceImpl" + n;
        try {
            clazz = Class.forName(string, true, ruby.getJRubyClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = MiniJava.createOldStyleImplClass(classArray, iRubyObject2.getMetaClass(), ruby, string);
        }
        try {
            Constructor constructor = clazz.getConstructor(IRubyObject.class);
            return JavaObject.wrap(iRubyObject.getRuntime(), constructor.newInstance(iRubyObject2));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ruby.newTypeError("Exception instantiating generated interface impl:\n" + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ruby.newTypeError("Exception instantiating generated interface impl:\n" + invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw ruby.newTypeError("Exception instantiating generated interface impl:\n" + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ruby.newTypeError("Exception instantiating generated interface impl:\n" + illegalAccessException);
        }
    }

    static {
        String[] stringArray;
        JAVA_PACKAGE_CLASS_PROVIDER = new ClassProvider(){

            public RubyClass defineClassUnder(RubyModule rubyModule, String string, RubyClass rubyClass) {
                if (rubyClass != null) {
                    return null;
                }
                IRubyObject iRubyObject = rubyModule.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (iRubyObject == null) {
                    return null;
                }
                Ruby ruby = rubyModule.getRuntime();
                return (RubyClass)Java.get_proxy_class(ruby.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(ruby, iRubyObject.asJavaString() + string));
            }

            public RubyModule defineModuleUnder(RubyModule rubyModule, String string) {
                IRubyObject iRubyObject = rubyModule.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (iRubyObject == null) {
                    return null;
                }
                Ruby ruby = rubyModule.getRuntime();
                return (RubyModule)Java.get_interface_module(ruby.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(ruby, iRubyObject.asJavaString() + string));
            }
        };
        JAVA_PRIMITIVES = new HashMap<String, Boolean>();
        for (String string : stringArray = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"}) {
            JAVA_PRIMITIVES.put(string, Boolean.TRUE);
        }
        CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        Exact = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] classArray, IRubyObject[] iRubyObjectArray) {
                return Java.exactMatch(classArray, iRubyObjectArray);
            }
        };
        AssignableAndPrimitivable = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] classArray, IRubyObject[] iRubyObjectArray) {
                return Java.assignableAndPrimitivable(classArray, iRubyObjectArray);
            }
        };
        AssignableOrDuckable = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] classArray, IRubyObject[] iRubyObjectArray) {
                return Java.assignableOrDuckable(classArray, iRubyObjectArray);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CallableAcceptor {
        public boolean accept(Class<?>[] var1, IRubyObject[] var2);
    }

    @JRubyModule(name={"JavaUtilities"})
    public static class JavaUtilities {
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject wrap(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.wrap(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(name={"valid_constant_name?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject valid_constant_name_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.valid_constant_name_p(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject primitive_match(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            return Java.primitive_match(iRubyObject, iRubyObject2, iRubyObject3);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject access(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.access(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject matching_method(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            return Java.matching_method(iRubyObject, iRubyObject2, iRubyObject3);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject set_java_object(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            iRubyObject2.getInstanceVariables().fastSetInstanceVariable("@java_object", iRubyObject3);
            iRubyObject2.dataWrapStruct(iRubyObject3);
            return iRubyObject3;
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_deprecated_interface_proxy(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_deprecated_interface_proxy(threadContext, iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_interface_module(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_interface_module(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_package_module(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module_dot_format(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_package_module_dot_format(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_class(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_proxy_class(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject is_primitive_type(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.is_primitive_type(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject create_proxy_class(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
            return Java.create_proxy_class(iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_java_class(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_java_class(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_top_level_proxy_or_package(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.get_top_level_proxy_or_package(threadContext, iRubyObject, iRubyObject2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_or_package_under_package(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            return Java.get_proxy_or_package_under_package(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        }

        @Deprecated
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject add_proxy_extender(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Java.add_proxy_extender(iRubyObject, iRubyObject2);
        }
    }
}

