/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.nb.Finalizable;
import org.jruby.nb.Ruby;
import org.jruby.nb.util.JRubyFile;
import org.jruby.nb.util.io.BadDescriptorException;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.DirectoryAsFileException;
import org.jruby.nb.util.io.FileExistsException;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.ModeFlags;
import org.jruby.nb.util.io.NullChannel;
import org.jruby.nb.util.io.PipeException;
import org.jruby.nb.util.io.Stream;
import org.jruby.util.ByteList;

public class ChannelStream
implements Stream,
Finalizable {
    private static final boolean DEBUG = false;
    private static final int BUFSIZE = 4096;
    private static final int BULK_READ_SIZE = 16384;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private Ruby runtime;
    protected ModeFlags modes;
    protected boolean sync = false;
    protected volatile ByteBuffer buffer;
    protected boolean reading;
    private ChannelDescriptor descriptor;
    private boolean blocking = true;
    protected int ungotc = -1;
    private volatile boolean closedExplicitly = false;
    private boolean eof = false;

    public ChannelStream(Ruby ruby, ChannelDescriptor channelDescriptor, ModeFlags modeFlags, FileDescriptor fileDescriptor) throws InvalidValueException {
        channelDescriptor.checkNewModes(modeFlags);
        this.runtime = ruby;
        this.descriptor = channelDescriptor;
        this.modes = modeFlags;
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
    }

    public ChannelStream(Ruby ruby, ChannelDescriptor channelDescriptor) {
        this(ruby, channelDescriptor, channelDescriptor.getFileDescriptor());
    }

    public ChannelStream(Ruby ruby, ChannelDescriptor channelDescriptor, FileDescriptor fileDescriptor) {
        this.runtime = ruby;
        this.descriptor = channelDescriptor;
        this.modes = channelDescriptor.getOriginalModes();
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
    }

    public ChannelStream(Ruby ruby, ChannelDescriptor channelDescriptor, ModeFlags modeFlags) throws InvalidValueException {
        channelDescriptor.checkNewModes(modeFlags);
        this.runtime = ruby;
        this.descriptor = channelDescriptor;
        this.modes = modeFlags;
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public void checkReadable() throws IOException {
        if (!this.modes.isReadable()) {
            throw new IOException("not opened for reading");
        }
    }

    public void checkWritable() throws IOException {
        if (!this.modes.isWritable()) {
            throw new IOException("not opened for writing");
        }
    }

    public void checkPermissionsSubsetOf(ModeFlags modeFlags) {
        modeFlags.isSubsetOf(this.modes);
    }

    public ModeFlags getModes() {
        return this.modes;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }

    public void waitUntilReady() throws IOException, InterruptedException {
        while (this.ready() == 0) {
            Thread.sleep(10L);
        }
    }

    public boolean readDataBuffered() {
        return this.reading && this.buffer.hasRemaining();
    }

    public boolean writeDataBuffered() {
        return !this.reading && this.buffer.position() > 0;
    }

    private final int refillBuffer() throws IOException {
        this.buffer.clear();
        int n = ((ReadableByteChannel)this.descriptor.getChannel()).read(this.buffer);
        this.buffer.flip();
        return n;
    }

    public synchronized ByteList fgets(ByteList byteList) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        if (byteList == null) {
            return this.readall();
        }
        ByteList byteList2 = byteList == PARAGRAPH_DELIMETER ? PARAGRAPH_SEPARATOR : byteList;
        this.descriptor.checkOpen();
        if (this.feof()) {
            return null;
        }
        int n = this.read();
        if (n == -1) {
            return null;
        }
        this.buffer.position(this.buffer.position() - 1);
        ByteList byteList3 = new ByteList(40);
        byte by = byteList2.bytes[byteList2.begin];
        block0: while (true) {
            block11: {
                int n2;
                byte[] byArray = this.buffer.array();
                int n3 = this.buffer.position();
                int n4 = this.buffer.limit();
                for (n2 = n3; n2 < n4; ++n2) {
                    n = byArray[n2];
                    if (n != by) continue;
                    byteList3.append(byArray, n3, n2 - n3);
                    if (n2 >= n4) {
                        this.buffer.clear();
                    } else {
                        this.buffer.position(n2 + 1);
                    }
                    break block11;
                }
                byteList3.append(byArray, n3, this.buffer.remaining());
                n2 = this.refillBuffer();
                if (n2 != -1) continue;
                break;
            }
            for (int i = 0; i < byteList2.realSize && n != -1; ++i) {
                if (n != byteList2.bytes[byteList2.begin + i]) {
                    byteList3.append(n);
                    continue block0;
                }
                byteList3.append(n);
                if (i >= byteList2.realSize - 1) continue;
                n = this.read();
            }
            break;
        }
        if (byteList == PARAGRAPH_DELIMETER) {
            while (n == byteList2.bytes[byteList2.begin]) {
                n = this.read();
            }
            this.ungetc(n);
        }
        return byteList3;
    }

    public synchronized int getline(ByteList byteList, byte by) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        this.descriptor.checkOpen();
        int n = 0;
        boolean bl = false;
        if (this.ungotc != -1) {
            byteList.append((byte)this.ungotc);
            bl = this.ungotc == by;
            this.ungotc = -1;
            ++n;
        }
        while (!bl) {
            int n2;
            byte[] byArray = this.buffer.array();
            int n3 = this.buffer.arrayOffset() + this.buffer.position();
            int n4 = n3 + this.buffer.remaining();
            int n5 = 0;
            for (n2 = n3; n2 < n4 && !bl; ++n2) {
                bl = byArray[n2] == by;
                ++n5;
            }
            if (n5 > 0) {
                byteList.append(this.buffer, n5);
                n += n5;
            }
            if (bl || (n2 = this.refillBuffer()) > 0) continue;
            if (n2 >= 0 || n >= 1) break;
            return -1;
        }
        return n;
    }

    public synchronized ByteList readall() throws IOException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            int n;
            this.invalidateBuffer();
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            long l = fileChannel.size() - fileChannel.position();
            if (l <= 0L) {
                this.eof = true;
                return null;
            }
            ByteList byteList = new ByteList((int)(l += this.ungotc != -1 ? 1L : 0L));
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), (int)l);
            if (this.ungotc != -1) {
                byteBuffer.put((byte)this.ungotc);
                this.ungotc = -1;
            }
            while (byteBuffer.hasRemaining() && (n = ((ReadableByteChannel)this.descriptor.getChannel()).read(byteBuffer)) > 0) {
            }
            this.eof = true;
            byteList.length(byteBuffer.position());
            return byteList;
        }
        if (this.descriptor.isNull()) {
            return new ByteList(0);
        }
        this.checkReadable();
        ByteList byteList = new ByteList();
        ByteList byteList2 = this.fread(4096);
        if (byteList2 == null) {
            this.eof = true;
            return byteList;
        }
        while (byteList2 != null) {
            byteList.append(byteList2);
            byteList2 = this.fread(4096);
        }
        return byteList;
    }

    public synchronized void fclose() throws IOException, BadDescriptorException {
        this.closedExplicitly = true;
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean bl) throws IOException, BadDescriptorException {
        try {
            this.flushWrite();
            this.descriptor.close();
            this.buffer = EMPTY_BUFFER;
            Object var3_2 = null;
            if (!bl) {
                this.getRuntime().removeInternalFinalizer(this);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!bl) {
                this.getRuntime().removeInternalFinalizer(this);
            }
            throw throwable;
        }
    }

    private void closeForFinalize() {
        try {
            this.close(true);
        }
        catch (BadDescriptorException badDescriptorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized int fflush() throws IOException, BadDescriptorException {
        this.checkWritable();
        try {
            this.flushWrite();
        }
        catch (EOFException eOFException) {
            return -1;
        }
        return 0;
    }

    private void flushWrite() throws IOException, BadDescriptorException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return;
        }
        int n = this.buffer.position();
        this.buffer.flip();
        int n2 = this.descriptor.write(this.buffer);
        if (n2 != n) {
            // empty if block
        }
        this.buffer.clear();
    }

    public InputStream newInputStream() {
        InputStream inputStream = this.descriptor.getBaseInputStream();
        if (inputStream == null) {
            return new BufferedInputStream(Channels.newInputStream((ReadableByteChannel)this.descriptor.getChannel()));
        }
        return inputStream;
    }

    public OutputStream newOutputStream() {
        return new BufferedOutputStream(Channels.newOutputStream((WritableByteChannel)this.descriptor.getChannel()));
    }

    public void clearerr() {
        this.eof = false;
    }

    public synchronized boolean feof() throws IOException, BadDescriptorException {
        this.checkReadable();
        return this.eof;
    }

    public synchronized long fgetpos() throws IOException, PipeException, InvalidValueException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            long l = fileChannel.position();
            if (this.reading) {
                return l - (long)((l -= (long)this.buffer.remaining()) > 0L && this.ungotc != -1 ? 1 : 0);
            }
            return l + (long)this.buffer.position();
        }
        if (this.descriptor.isNull()) {
            return 0L;
        }
        throw new PipeException();
    }

    public synchronized void lseek(long l, int n) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            this.ungotc = -1;
            int n2 = 0;
            if (this.reading) {
                n2 = this.buffer.remaining();
                this.buffer.clear();
                this.buffer.flip();
            } else {
                this.flushWrite();
            }
            try {
                switch (n) {
                    case 0: {
                        fileChannel.position(l);
                        break;
                    }
                    case 1: {
                        fileChannel.position(fileChannel.position() - (long)n2 + l);
                        break;
                    }
                    case 2: {
                        fileChannel.position(fileChannel.size() + l);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidValueException();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw iOException;
            }
        } else if (this.descriptor.getChannel() instanceof SelectableChannel) {
            throw new PipeException();
        }
    }

    public void sync() throws IOException, BadDescriptorException {
        this.flushWrite();
    }

    private void ensureRead() throws IOException, BadDescriptorException {
        if (this.reading) {
            return;
        }
        this.flushWrite();
        this.buffer.clear();
        this.buffer.flip();
        this.reading = true;
    }

    private void ensureReadNonBuffered() throws IOException, BadDescriptorException {
        if (this.reading) {
            if (this.buffer.hasRemaining()) {
                throw this.getRuntime().newIOError("sysread for buffered IO");
            }
        } else {
            this.flushWrite();
            this.buffer.clear();
            this.buffer.flip();
            this.reading = true;
        }
    }

    private void resetForWrite() throws IOException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (this.buffer.hasRemaining()) {
                fileChannel.position(fileChannel.position() - (long)this.buffer.remaining());
            }
        }
        this.buffer.clear();
        this.reading = false;
    }

    private void ensureWrite() throws IOException {
        if (!this.reading) {
            return;
        }
        this.resetForWrite();
    }

    public synchronized ByteList read(int n) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureReadNonBuffered();
        ByteList byteList = new ByteList(n);
        int n2 = this.descriptor.read(n, byteList);
        if (n2 == -1) {
            this.eof = true;
        }
        return byteList;
    }

    private ByteList bufferedRead(int n) throws IOException, BadDescriptorException {
        int n2;
        int n3;
        this.checkReadable();
        this.ensureRead();
        ByteList byteList = new ByteList(0);
        int n4 = -1;
        if (this.buffer.hasRemaining()) {
            n4 = n <= this.buffer.remaining() ? n : this.buffer.remaining();
            byteList.append(this.buffer, n4);
        }
        boolean bl = false;
        while (n - byteList.length() >= 4096) {
            n3 = Math.min(16384, n - byteList.length());
            n2 = this.descriptor.read(n3, byteList);
            if (n2 == -1) {
                this.eof = true;
                bl = true;
                break;
            }
            if (n2 != 0) continue;
            bl = true;
            break;
        }
        while (!bl && byteList.length() != n) {
            n3 = this.refillBuffer();
            if (n3 == -1) {
                this.eof = true;
                break;
            }
            if (n3 == 0) break;
            n2 = n - byteList.length();
            n4 = n2 < n3 ? n2 : n3;
            byteList.append(this.buffer, n4);
        }
        if (byteList.length() == 0 && n != 0 && this.eof) {
            throw new EOFException();
        }
        return byteList;
    }

    private int bufferedRead() throws IOException, BadDescriptorException {
        this.ensureRead();
        if (!this.buffer.hasRemaining()) {
            int n = this.refillBuffer();
            if (n == -1) {
                this.eof = true;
                return -1;
            }
            if (n == 0) {
                return -1;
            }
        }
        return this.buffer.get() & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int bufferedWrite(ByteList byteList) throws IOException, BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        this.ensureWrite();
        if (byteList == null || byteList.length() == 0) {
            return 0;
        }
        if (byteList.length() > this.buffer.capacity()) {
            this.flushWrite();
            int n = this.descriptor.write(ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length()));
            if (n == byteList.length()) {
                // empty if block
            }
        } else {
            if (byteList.length() > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(byteList.unsafeBytes(), byteList.begin(), byteList.length());
        }
        if (this.isSync()) {
            this.sync();
        }
        return byteList.realSize;
    }

    private int bufferedWrite(int n) throws IOException, BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWritable();
        this.ensureWrite();
        if (!this.buffer.hasRemaining()) {
            this.flushWrite();
        }
        this.buffer.put((byte)n);
        if (this.isSync()) {
            this.sync();
        }
        return 1;
    }

    public synchronized void ftruncate(long l) throws IOException, BadDescriptorException, InvalidValueException {
        Channel channel = this.descriptor.getChannel();
        if (!(channel instanceof FileChannel)) {
            throw new InvalidValueException();
        }
        this.invalidateBuffer();
        FileChannel fileChannel = (FileChannel)channel;
        if (l > fileChannel.size()) {
            long l2 = fileChannel.position();
            int n = (int)(l - fileChannel.size());
            fileChannel.position(fileChannel.size());
            fileChannel.write(ByteBuffer.allocate(n));
            fileChannel.position(l2);
        } else {
            fileChannel.truncate(l);
        }
    }

    private void invalidateBuffer() throws IOException, BadDescriptorException {
        if (!this.reading) {
            this.flushWrite();
        }
        int n = this.buffer.remaining();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (n != 0) {
                fileChannel.position(fileChannel.position() - (long)n);
            }
        }
    }

    public synchronized void finalize() {
        if (this.closedExplicitly) {
            return;
        }
        if (this.descriptor != null && this.descriptor.isSeekable() && this.descriptor.isOpen()) {
            this.closeForFinalize();
        }
    }

    public int ready() throws IOException {
        return this.newInputStream().available();
    }

    public synchronized void fputc(int n) throws IOException, BadDescriptorException {
        try {
            this.bufferedWrite(n);
            this.fflush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int ungetc(int n) {
        if (n == -1) {
            return -1;
        }
        this.eof = false;
        this.ungotc = n;
        return n;
    }

    public synchronized int fgetc() throws IOException, BadDescriptorException {
        if (this.eof) {
            return -1;
        }
        this.checkReadable();
        int n = this.read();
        if (n == -1) {
            this.eof = true;
            return n;
        }
        return n & 0xFF;
    }

    public synchronized int fwrite(ByteList byteList) throws IOException, BadDescriptorException {
        return this.bufferedWrite(byteList);
    }

    public synchronized ByteList fread(int n) throws IOException, BadDescriptorException {
        try {
            if (n == 0) {
                if (this.eof) {
                    return null;
                }
                return new ByteList(0);
            }
            if (this.ungotc >= 0) {
                ByteList byteList = this.bufferedRead(n - 1);
                byteList.prepend((byte)this.ungotc);
                this.ungotc = -1;
                return byteList;
            }
            return this.bufferedRead(n);
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ByteList readnonblock(int n) throws IOException, BadDescriptorException, EOFException {
        assert (n >= 0);
        if (n == 0) {
            return null;
        }
        if (!(this.descriptor.getChannel() instanceof SelectableChannel)) {
            return null;
        }
        SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
        Object object = selectableChannel.blockingLock();
        synchronized (object) {
            ByteList byteList;
            boolean bl = selectableChannel.isBlocking();
            try {
                selectableChannel.configureBlocking(false);
                byteList = this.readpartial(n);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                selectableChannel.configureBlocking(bl);
                throw throwable;
            }
            selectableChannel.configureBlocking(bl);
            return byteList;
        }
    }

    public synchronized ByteList readpartial(int n) throws IOException, BadDescriptorException, EOFException {
        assert (n >= 0);
        if (n == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            if (!(this.ungotc < 0 || --n != 0 && this.buffer.hasRemaining())) {
                ByteList byteList = new ByteList(new byte[]{(byte)this.ungotc}, false);
                this.ungotc = -1;
                return byteList;
            }
            if (this.buffer.hasRemaining()) {
                ByteList byteList = this.bufferedRead(Math.min(this.buffer.remaining(), n));
                if (this.ungotc >= 0) {
                    byteList.prepend((byte)this.ungotc);
                    this.ungotc = -1;
                }
                return byteList;
            }
            return this.read(n);
        }
        return null;
    }

    public synchronized int read() throws IOException, BadDescriptorException {
        try {
            this.descriptor.checkOpen();
            if (this.ungotc >= 0) {
                int n = this.ungotc;
                this.ungotc = -1;
                return n;
            }
            return this.bufferedRead();
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return -1;
        }
    }

    public ChannelDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocking(boolean bl) throws IOException {
        if (!(this.descriptor.getChannel() instanceof SelectableChannel)) {
            return;
        }
        Object object = ((SelectableChannel)this.descriptor.getChannel()).blockingLock();
        synchronized (object) {
            this.blocking = bl;
            try {
                ((SelectableChannel)this.descriptor.getChannel()).configureBlocking(bl);
            }
            catch (IllegalBlockingModeException illegalBlockingModeException) {
                // empty catch block
            }
        }
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public synchronized void freopen(String string, ModeFlags modeFlags) throws DirectoryAsFileException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushWrite();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
        }
        this.modes = modeFlags;
        if (this.descriptor.isOpen()) {
            this.descriptor.close();
        }
        if (string.equals("/dev/null") || string.equalsIgnoreCase("nul:") || string.equalsIgnoreCase("nul")) {
            this.descriptor = new ChannelDescriptor(new NullChannel(), this.descriptor.getFileno(), modeFlags, new FileDescriptor());
        } else {
            String string2 = this.getRuntime().getCurrentDirectory();
            JRubyFile jRubyFile = JRubyFile.create(string2, string);
            if (jRubyFile.isDirectory() && modeFlags.isWritable()) {
                throw new DirectoryAsFileException();
            }
            if (modeFlags.isCreate()) {
                if (jRubyFile.exists() && modeFlags.isExclusive()) {
                    throw this.getRuntime().newErrnoEEXISTError("File exists - " + string);
                }
                jRubyFile.createNewFile();
            } else if (!jRubyFile.exists()) {
                throw this.getRuntime().newErrnoENOENTError("file not found - " + string);
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(jRubyFile, modeFlags.toJavaModeString());
            if (modeFlags.isTruncate()) {
                randomAccessFile.setLength(0L);
            }
            this.descriptor = new ChannelDescriptor(randomAccessFile.getChannel(), this.descriptor.getFileno(), modeFlags, randomAccessFile.getFD());
            if (modeFlags.isAppendable()) {
                this.lseek(0L, 2);
            }
        }
    }

    public static Stream fopen(Ruby ruby, String string, ModeFlags modeFlags) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        String string2 = ruby.getCurrentDirectory();
        ChannelDescriptor channelDescriptor = ChannelDescriptor.open(string2, string, modeFlags);
        Stream stream = ChannelStream.fdopen(ruby, channelDescriptor, modeFlags);
        if (modeFlags.isAppendable()) {
            stream.lseek(0L, 2);
        }
        return stream;
    }

    public static Stream fdopen(Ruby ruby, ChannelDescriptor channelDescriptor, ModeFlags modeFlags) throws InvalidValueException {
        ChannelStream channelStream = new ChannelStream(ruby, channelDescriptor, modeFlags, channelDescriptor.getFileDescriptor());
        return channelStream;
    }
}

