/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;

public class RemoteInvocationTraceInterceptor
implements MethodInterceptor {
    protected static final Log logger = LogFactory.getLog((Class)RemoteInvocationTraceInterceptor.class);
    private final String exporterName;

    public RemoteInvocationTraceInterceptor(String protocolName) {
        this.exporterName = protocolName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Incoming " + this.exporterName + " remote call: " + ClassUtils.getQualifiedMethodName(method)));
        }
        try {
            Object retVal = invocation.proceed();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished processing of " + this.exporterName + " remote call: " + ClassUtils.getQualifiedMethodName(method)));
            }
            return retVal;
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException || ex instanceof Error) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Processing of " + this.exporterName + " remote call resulted in fatal exception: " + ClassUtils.getQualifiedMethodName(method)), ex);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Processing of " + this.exporterName + " remote call resulted in exception: " + ClassUtils.getQualifiedMethodName(method)), ex);
            }
            throw ex;
        }
    }
}

