/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.EditPanel;
import org.netbeans.modules.web.monitor.client.ParamEditor;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EditPanelQuery
extends DataDisplay {
    private static final boolean debug = false;
    private DisplayTable paramTable = null;
    private MonitorData monitorData = null;
    private boolean setParams = false;
    JButton newParamB;
    JButton deleteParamB;
    JTextField queryStringText;
    JTextField uploadFileText;

    EditPanelQuery() {
    }

    void redisplayData() {
        this.setData(this.monitorData);
        this.revalidate();
        this.repaint();
    }

    void setData(MonitorData monitorData) {
        this.monitorData = monitorData;
        this.removeAll();
        int n = 0;
        int n2 = -1;
        this.addGridBagComponent(this, EditPanelQuery.createTopSpacer(), 0, ++n2, n, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        final RequestData requestData = this.monitorData.getRequestData();
        String string = requestData.getAttributeValue("method");
        if ("POST".equals(string)) {
            this.queryStringText = new JTextField(requestData.getAttributeValue("queryString"));
            this.queryStringText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    requestData.setAttributeValue("queryString", EditPanelQuery.this.queryStringText.getText());
                }
            });
            this.addGridBagComponent(this, EditPanelQuery.createHeaderLabel(NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Querystring_Header"), NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_QuerystringA11yDesc"), this.paramTable), 0, ++n2, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            this.addGridBagComponent(this, this.queryStringText, 0, ++n2, n, 1, 1.0, 0.0, 17, 2, tableInsets, 0, 0);
        }
        String string2 = null;
        if ("PUT".equals(string)) {
            string2 = NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Upload_File");
            JLabel jLabel = EditPanelQuery.createDataLabel(string2);
            this.addGridBagComponent(this, jLabel, 0, ++n2, n, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            String string3 = NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Upload_File_Not_Supported");
            this.uploadFileText = new JTextField(string3);
            this.uploadFileText.setEnabled(false);
            this.addGridBagComponent(this, this.uploadFileText, 0, ++n2, n, 1, 1.0, 0.0, 17, 2, labelInsets, 0, 0);
            this.addGridBagComponent(this, EditPanelQuery.createGlue(), 0, ++n2, 1, 1, 1.0, 1.0, 17, 1, labelInsets, 0, 0);
        } else if (string != null) {
            Param[] paramArray = requestData.getParam();
            if (paramArray == null) {
                paramArray = new Param[]{};
            }
            this.setParameters(paramArray);
            String string4 = null;
            if (string.equals("GET")) {
                string2 = NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Query_parameters");
                string4 = NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_Query_parametersA11yDesc");
                this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_ParametersTableA11yDesc"));
                this.paramTable.setToolTipText(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_ParametersTableA11yDesc"));
            } else if (string.equals("POST")) {
                string2 = NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Posted_data");
                string4 = NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_Posted_dataA11yDesc");
                this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_Posted_dataTableA11yName"));
                this.paramTable.setToolTipText(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_Posted_dataTableA11yDesc"));
            }
            Component component = EditPanelQuery.createSortButtonLabel(string2, this.paramTable, string4);
            this.addGridBagComponent(this, component, 0, ++n2, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            n2 = this.addParamTable(this, n2);
            this.setEnablings();
        }
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }

    private int addParamTable(JPanel jPanel, int n) {
        JScrollPane jScrollPane = new JScrollPane(this.paramTable);
        this.addGridBagComponent(jPanel, jScrollPane, 0, ++n, 0, 1, 1.0, 1.0, 17, 1, tableInsets, 0, 0);
        this.newParamB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.newParamB, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_New_param"));
        this.newParamB.setToolTipText(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_New_paramA11yDesc"));
        this.newParamB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamEditor paramEditor = new ParamEditor("", "", ParamEditor.Editable.BOTH, ParamEditor.Condition.NONE, EditPanelQuery.this.newParamB.getText());
                paramEditor.showDialog();
                if (paramEditor.getDialogOK()) {
                    String string = paramEditor.getName();
                    String string2 = paramEditor.getValue();
                    Param param = new Param(string, string2);
                    EditPanelQuery.this.monitorData.getRequestData().addParam(param);
                    EditPanelQuery.this.redisplayData();
                }
            }
        });
        this.deleteParamB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteParamB, (String)NbBundle.getBundle((Class)EditPanel.class).getString("MON_Delete_param"));
        this.deleteParamB.setToolTipText(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_Delete_paramA11yDesc"));
        this.deleteParamB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = EditPanelQuery.this.paramTable.getRowCount();
                RequestData requestData = EditPanelQuery.this.monitorData.getRequestData();
                StringBuffer stringBuffer = new StringBuffer(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanelQuery == null ? (class$org$netbeans$modules$web$monitor$client$EditPanelQuery = EditPanelQuery.class$("org.netbeans.modules.web.monitor.client.EditPanelQuery")) : class$org$netbeans$modules$web$monitor$client$EditPanelQuery)).getString("MON_Confirm_Delete_Params"));
                stringBuffer.append("\n");
                for (n = 0; n < n2; ++n) {
                    if (!EditPanelQuery.this.paramTable.isRowSelected(n)) continue;
                    stringBuffer.append(EditPanelQuery.this.paramTable.getValueAt(n, 0));
                    stringBuffer.append("=");
                    stringBuffer.append(EditPanelQuery.this.paramTable.getValueAt(n, 1));
                    stringBuffer.append("\n");
                }
                EditPanelQuery.this.showConfirmDialog(stringBuffer.toString());
                if (EditPanelQuery.this.setParams) {
                    for (n = 0; n < n2; ++n) {
                        if (!EditPanelQuery.this.paramTable.isRowSelected(n)) continue;
                        String string = (String)EditPanelQuery.this.paramTable.getValueAt(n, 0);
                        String string2 = (String)EditPanelQuery.this.paramTable.getValueAt(n, 1);
                        Param[] paramArray = requestData.getParam();
                        Param param = EditPanelQuery.this.findParam(paramArray, string, string2);
                        if (param == null) continue;
                        requestData.removeParam(param);
                    }
                    EditPanelQuery.this.redisplayData();
                }
            }
        });
        int n2 = -1;
        this.addGridBagComponent(this, EditPanelQuery.createGlue(), ++n2, ++n, 1, 1, 1.0, 0.0, 17, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.newParamB, ++n2, n, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.deleteParamB, ++n2, n, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        return n;
    }

    void setEnablings() {
        this.newParamB.setEnabled(true);
        int[] nArray = this.paramTable.getSelectedRows();
        this.deleteParamB.setEnabled(nArray.length > 0);
    }

    void setParameters(Param[] paramArray) {
        this.paramTable = new DisplayTable(paramArray, 4, true);
        this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_QuerystringTableA11yName"));
        this.paramTable.setToolTipText(NbBundle.getBundle((Class)EditPanelQuery.class).getString("ACS_MON_QuerystringTableA11yDesc"));
        ListSelectionModel listSelectionModel = this.paramTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditPanelQuery.this.setEnablings();
            }
        });
        this.paramTable.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                EditPanelQuery.this.updateParams();
            }
        });
    }

    void updateParams() {
        int n = this.paramTable.getRowCount();
        RequestData requestData = this.monitorData.getRequestData();
        Param[] paramArray = requestData.getParam();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.paramTable.getValueAt(i, 0);
            if ((string = string.trim()).equals("")) {
                this.paramTable.setValueAt(paramArray[i].getName(), i, 0);
                this.showErrorDialog();
                return;
            }
            String string2 = (String)this.paramTable.getValueAt(i, 1);
            string2 = string2.trim();
            paramArray[i].setName(string);
            paramArray[i].setValue(string2);
        }
    }

    void showConfirmDialog(String string) {
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Confirmation_Required"), 2, 3, objectArray, NotifyDescriptor.CANCEL_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        this.setParams = notifyDescriptor.getValue().equals(NotifyDescriptor.OK_OPTION);
    }

    void showErrorDialog() {
        Object[] objectArray = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Bad_param"), NbBundle.getBundle((Class)EditPanelQuery.class).getString("MON_Invalid_input"), -1, 0, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
    }

    void log(String string) {
        System.out.println("EditPanelQuery::" + string);
    }
}

