/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FeatureProjectFactory;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FeatureInfo {
    private final URL delegateLayer;
    private FileSystem fs;
    private final Set<String> cnbs;
    private final Map<String, String> nbproject = new HashMap<String, String>();
    private final Map<Object[], String> files = new HashMap<Object[], String>();
    private Properties properties;
    final String clusterName;
    private Boolean cacheEnabled;
    private Boolean cachePresent;

    private FeatureInfo(String string, Set<String> set, URL uRL, Properties properties) {
        this.cnbs = set;
        this.delegateLayer = uRL;
        this.properties = properties;
        this.clusterName = string;
    }

    public static FeatureInfo create(String string, URL uRL, URL uRL2) throws IOException {
        Properties properties = new Properties();
        properties.load(uRL2.openStream());
        String string2 = properties.getProperty("cnbs");
        assert (string2 != null) : "Error loading from " + uRL2;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(Arrays.asList(string2.split(",")));
        FeatureInfo featureInfo = new FeatureInfo(string, treeSet, uRL, properties);
        for (Object fileObjectArray : properties.keySet()) {
            String string3 = (String)fileObjectArray;
            if (string3.startsWith("nbproject.")) {
                featureInfo.nbproject(string3.substring("nbproject.".length()), properties.getProperty(string3));
            }
            if (string3.startsWith("project.file.")) {
                try {
                    featureInfo.projectFile(string3.substring("project.file.".length()), null, properties.getProperty(string3));
                }
                catch (XPathExpressionException xPathExpressionException) {
                    IOException iOException = new IOException(xPathExpressionException.getMessage());
                    iOException.initCause(xPathExpressionException);
                    throw iOException;
                }
            }
            if (!string3.startsWith("project.xpath.")) continue;
            try {
                String xPathExpressionException = properties.getProperty(string3);
                for (String string4 : xPathExpressionException.split(",")) {
                    featureInfo.projectFile(string3.substring("project.xpath.".length()), string4, "");
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                IOException iOException = new IOException(xPathExpressionException.getMessage());
                iOException.initCause(xPathExpressionException);
                throw iOException;
            }
        }
        FileObject fileObject = featureInfo.getXMLFileSystem().findResource("Ergonomics/AntBasedProjectTypes");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                String string5 = (String)fileObject2.getAttribute("type");
                featureInfo.nbproject(string5, "org.netbeans.modules.project.ant.AntBasedGenericType");
            }
        }
        return featureInfo;
    }

    public Object getProjectImporter() {
        return this.properties.getProperty("projectImporter");
    }

    String getPreferredCodeNameBase() {
        return this.properties.getProperty("mainModule");
    }

    String getFeatureCodeNameBase() {
        String string = this.properties.getProperty("featureModule");
        if (string != null) {
            return string.length() == 0 ? null : string;
        }
        return this.getPreferredCodeNameBase();
    }

    public final boolean isEnabled() {
        Boolean bl = this.cacheEnabled;
        if (bl != null) {
            return bl;
        }
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (!this.cnbs.contains(moduleInfo.getCodeNameBase()) || !FeatureManager.showInAU(moduleInfo)) continue;
            this.cacheEnabled = moduleInfo.isEnabled();
            return this.cacheEnabled;
        }
        this.cacheEnabled = false;
        return this.cacheEnabled;
    }

    public final URL getLayerURL() {
        return this.delegateLayer;
    }

    public synchronized FileSystem getXMLFileSystem() {
        if (this.fs == null) {
            URL uRL;
            if (FeatureInfo.doParseXML() && (uRL = this.delegateLayer) != null) {
                try {
                    this.fs = new XMLFileSystem(uRL);
                    return this.fs;
                }
                catch (SAXException sAXException) {
                    FoDFileSystem.LOG.log(Level.SEVERE, "Cannot parse: " + uRL, sAXException);
                    Exceptions.printStackTrace((Throwable)sAXException);
                }
            }
            this.fs = FileUtil.createMemoryFileSystem();
        }
        return this.fs;
    }

    int isProject(FeatureProjectFactory.Data data) {
        int n;
        FeatureProjectFactory.LOG.log(Level.FINE, "Checking project {0}", data);
        if (this.isNbProject(data)) {
            n = 1;
        } else if (this.files.isEmpty()) {
            n = 0;
        } else {
            n = 0;
            for (Object[] objectArray : this.files.keySet()) {
                String string = (String)objectArray[0];
                FeatureProjectFactory.LOG.log(Level.FINER, "    checking file {0}", string);
                if (!data.hasFile(string)) continue;
                FeatureProjectFactory.LOG.log(Level.FINER, "    found", string);
                Object object = objectArray[1];
                if (data.isDeepCheck() && object != null) {
                    XPathExpression xPathExpression;
                    block11: {
                        if (!(object instanceof XPathExpression)) {
                            try {
                                xPathExpression = XPathFactory.newInstance().newXPath().compile((String)object);
                                objectArray[1] = xPathExpression;
                                break block11;
                            }
                            catch (XPathExpressionException xPathExpressionException) {
                                FoDFileSystem.LOG.log(Level.WARNING, "Cannot parse " + object, xPathExpressionException);
                                continue;
                            }
                        }
                        xPathExpression = (XPathExpression)object;
                    }
                    Document document = data.dom(string);
                    try {
                        String string2 = xPathExpression.evaluate(document);
                        FeatureProjectFactory.LOG.log(Level.FINER, "Parsed result {0} of type {1}", new Object[]{string2, string2 == null ? null : string2.getClass()});
                        if (string2 == null || string2.length() <= 0) break;
                        n = 2;
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        FeatureProjectFactory.LOG.log(Level.INFO, "Cannot parse " + data, xPathExpressionException);
                    }
                    break;
                }
                n = 1;
                break;
            }
        }
        FeatureProjectFactory.LOG.log(Level.FINE, "  isProject: {0}", n);
        return n;
    }

    public final Set<String> getCodeNames() {
        return Collections.unmodifiableSet(this.cnbs);
    }

    public boolean isPresent() {
        Boolean bl = this.cachePresent;
        if (bl != null) {
            return bl;
        }
        HashSet<String> hashSet = new HashSet<String>(this.getCodeNames());
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            hashSet.remove(moduleInfo.getCodeNameBase());
        }
        this.cachePresent = hashSet.isEmpty();
        return this.cachePresent;
    }

    void clearCache() {
        this.cachePresent = null;
        this.cacheEnabled = null;
    }

    public String toString() {
        return "FeatureInfo[" + this.clusterName + "]";
    }

    private boolean isNbProject(FeatureProjectFactory.Data data) {
        if (this.nbproject.isEmpty()) {
            return false;
        }
        if (!data.hasFile("nbproject/project.xml")) {
            FeatureProjectFactory.LOG.log(Level.FINEST, "    nbproject/project.xml not found");
            return false;
        }
        if (!data.isDeepCheck()) {
            FeatureProjectFactory.LOG.log(Level.FINEST, "    no deep check, OK");
            return true;
        }
        String string = data.is("nbproject/project.xml");
        if (string == null) {
            return false;
        }
        for (String string2 : this.nbproject.keySet()) {
            String string3 = "<type>" + string2 + "</type>";
            if (string.indexOf(string3) >= 0) {
                FeatureProjectFactory.LOG.log(Level.FINEST, "    '" + string3 + "' found, OK");
                return true;
            }
            FeatureProjectFactory.LOG.log(Level.FINEST, "    '" + string3 + "' not found");
        }
        FeatureProjectFactory.LOG.log(Level.FINEST, "    not accepting");
        return false;
    }

    final void nbproject(String string, String string2) {
        this.nbproject.put(string, string2);
    }

    final void projectFile(String string, String string2, String string3) throws XPathExpressionException {
        this.files.put(new Object[]{string, string2}, string3);
    }

    static Map<String, String> nbprojectTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            hashMap.putAll(featureInfo.nbproject);
        }
        return hashMap;
    }

    static Map<String, String> projectFiles() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            for (Map.Entry<Object[], String> entry : featureInfo.files.entrySet()) {
                if (entry.getValue().length() <= 0) continue;
                hashMap.put((String)entry.getKey()[0], entry.getValue());
            }
        }
        return hashMap;
    }

    static boolean doParseXML() {
        return !Boolean.getBoolean("org.netbeans.modules.ide.ergonomics.noparse");
    }
}

