/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindComponentModules {
    private static final RequestProcessor RP = new RequestProcessor("Find Modules");
    private final Collection<String> codeNames;
    private final FeatureInfo[] infos;
    public final String DO_CHECK = "do-check";
    private final String ENABLE_LATER = "enable-later";
    private RequestProcessor.Task findingTask;
    private Collection<UpdateElement> forInstall = null;
    private Collection<UpdateElement> forEnable = null;
    private Runnable doFind = new Runnable(){

        public void run() {
            FindComponentModules.this.findComponentModules();
        }
    };

    public FindComponentModules(FeatureInfo featureInfo, FeatureInfo ... featureInfoArray) {
        ArrayList<FeatureInfo> arrayList = new ArrayList<FeatureInfo>();
        arrayList.add(featureInfo);
        arrayList.addAll(Arrays.asList(featureInfoArray));
        this.infos = arrayList.toArray(new FeatureInfo[0]);
        if (this.infos.length == 1) {
            this.codeNames = featureInfo.getCodeNames();
        } else {
            this.codeNames = new HashSet<String>(featureInfo.getCodeNames());
            for (FeatureInfo featureInfo2 : featureInfoArray) {
                this.codeNames.addAll(featureInfo2.getCodeNames());
            }
        }
        this.findingTask = RP.post(this.doFind);
    }

    public Collection<UpdateElement> getModulesForInstall() {
        this.findingTask.waitFinished();
        return this.forInstall;
    }

    public Collection<UpdateElement> getModulesForEnable() {
        this.findingTask.waitFinished();
        return this.forEnable;
    }

    public void writeEnableLater(Collection<UpdateElement> collection) {
        Preferences preferences = FindComponentModules.getPreferences();
        if (collection == null) {
            preferences.remove("enable-later");
            return;
        }
        String string = "";
        for (UpdateElement updateElement : collection) {
            string = string + (string.length() == 0 ? updateElement.getCodeName() : ", " + updateElement.getCodeName());
        }
        if (string.trim().length() == 0) {
            preferences.remove("enable-later");
        } else {
            preferences.put("enable-later", string);
        }
    }

    private Set<String> clusterClosure(Collection<UpdateElement> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (UpdateElement updateElement : collection) {
            for (FeatureInfo featureInfo : FeatureManager.features()) {
                if (!featureInfo.getCodeNames().contains(updateElement.getCodeName())) continue;
                hashSet.addAll(featureInfo.getCodeNames());
            }
        }
        return hashSet;
    }

    private Collection<UpdateElement> readEnableLater() {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        Preferences preferences = FindComponentModules.getPreferences();
        String string = preferences.get("enable-later", null);
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = ((String)stringTokenizer.nextElement()).trim();
                UpdateElement updateElement = FindComponentModules.findUpdateElement(string2, true);
                if (updateElement == null) continue;
                hashSet.add(updateElement);
            }
        }
        return hashSet;
    }

    public Collection<UpdateElement> getVisibleUpdateElements(Collection<UpdateElement> collection) {
        String string = this.infos[0].getPreferredCodeNameBase();
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateElement updateElement : new LinkedList<UpdateElement>(collection)) {
            if (UpdateManager.TYPE.KIT_MODULE.equals((Object)updateElement.getUpdateUnit().getType())) {
                hashSet.add(updateElement);
            }
            if (!updateElement.getUpdateUnit().getCodeName().equals(string)) continue;
            return Collections.singleton(updateElement);
        }
        if (hashSet.size() > 1) {
            FoDFileSystem.LOG.warning("No prefCNB found " + string + " using multiple " + hashSet);
        }
        return hashSet;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(FindComponentModules.class);
    }

    private void findComponentModules() {
        long l = System.currentTimeMillis();
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<UpdateElement> collection = this.getMissingModules(list);
        this.forInstall = this.getAllForInstall(collection);
        Collection<UpdateElement> collection2 = this.getDisabledModules(list);
        this.forEnable = this.getAllForEnable(collection2, list);
    }

    private Collection<UpdateElement> getMissingModules(Collection<UpdateUnit> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateUnit updateUnit : collection) {
            if (updateUnit.getInstalled() != null || !this.codeNames.contains(updateUnit.getCodeName())) continue;
            hashSet.add((UpdateElement)updateUnit.getAvailableUpdates().get(0));
        }
        return hashSet;
    }

    private Collection<UpdateElement> getAllForInstall(Collection<UpdateElement> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateElement updateElement : collection) {
            OperationContainer.OperationInfo operationInfo;
            OperationContainer operationContainer = OperationContainer.createForInstall();
            if (!operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement) || (operationInfo = operationContainer.add(updateElement)) == null) continue;
            Set set = operationInfo.getRequiredElements();
            operationContainer.add((Collection)set);
            Set set2 = operationInfo.getBrokenDependencies();
            if (!set2.isEmpty()) continue;
            hashSet.add(updateElement);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private Collection<UpdateElement> getDisabledModules(Collection<UpdateUnit> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateUnit updateUnit : collection) {
            if (updateUnit.getInstalled() == null || !this.codeNames.contains(updateUnit.getCodeName()) || updateUnit.getInstalled().isEnabled()) continue;
            hashSet.add(updateUnit.getInstalled());
        }
        return hashSet;
    }

    private Collection<UpdateElement> getAllForEnable(Collection<UpdateElement> collection, Collection<UpdateUnit> collection2) {
        Collection<UpdateElement> collection3 = collection;
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        HashSet<String> hashSet2 = new HashSet<String>();
        OperationContainer operationContainer = OperationContainer.createForEnable();
        while (!collection3.isEmpty()) {
            for (UpdateElement updateElement : collection3) {
                if (updateElement == null) continue;
                if (operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement)) {
                    UpdateElement updateElement2 = operationContainer.add(updateElement);
                    if (updateElement2 == null) continue;
                    Set set = updateElement2.getRequiredElements();
                    operationContainer.add((Collection)set);
                    hashSet.add(updateElement);
                    hashSet.addAll(set);
                    continue;
                }
                hashSet2.add(updateElement.getCodeName());
            }
            Set<String> set = this.clusterClosure(hashSet);
            for (UpdateElement updateElement2 : hashSet) {
                set.remove(updateElement2.getCodeName());
            }
            set.removeAll(hashSet2);
            if (set.isEmpty()) break;
            collection3 = new HashSet<UpdateElement>();
            for (UpdateElement updateElement2 : collection2) {
                if (!set.contains(updateElement2.getCodeName())) continue;
                collection3.add(updateElement2.getInstalled());
            }
        }
        return hashSet;
    }

    private static UpdateElement findUpdateElement(String string, boolean bl) {
        UpdateElement updateElement = null;
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!string.equals(updateUnit.getCodeName())) continue;
            if (bl && updateUnit.getInstalled() != null) {
                updateElement = updateUnit.getInstalled();
                break;
            }
            if (bl || updateUnit.getAvailableUpdates().isEmpty()) break;
            updateElement = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
            break;
        }
        return updateElement;
    }
}

