/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintsTask
implements CancellableTask<CompilationInfo> {
    private AtomicBoolean cancel = new AtomicBoolean();
    private List<ErrorDescription> currentHints = new LinkedList<ErrorDescription>();
    private Map<Tree.Kind, List<TreeRule>> presetHints;

    public HintsTask() {
    }

    public HintsTask(List<TreeRule> list) {
        this.presetHints = new EnumMap<Tree.Kind, List<TreeRule>>(Tree.Kind.class);
        for (TreeRule treeRule : list) {
            for (Tree.Kind kind : treeRule.getTreeKinds()) {
                List<TreeRule> list2 = this.presetHints.get((Object)kind);
                if (list2 == null) {
                    list2 = new LinkedList<TreeRule>();
                    this.presetHints.put(kind, list2);
                }
                list2.add(treeRule);
            }
        }
    }

    public List<ErrorDescription> computeHints(CompilationInfo compilationInfo) {
        return this.computeHints(compilationInfo, new TreePath(compilationInfo.getCompilationUnit()));
    }

    public List<ErrorDescription> computeHints(CompilationInfo compilationInfo, TreePath treePath) {
        Map<Tree.Kind, List<TreeRule>> map;
        Map<Tree.Kind, List<TreeRule>> map2 = map = this.presetHints != null ? this.presetHints : RulesManager.getInstance().getHints(false);
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        new ScannerImpl(compilationInfo, this.cancel, map).scan(treePath, linkedList);
        return linkedList;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        Object object;
        this.cancel.set(false);
        long l = System.currentTimeMillis();
        TreePath treePath = compilationInfo.getChangedTree();
        if (treePath != null) {
            object = (MethodTree)treePath.getLeaf();
            BlockTree blockTree = object.getBody();
            int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), blockTree);
            int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), blockTree);
            List<ErrorDescription> list = new LinkedList<ErrorDescription>(this.currentHints);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ErrorDescription errorDescription = (ErrorDescription)iterator.next();
                int n3 = errorDescription.getRange().getBegin().getOffset();
                int n4 = errorDescription.getRange().getEnd().getOffset();
                if (n3 < n || n4 > n2) continue;
                iterator.remove();
            }
            list = this.computeHints(compilationInfo, treePath);
            if (this.cancel.get()) {
                return;
            }
            this.currentHints = list;
            HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)HintsTask.class.getName(), list);
        } else {
            object = this.computeHints(compilationInfo);
            if (this.cancel.get()) {
                return;
            }
            this.currentHints = object;
            HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)HintsTask.class.getName(), (Collection)object);
        }
        long l2 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "HintsTask", new Object[]{compilationInfo.getFileObject(), l2 - l});
    }

    public void cancel() {
        this.cancel.set(true);
    }

    static boolean isInGuarded(CompilationInfo compilationInfo, TreePath treePath) {
        try {
            Document document = compilationInfo.getDocument();
            if (document instanceof GuardedDocument) {
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
                GuardedDocument guardedDocument = (GuardedDocument)document;
                MarkBlockChain markBlockChain = guardedDocument.getGuardedBlockChain();
                if (markBlockChain.compareBlock(n, n2) == 4129) {
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScannerImpl
    extends CancellableTreePathScanner<Void, List<ErrorDescription>> {
        private Stack<Set<String>> suppresWarnings = new Stack();
        private CompilationInfo info;
        private Map<Tree.Kind, List<TreeRule>> hints;
        private static final Set<Tree.Kind> SUPPRESS_ELEMENTS = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

        public ScannerImpl(CompilationInfo compilationInfo, AtomicBoolean atomicBoolean, Map<Tree.Kind, List<TreeRule>> map) {
            super(atomicBoolean);
            this.info = compilationInfo;
            this.hints = map;
        }

        private void runAndAdd(TreePath treePath, List<TreeRule> list, List<ErrorDescription> list2) {
            if (list != null && !HintsTask.isInGuarded(this.info, treePath)) {
                for (TreeRule treeRule : list) {
                    Object object;
                    if (this.isCanceled()) {
                        return;
                    }
                    boolean bl = true;
                    String[] stringArray = null;
                    if (treeRule instanceof AbstractHint) {
                        bl = HintsSettings.isEnabled((AbstractHint)treeRule);
                        stringArray = HintsSettings.getSuppressedBy((AbstractHint)treeRule);
                    }
                    if (stringArray != null && stringArray.length != 0) {
                        object = stringArray;
                        int n = ((String[])object).length;
                        for (int i = 0; i < n; ++i) {
                            String string = object[i];
                            if (this.suppresWarnings.empty() || !this.suppresWarnings.peek().contains(string)) continue;
                            return;
                        }
                    }
                    if (!bl || (object = treeRule.run(this.info, treePath)) == null) continue;
                    list2.addAll((Collection<ErrorDescription>)object);
                }
            }
        }

        public Void scan(Tree tree, List<ErrorDescription> list) {
            if (tree == null) {
                return null;
            }
            TreePath treePath = new TreePath(this.getCurrentPath(), tree);
            Tree.Kind kind = tree.getKind();
            if (SUPPRESS_ELEMENTS.contains((Object)kind)) {
                this.pushSuppressWarrnings(treePath);
                this.runAndAdd(treePath, this.hints.get((Object)kind), list);
                this.suppresWarnings.pop();
            } else {
                this.runAndAdd(treePath, this.hints.get((Object)kind), list);
            }
            if (this.isCanceled()) {
                return null;
            }
            return (Void)super.scan(tree, list);
        }

        public Void scan(TreePath treePath, List<ErrorDescription> list) {
            Tree.Kind kind = treePath.getLeaf().getKind();
            this.runAndAdd(treePath, this.hints.get((Object)kind), list);
            if (this.isCanceled()) {
                return null;
            }
            return (Void)super.scan(treePath, list);
        }

        public Void visitMethod(MethodTree methodTree, List<ErrorDescription> list) {
            this.pushSuppressWarrnings(this.getCurrentPath());
            Void void_ = (Void)super.visitMethod(methodTree, list);
            this.suppresWarnings.pop();
            return void_;
        }

        public Void visitClass(ClassTree classTree, List<ErrorDescription> list) {
            this.pushSuppressWarrnings(this.getCurrentPath());
            Void void_ = (Void)super.visitClass(classTree, list);
            this.suppresWarnings.pop();
            return void_;
        }

        public Void visitVariable(VariableTree variableTree, List<ErrorDescription> list) {
            this.pushSuppressWarrnings(this.getCurrentPath());
            Void void_ = (Void)super.visitVariable(variableTree, list);
            this.suppresWarnings.pop();
            return void_;
        }

        private void pushSuppressWarrnings(TreePath treePath) {
            Set<String> set = this.suppresWarnings.size() == 0 ? null : this.suppresWarnings.peek();
            HashSet<String> hashSet = set == null ? new HashSet<String>() : new HashSet<String>(set);
            Element element = this.info.getTrees().getElement(treePath);
            if (element != null) {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    String string = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                    if (!"java.lang.SuppressWarnings".equals(string)) continue;
                    Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                        Object object;
                        if (!"value".equals(entry.getKey().getSimpleName().toString()) || !((object = entry.getValue().getValue()) instanceof List)) continue;
                        for (Object e : (List)object) {
                            Object object2;
                            if (!(e instanceof AnnotationValue) || !((object2 = ((AnnotationValue)e).getValue()) instanceof String)) continue;
                            hashSet.add((String)object2);
                        }
                    }
                }
            }
            this.suppresWarnings.push(hashSet);
        }
    }
}

