/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spi.support;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.SuppressWarningsFixer;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FixFactory {
    private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

    private FixFactory() {
    }

    public static List<Fix> createSuppressWarnings(CompilationInfo compilationInfo, TreePath treePath, String ... stringArray) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)stringArray);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        if (!FixFactory.isSuppressWarningsSupported(compilationInfo)) {
            return Collections.emptyList();
        }
        while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            return Collections.singletonList(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getFileObject(), stringArray));
        }
        return Collections.emptyList();
    }

    private static boolean isSuppressWarningsSupported(CompilationInfo compilationInfo) {
        if (compilationInfo.getElements().getTypeElement("java.lang.SuppressWarnings") == null) {
            return false;
        }
        String string = SourceLevelQuery.getSourceLevel((FileObject)compilationInfo.getFileObject());
        if (string == null) {
            return true;
        }
        try {
            SpecificationVersion specificationVersion = new SpecificationVersion(string);
            SpecificationVersion specificationVersion2 = new SpecificationVersion("1.5");
            return specificationVersion.compareTo((Object)specificationVersion2) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private static final class FixImpl
    implements Fix {
        private String[] keys;
        private TreePathHandle handle;
        private FileObject file;
        private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

        public FixImpl(TreePathHandle treePathHandle, FileObject fileObject, String ... stringArray) {
            this.keys = stringArray;
            this.handle = treePathHandle;
            this.file = fileObject;
        }

        public String getText() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.keys.length; ++i) {
                String string = this.keys[i];
                stringBuilder.append(string);
                if (i >= this.keys.length - 1) continue;
                stringBuilder.append(", ");
            }
            return NbBundle.getMessage(SuppressWarningsFixer.class, (String)"LBL_FIX_Suppress_Waning", (Object)stringBuilder.toString());
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    TreePath treePath;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    for (treePath = FixImpl.this.handle.resolve((CompilationInfo)workingCopy); treePath != null && treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind()); treePath = treePath.getParentPath()) {
                    }
                    if (treePath.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        return;
                    }
                    Tree tree = treePath.getLeaf();
                    ModifiersTree modifiersTree = null;
                    switch (tree.getKind()) {
                        case CLASS: {
                            modifiersTree = ((ClassTree)tree).getModifiers();
                            break;
                        }
                        case METHOD: {
                            modifiersTree = ((MethodTree)tree).getModifiers();
                            break;
                        }
                        case VARIABLE: {
                            modifiersTree = ((VariableTree)tree).getModifiers();
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled Tree.Kind";
                            break;
                        }
                    }
                    if (modifiersTree == null) {
                        return;
                    }
                    TypeElement typeElement = workingCopy.getElements().getTypeElement("java.lang.SuppressWarnings");
                    if (typeElement == null) {
                        return;
                    }
                    for (AnnotationTree object2 : modifiersTree.getAnnotations()) {
                        String[] stringArray = new TreePath(new TreePath(treePath, object2), object2.getAnnotationType());
                        Element element = workingCopy.getTrees().getElement((TreePath)stringArray);
                        if (!typeElement.equals(element)) continue;
                        List<? extends ExpressionTree> list = object2.getArguments();
                        if (list.isEmpty() || list.size() > 1) {
                            Logger.getLogger(SuppressWarningsFixer.class.getName()).log(Level.INFO, "SupressWarnings annotation has incorrect number of arguments - {0}.", list.size());
                            return;
                        }
                        ExpressionTree expressionTree = object2.getArguments().get(0);
                        if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT) {
                            Logger.getLogger(SuppressWarningsFixer.class.getName()).log(Level.INFO, "SupressWarnings annotation's argument is not an assignment - {0}.", (Object)expressionTree.getKind());
                            return;
                        }
                        AssignmentTree assignmentTree = (AssignmentTree)expressionTree;
                        List<ExpressionTree> list2 = null;
                        list2 = assignmentTree.getExpression().getKind() == Tree.Kind.NEW_ARRAY ? ((NewArrayTree)assignmentTree.getExpression()).getInitializers() : Collections.singletonList(assignmentTree.getExpression());
                        assert (list2 != null);
                        ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>(list2);
                        for (String string : FixImpl.this.keys) {
                            arrayList.add(workingCopy.getTreeMaker().Literal((Object)string));
                        }
                        workingCopy.rewrite((Tree)assignmentTree.getExpression(), (Tree)workingCopy.getTreeMaker().NewArray(null, Collections.emptyList(), arrayList));
                        return;
                    }
                    ArrayList<? extends AnnotationTree> arrayList = new ArrayList<AnnotationTree>(modifiersTree.getAnnotations());
                    if (FixImpl.this.keys.length > 1) {
                        ArrayList<LiteralTree> arrayList2 = new ArrayList<LiteralTree>(FixImpl.this.keys.length);
                        for (String string : FixImpl.this.keys) {
                            arrayList2.add(workingCopy.getTreeMaker().Literal((Object)string));
                        }
                        arrayList.add(workingCopy.getTreeMaker().Annotation((Tree)workingCopy.getTreeMaker().QualIdent((Element)typeElement), Collections.singletonList(workingCopy.getTreeMaker().NewArray(null, Collections.emptyList(), arrayList2))));
                    } else {
                        arrayList.add(workingCopy.getTreeMaker().Annotation((Tree)workingCopy.getTreeMaker().QualIdent((Element)typeElement), Collections.singletonList(workingCopy.getTreeMaker().Literal((Object)FixImpl.this.keys[0]))));
                    }
                    ModifiersTree modifiersTree2 = workingCopy.getTreeMaker().Modifiers(modifiersTree, (List)arrayList);
                    workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FixImpl fixImpl = (FixImpl)object;
            if (!Arrays.deepEquals(this.keys, fixImpl.keys)) {
                return false;
            }
            if (!(this.handle == fixImpl.handle || this.handle != null && this.handle.equals((Object)fixImpl.handle))) {
                return false;
            }
            return this.file == fixImpl.file || this.file != null && this.file.equals(fixImpl.file);
        }

        public int hashCode() {
            int n = 5;
            n = 79 * n + Arrays.deepHashCode(this.keys);
            n = 79 * n + (this.handle != null ? this.handle.hashCode() : 0);
            n = 79 * n + (this.file != null ? this.file.hashCode() : 0);
            return n;
        }
    }
}

