/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.modules.websvc.manager.swing.outline.Outline;
import org.netbeans.modules.websvc.manager.swing.outline.RenderDataProvider;

public class DefaultOutlineCellRenderer
extends DefaultTableCellRenderer {
    private boolean expanded = false;
    private boolean leaf = true;
    private boolean showHandle = true;
    private int nestingDepth = 0;
    private static final Border expansionBorder = new ExpansionHandleBorder();

    public final void setBorder(Border border) {
        if (border == expansionBorder) {
            super.setBorder(border);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(border, expansionBorder));
        }
    }

    private static Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    private static Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    private static Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    private static Icon getExpandedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    private static Icon getCollapsedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    static int getNestingWidth() {
        return DefaultOutlineCellRenderer.getExpansionHandleWidth();
    }

    static int getExpansionHandleWidth() {
        return DefaultOutlineCellRenderer.getExpandedIcon().getIconWidth();
    }

    static int getExpansionHandleHeight() {
        return DefaultOutlineCellRenderer.getExpandedIcon().getIconHeight();
    }

    private void setNestingDepth(int n) {
        this.nestingDepth = n;
    }

    private void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    private void setLeaf(boolean bl) {
        this.leaf = bl;
    }

    private void setShowHandle(boolean bl) {
        this.showHandle = bl;
    }

    private boolean isLeaf() {
        return this.leaf;
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    private boolean isShowHandle() {
        return this.showHandle;
    }

    private int getNestingDepth() {
        return this.nestingDepth;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        Outline outline = (Outline)jTable;
        if (outline.isTreeColumnIndex(n2)) {
            AbstractLayoutCache abstractLayoutCache = outline.getLayoutCache();
            boolean bl3 = outline.getOutlineModel().isLeaf(object);
            this.setLeaf(bl3);
            this.setShowHandle(true);
            TreePath treePath = abstractLayoutCache.getPathForRow(n);
            boolean bl4 = !abstractLayoutCache.isExpanded(treePath);
            this.setExpanded(bl4);
            this.setNestingDepth(treePath.getPathCount() - 1);
            RenderDataProvider renderDataProvider = outline.getRenderDataProvider();
            Icon icon = null;
            if (renderDataProvider != null) {
                String string = renderDataProvider.getDisplayName(object);
                if (string != null) {
                    this.setText(string);
                }
                this.setToolTipText(renderDataProvider.getTooltipText(object));
                Color color = renderDataProvider.getBackground(object);
                Color color2 = renderDataProvider.getForeground(object);
                if (color != null && !bl) {
                    this.setBackground(color);
                } else {
                    this.setBackground(bl ? outline.getSelectionBackground() : outline.getBackground());
                }
                if (color2 != null && !bl) {
                    this.setForeground(color2);
                } else {
                    this.setForeground(bl ? outline.getSelectionForeground() : outline.getForeground());
                }
                icon = renderDataProvider.getIcon(object);
            }
            if (icon == null) {
                if (!bl3) {
                    if (bl4) {
                        this.setIcon(DefaultOutlineCellRenderer.getDefaultClosedIcon());
                    } else {
                        this.setIcon(DefaultOutlineCellRenderer.getDefaultOpenIcon());
                    }
                } else {
                    this.setIcon(DefaultOutlineCellRenderer.getDefaultLeafIcon());
                }
            }
        } else {
            this.setIcon(null);
            this.setShowHandle(false);
        }
        return this;
    }

    private static class ExpansionHandleBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);

        private ExpansionHandleBorder() {
        }

        public Insets getBorderInsets(Component component) {
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)component;
            if (defaultOutlineCellRenderer.isShowHandle()) {
                this.insets.left = DefaultOutlineCellRenderer.getExpansionHandleWidth() + defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            } else {
                this.insets.left = 1;
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            }
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)component;
            if (defaultOutlineCellRenderer.isShowHandle() && !defaultOutlineCellRenderer.isLeaf()) {
                Icon icon = defaultOutlineCellRenderer.isExpanded() ? DefaultOutlineCellRenderer.getExpandedIcon() : DefaultOutlineCellRenderer.getCollapsedIcon();
                int n5 = defaultOutlineCellRenderer.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                int n6 = icon.getIconHeight() < n4 ? n4 / 2 - icon.getIconHeight() / 2 : 0;
                icon.paintIcon(component, graphics, n5, n6);
            }
        }
    }
}

