/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EnvEntryPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EnvEntryTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EnvEntriesTablePanel
extends DefaultTablePanel {
    private EnvEntryTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;

    public EnvEntriesTablePanel(final DDDataObject dDDataObject, final EnvEntryTableModel envEntryTableModel) {
        super((AbstractTableModel)envEntryTableModel);
        this.model = envEntryTableModel;
        this.dObj = dDDataObject;
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dDDataObject.modelUpdatedFromUI();
                dDDataObject.setChangedFromUI(true);
                int n = EnvEntriesTablePanel.this.getTable().getSelectedRow();
                envEntryTableModel.removeRow(n);
                dDDataObject.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, EnvEntry[] envEntryArray) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])envEntryArray);
        this.webApp = webApp;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean bl) {
            this.add = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            final int n = this.add ? -1 : EnvEntriesTablePanel.this.getTable().getSelectedRow();
            final EnvEntryPanel envEntryPanel = new EnvEntryPanel();
            if (!this.add) {
                object = EnvEntriesTablePanel.this.model.getEnvEntry(n);
                envEntryPanel.setEnvEntryName(object.getEnvEntryName());
                envEntryPanel.setEnvEntryType(object.getEnvEntryType());
                envEntryPanel.setEnvEntryValue(object.getEnvEntryValue());
                envEntryPanel.setDescription(object.getDefaultDescription());
            }
            object = new EditDialog(envEntryPanel, NbBundle.getMessage(EnvEntriesTablePanel.class, (String)"TTL_EnvEntry"), this.add){

                protected String validate() {
                    String string = envEntryPanel.getEnvEntryName().trim();
                    if (string.length() == 0) {
                        return NbBundle.getMessage(EnvEntriesTablePanel.class, (String)"TXT_EmptyEnvEntryName");
                    }
                    EnvEntry[] envEntryArray = EnvEntriesTablePanel.this.webApp.getEnvEntry();
                    boolean bl = false;
                    for (int i = 0; i < envEntryArray.length; ++i) {
                        if (n == i || !string.equals(envEntryArray[i].getEnvEntryName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        return NbBundle.getMessage(EnvEntriesTablePanel.class, (String)"TXT_EnvEntryNameExists", (Object)string);
                    }
                    return null;
                }
            };
            if (this.add) {
                object.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener((EditDialog)object);
            envEntryPanel.getNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)object);
            dialog.setVisible(true);
            envEntryPanel.getNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (object.getValue().equals(EditDialog.OK_OPTION)) {
                EnvEntriesTablePanel.this.dObj.modelUpdatedFromUI();
                EnvEntriesTablePanel.this.dObj.setChangedFromUI(true);
                String string = envEntryPanel.getEnvEntryName().trim();
                String string2 = envEntryPanel.getEnvEntryType();
                String string3 = envEntryPanel.getEnvEntryValue().trim();
                String string4 = envEntryPanel.getDescription();
                if (this.add) {
                    EnvEntriesTablePanel.this.model.addRow(new String[]{string, string2, string3, string4});
                } else {
                    EnvEntriesTablePanel.this.model.editRow(n, new String[]{string, string2, string3, string4});
                }
                EnvEntriesTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

