/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.spi.support;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.plugins.spi.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class LookupProviderSupport {
    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup lookup, String string) {
        return new DelegatingLookupImpl(lookup, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatingLookupImpl
    extends ProxyLookup
    implements LookupListener {
        private Lookup baseLookup;
        private Lookup.Result<LookupProvider> providerResult;
        private LookupListener providerListener;
        private List<LookupProvider> old = Collections.emptyList();
        private List<Lookup> currentLookups;
        private Reference<LookupListener> listenerRef;
        private List<Lookup.Result<?>> results = new ArrayList();

        public DelegatingLookupImpl(Lookup lookup, String string) {
            this(lookup, Lookups.forPath((String)string), string);
        }

        public DelegatingLookupImpl(Lookup lookup, Lookup lookup2, String string) {
            assert (lookup != null);
            this.baseLookup = lookup;
            this.providerResult = lookup2.lookup(new Lookup.Template(LookupProvider.class));
            assert (this.isAllJustLookupProviders(lookup2)) : "Layer content at " + string + " contains other than LookupProvider instances! See messages.log file for more details.";
            this.doDelegate(this.providerResult.allInstances());
            this.providerListener = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    DelegatingLookupImpl.this.doDelegate(DelegatingLookupImpl.this.providerResult.allInstances());
                }
            };
            this.providerResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.providerResult));
        }

        private boolean isAllJustLookupProviders(Lookup lookup) {
            Lookup.Result result = lookup.lookupResult(Object.class);
            Set set = result.allClasses();
            for (Class clazz : set) {
                if (LookupProvider.class.isAssignableFrom(clazz)) continue;
                Logger.getLogger(LookupProviderSupport.class.getName()).warning("" + clazz.getName() + " is not instance of LookupProvider.");
                return false;
            }
            return true;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.doDelegate(this.providerResult.allInstances());
        }

        private synchronized void doDelegate(Collection<? extends LookupProvider> collection) {
            for (Lookup.Result<?> object2 : this.results) {
                object2.removeLookupListener((LookupListener)this);
            }
            ArrayList arrayList = new ArrayList();
            for (LookupProvider lookupProvider : collection) {
                if (this.old.contains(lookupProvider)) {
                    int n = this.old.indexOf(lookupProvider);
                    arrayList.add(this.currentLookups.get(n));
                    continue;
                }
                Lookup lookup = lookupProvider.createAdditionalLookup(this.baseLookup);
                assert (lookup != null);
                arrayList.add(lookup);
            }
            this.old = new ArrayList<LookupProvider>(collection);
            this.currentLookups = arrayList;
            arrayList.add(this.baseLookup);
            ProxyLookup proxyLookup = new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
            this.setLookups(new Lookup[]{proxyLookup});
        }
    }
}

