/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.libs.bugtracking.BugtrackingRuntime;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.ModuleLifecycleManager;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.kenai.KenaiSupportImpl;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bugzilla {
    private BugzillaRepositoryConnector brc;
    private Set<BugzillaRepository> repositories;
    private static final Object REPOSITORIES_LOCK = new Object();
    private static Bugzilla instance;
    public static final Logger LOG;
    private RequestProcessor rp;
    private BugzillaCorePlugin bcp;
    private BugzillaClientManager clientManager;
    private KenaiSupport kenaiSupport;

    private Bugzilla() {
        ModuleLifecycleManager.instantiated = true;
        this.bcp = new BugzillaCorePlugin();
        BugzillaCorePlugin.setConfigurationCacheFile((File)new File(BugtrackingRuntime.getInstance().getCacheStore(), "bugzillaconfiguration"));
        this.brc = new BugzillaRepositoryConnector();
        this.clientManager = this.getRepositoryConnector().getClientManager();
        BugzillaIssueProvider.getInstance();
        try {
            this.bcp.start(null);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, null, exception);
        }
    }

    public static synchronized Bugzilla getInstance() {
        if (instance == null) {
            instance = new Bugzilla();
        }
        return instance;
    }

    void shutdown() {
        try {
            this.bcp.stop(null);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, null, exception);
        }
    }

    public KenaiSupport getKenaiSupport() {
        if (this.kenaiSupport == null) {
            this.kenaiSupport = new KenaiSupportImpl();
        }
        return this.kenaiSupport;
    }

    public BugzillaRepositoryConnector getRepositoryConnector() {
        return this.brc;
    }

    public RepositoryConfiguration getRepositoryConfiguration(BugzillaRepository bugzillaRepository, boolean bl) throws CoreException, MalformedURLException {
        this.getClient(bugzillaRepository);
        RepositoryConfiguration repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)bugzillaRepository.getTaskRepository(), (boolean)bl, (IProgressMonitor)new NullProgressMonitor());
        return repositoryConfiguration;
    }

    public BugzillaClient getClient(BugzillaRepository bugzillaRepository) throws MalformedURLException, CoreException {
        return this.clientManager.getClient(bugzillaRepository.getTaskRepository(), (IProgressMonitor)new NullProgressMonitor());
    }

    public RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Bugzilla", 1, true);
        }
        return this.rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(BugzillaRepository bugzillaRepository) {
        if (bugzillaRepository instanceof KenaiRepository) {
            return;
        }
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            this.getStoredRepositories().add(bugzillaRepository);
            BugzillaConfig.getInstance().putRepository(bugzillaRepository.getID(), bugzillaRepository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(BugzillaRepository bugzillaRepository) {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            this.getStoredRepositories().remove((Object)bugzillaRepository);
            BugzillaConfig.getInstance().removeRepository(bugzillaRepository.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugzillaRepository[] getRepositories() {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            Set<BugzillaRepository> set = this.getStoredRepositories();
            return set.toArray(new BugzillaRepository[set.size()]);
        }
    }

    private Set<BugzillaRepository> getStoredRepositories() {
        if (this.repositories == null) {
            this.repositories = new HashSet<BugzillaRepository>();
            String[] stringArray = BugzillaConfig.getInstance().getRepositories();
            if (stringArray == null || stringArray.length == 0) {
                return this.repositories;
            }
            for (String string : stringArray) {
                BugzillaRepository bugzillaRepository = BugzillaConfig.getInstance().getRepository(string);
                if (bugzillaRepository == null) continue;
                this.repositories.add(bugzillaRepository);
            }
        }
        return this.repositories;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.bugzilla.Bugzilla");
    }
}

