/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.ResolveIssuePanel;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BugzillaIssueProvider
extends IssueProvider
implements PropertyChangeListener {
    private static BugzillaIssueProvider instance;
    private final Object LOCK = new Object();
    private boolean initialized;
    private HashMap<String, BugzillaLazyIssue> watchedIssues = new HashMap(10);
    private static final Logger LOG;
    private static final Level LOG_LEVEL;
    private final RequestProcessor rp = new RequestProcessor("BugzillaTaskListProvider", 1, false);
    private static final String KENAI_REPOSITORY_IDENT_PREFIX = "K##";
    private static final String STORAGE_KENAI_VERSION = "1";
    private static final String STORAGE_COMMON_VERSION = "1";
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String PROPERTY_ISSUE_REMOVED = "issue-removed";

    public static synchronized BugzillaIssueProvider getInstance() {
        if (instance == null) {
            instance = (BugzillaIssueProvider)Lookup.getDefault().lookup(BugzillaIssueProvider.class);
        }
        return instance;
    }

    public BugzillaIssueProvider() {
        this.reloadAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BugzillaIssue bugzillaIssue, boolean bl) {
        BugzillaLazyIssue bugzillaLazyIssue;
        URL uRL = BugzillaIssueProvider.getUrl(bugzillaIssue);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isAdded(uRL)) {
                return;
            }
            try {
                BugzillaRepository bugzillaRepository = bugzillaIssue.getBugzillaRepository();
                bugzillaRepository.removePropertyChangeListener(this);
                bugzillaRepository.addPropertyChangeListener(this);
                bugzillaLazyIssue = bugzillaRepository instanceof KenaiRepository ? new KenaiBugzillaLazyIssue(bugzillaIssue, this) : new BugzillaLazyIssue(bugzillaIssue, this);
                this.watchedIssues.put(uRL.toString(), bugzillaLazyIssue);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        this.saveIntern();
        super.add(bl, new IssueProvider.LazyIssue[]{bugzillaLazyIssue});
    }

    public void remove(BugzillaIssue bugzillaIssue) {
        URL uRL = BugzillaIssueProvider.getUrl(bugzillaIssue);
        this.remove(uRL, true);
    }

    public boolean isAdded(BugzillaIssue bugzillaIssue) {
        URL uRL = BugzillaIssueProvider.getUrl(bugzillaIssue);
        return this.isAdded(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(IssueProvider.LazyIssue lazyIssue) {
        BugzillaLazyIssue bugzillaLazyIssue;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isAdded(lazyIssue.getUrl())) {
                return;
            }
            bugzillaLazyIssue = this.watchedIssues.remove(lazyIssue.getUrl().toString());
        }
        this.saveIntern();
        this.fireIssueRemoved(bugzillaLazyIssue);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("bugtracking.repository.attributes.changed".equals(propertyChangeEvent.getPropertyName())) {
            Object v;
            if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getOldValue() instanceof Map && (v = ((Map)propertyChangeEvent.getOldValue()).get("bugzilla.repository.attribute.url")) != null && v instanceof String) {
                String string = (String)v;
                LinkedList<BugzillaLazyIssue> linkedList = new LinkedList<BugzillaLazyIssue>();
                Iterator iterator = this.LOCK;
                synchronized (iterator) {
                    for (Map.Entry<String, BugzillaLazyIssue> entry : this.watchedIssues.entrySet()) {
                        BugzillaLazyIssue bugzillaLazyIssue = entry.getValue();
                        Object object = propertyChangeEvent.getSource();
                        if (bugzillaLazyIssue instanceof KenaiBugzillaLazyIssue || object == null || !object.equals((Object)bugzillaLazyIssue.getRepository())) continue;
                        URL uRL = BugzillaIssueProvider.getUrl(string, bugzillaLazyIssue.issueId);
                        if (!bugzillaLazyIssue.getUrl().toString().equals(uRL.toString())) continue;
                        LOG.log(Level.FINE, "propertyChange: Issue {0} with url {1} needs to be refreshed, repository's url {2} has changed", new String[]{bugzillaLazyIssue.toString(), uRL.toString(), string});
                        linkedList.add(bugzillaLazyIssue);
                    }
                }
                for (BugzillaLazyIssue bugzillaLazyIssue : linkedList) {
                    this.remove(bugzillaLazyIssue.getUrl(), false);
                    this.add(bugzillaLazyIssue.getName(), bugzillaLazyIssue.issueId, bugzillaLazyIssue.getRepository());
                }
                if (!linkedList.isEmpty()) {
                    this.saveIntern();
                }
            }
        } else if ("login".equals(propertyChangeEvent.getPropertyName())) {
            this.rp.post(new Runnable(){

                public void run() {
                    BugzillaIssueProvider.this.notifyKenaiLogin();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFor(BugzillaRepository bugzillaRepository) {
        LinkedList<BugzillaLazyIssue> linkedList = new LinkedList<BugzillaLazyIssue>();
        Iterator iterator = this.LOCK;
        synchronized (iterator) {
            for (Map.Entry<String, BugzillaLazyIssue> entry : this.watchedIssues.entrySet()) {
                BugzillaLazyIssue bugzillaLazyIssue = entry.getValue();
                if (bugzillaLazyIssue instanceof KenaiBugzillaLazyIssue || bugzillaRepository != bugzillaLazyIssue.getRepository()) continue;
                LOG.log(Level.FINE, "removeAllFor: issue {0} repository {1} has been removed", new String[]{bugzillaLazyIssue.toString(), bugzillaRepository.toString()});
                linkedList.add(bugzillaLazyIssue);
            }
        }
        for (BugzillaLazyIssue bugzillaLazyIssue : linkedList) {
            this.remove(bugzillaLazyIssue.getUrl(), false);
        }
        if (!linkedList.isEmpty()) {
            this.saveIntern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIssueCreated(BugzillaIssue bugzillaIssue) {
        URL uRL = BugzillaIssueProvider.getUrl(bugzillaIssue);
        BugzillaLazyIssue bugzillaLazyIssue = null;
        Object object = this.LOCK;
        synchronized (object) {
            bugzillaLazyIssue = this.watchedIssues.get(uRL.toString());
        }
        if (bugzillaLazyIssue != null) {
            bugzillaLazyIssue.setIssueReference(bugzillaIssue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdded(URL uRL) {
        this.initializeIssues();
        if (uRL == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.watchedIssues.containsKey(uRL.toString());
        }
    }

    private static URL getUrl(BugzillaIssue bugzillaIssue) {
        return BugzillaIssueProvider.getUrl(bugzillaIssue.getRepository().getUrl(), bugzillaIssue.getID());
    }

    private static URL getUrl(String string, String string2) {
        String string3 = Bugzilla.getInstance().getRepositoryConnector().getTaskUrl(string, string2);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(LOG_LEVEL, null, malformedURLException);
            try {
                return new URL(string + "#" + string2);
            }
            catch (MalformedURLException malformedURLException2) {
                LOG.log(LOG_LEVEL, null, malformedURLException2);
                return null;
            }
        }
    }

    private void reloadAsync() {
        this.rp.post(new Runnable(){

            public void run() {
                BugzillaIssueProvider.this.initializeIssues();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIntern() {
        final BugzillaLazyIssue[] bugzillaLazyIssueArray = this.LOCK;
        synchronized (this.LOCK) {
            BugzillaLazyIssue[] bugzillaLazyIssueArray2 = this.watchedIssues.values().toArray(new BugzillaLazyIssue[this.watchedIssues.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            bugzillaLazyIssueArray = bugzillaLazyIssueArray2;
            this.rp.post(new Runnable(){

                public void run() {
                    BugzillaIssueProvider.this.initializeIssues();
                    LOG.log(Level.FINE, "saveIntern: saving issues");
                    HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                    for (BugzillaLazyIssue bugzillaLazyIssue : bugzillaLazyIssueArray) {
                        Object object;
                        String string = null;
                        boolean bl = false;
                        if (bugzillaLazyIssue instanceof KenaiBugzillaLazyIssue) {
                            object = bugzillaLazyIssue.getRepository();
                            if (object != null && !(object instanceof KenaiRepository)) {
                                LOG.warning("saveIntern: KenaiBugzillaIssue has no kenai repository: " + (Object)object);
                            } else {
                                string = BugzillaIssueProvider.KENAI_REPOSITORY_IDENT_PREFIX + (object == null ? ((KenaiBugzillaLazyIssue)bugzillaLazyIssue).projectName : ((KenaiRepository)object).getProductName());
                                bl = true;
                            }
                        } else {
                            string = bugzillaLazyIssue.getRepositoryUrl();
                        }
                        if (string == null) continue;
                        object = hashMap.get(string);
                        if (object == null) {
                            object = new LinkedList();
                            object.add(bl ? "1" : "1");
                        }
                        object.add(bugzillaLazyIssue.issueId);
                        object.add(bugzillaLazyIssue.getName());
                        if (bl) {
                            object.add(bugzillaLazyIssue.getUrl().toString());
                        }
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("saveIntern: saving " + (Object)object + " for repo: " + string);
                        }
                        hashMap.put(string, (List<String>)object);
                    }
                    BugzillaConfig.getInstance().setTaskListIssues(hashMap);
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIssues() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            LOG.finer("initializeIssues: reloading saved issues");
            Map<String, List<String>> map = BugzillaConfig.getInstance().getTaskListIssues();
            if (map.size() == 0) {
                LOG.fine("initializeIssues: no saved issues");
                return;
            }
            this.addCommonIssues(map);
            this.addKenaiIssues(map);
        }
    }

    private String getNextAttribute(ListIterator<String> listIterator) {
        String string = null;
        if (listIterator.hasNext()) {
            string = listIterator.next();
        }
        return string;
    }

    private void addCommonIssues(Map<String, List<String>> map) {
        BugzillaRepository[] bugzillaRepositoryArray;
        for (BugzillaRepository bugzillaRepository : bugzillaRepositoryArray = Bugzilla.getInstance().getRepositories()) {
            List<String> list = map.get(bugzillaRepository.getUrl());
            if (list == null || list.size() <= 1) continue;
            ListIterator<String> listIterator = list.listIterator();
            if (!"1".equals(listIterator.next())) {
                LOG.log(Level.WARNING, "Old unsupported storage version, expecting {0}", "1");
                break;
            }
            while (listIterator.hasNext()) {
                String string = this.getNextAttribute(listIterator);
                String string2 = this.getNextAttribute(listIterator);
                if (string == null || string2 == null) {
                    LOG.log(Level.WARNING, "Corrupted issue attributes: {0} {1}", new String[]{string, string2});
                    break;
                }
                this.add(string2, string, bugzillaRepository);
            }
            bugzillaRepository.addPropertyChangeListener(this);
            map.remove(bugzillaRepository.getUrl());
        }
    }

    private void addKenaiIssues(Map<String, List<String>> map) {
        boolean bl = false;
        block2: for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            if (!string.startsWith(KENAI_REPOSITORY_IDENT_PREFIX)) continue;
            string = string.substring(KENAI_REPOSITORY_IDENT_PREFIX.length());
            List<String> list = entry.getValue();
            if (list == null || list.size() <= 1) continue;
            ListIterator<String> listIterator = list.listIterator();
            if (!"1".equals(listIterator.next())) {
                LOG.log(Level.WARNING, "Old unsupported storage version for kenai issues, expecting {0}", "1");
                break;
            }
            while (listIterator.hasNext()) {
                URL uRL;
                String string2 = this.getNextAttribute(listIterator);
                String string3 = this.getNextAttribute(listIterator);
                String string4 = this.getNextAttribute(listIterator);
                if (string2 == null || string3 == null || string4 == null) {
                    LOG.log(Level.WARNING, "Corrupted kenai issue attributes: {0} {1} {2}", new String[]{string2, string3, string4});
                    continue block2;
                }
                try {
                    uRL = new URL(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    LOG.log(Level.INFO, null, malformedURLException);
                    continue;
                }
                this.add(string3, uRL, string2, string);
                bl = true;
            }
        }
        if (bl) {
            Kenai.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(URL uRL, boolean bl) {
        BugzillaLazyIssue bugzillaLazyIssue;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.isAdded(uRL)) {
                return;
            }
            bugzillaLazyIssue = this.watchedIssues.remove(uRL.toString());
        }
        if (bl) {
            this.saveIntern();
        }
        super.remove(new IssueProvider.LazyIssue[]{bugzillaLazyIssue});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String string, URL uRL, String string2, String string3) {
        KenaiBugzillaLazyIssue kenaiBugzillaLazyIssue;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isAdded(uRL)) {
                return;
            }
            kenaiBugzillaLazyIssue = new KenaiBugzillaLazyIssue(string, uRL, string2, string3, this);
            this.watchedIssues.put(uRL.toString(), kenaiBugzillaLazyIssue);
        }
        super.add(new IssueProvider.LazyIssue[]{kenaiBugzillaLazyIssue});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "initializeIssues: issue added: {0}", (Object)kenaiBugzillaLazyIssue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String string, String string2, BugzillaRepository bugzillaRepository) {
        BugzillaLazyIssue bugzillaLazyIssue;
        URL uRL = BugzillaIssueProvider.getUrl(bugzillaRepository.getUrl(), string2);
        Object object = this.LOCK;
        synchronized (object) {
            if (uRL == null || this.isAdded(uRL)) {
                return;
            }
            bugzillaLazyIssue = new BugzillaLazyIssue(string, uRL, string2, bugzillaRepository, this);
            this.watchedIssues.put(uRL.toString(), bugzillaLazyIssue);
        }
        super.add(new IssueProvider.LazyIssue[]{bugzillaLazyIssue});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "initializeIssues: issue added: {0}", (Object)bugzillaLazyIssue);
        }
    }

    private static void runCancellableCommand(Runnable runnable, String string) {
        RequestProcessor.Task task = Bugzilla.getInstance().getRequestProcessor().post(runnable);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)task);
        progressHandle.start();
        task.waitFinished();
        progressHandle.finish();
    }

    private BugzillaIssue getIssue(final BugzillaRepository bugzillaRepository, final String string) {
        assert (!EventQueue.isDispatchThread());
        int n = bugzillaRepository.getIssueCache().getStatus(string);
        final BugzillaIssue[] bugzillaIssueArray = new BugzillaIssue[1];
        if (n == 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    LOG.log(Level.FINE, "getIssue: creating issue {0}", bugzillaRepository.getUrl() + "#" + string);
                    bugzillaIssueArray[0] = (BugzillaIssue)bugzillaRepository.getIssue(string);
                }
            };
            BugzillaIssueProvider.runCancellableCommand(runnable, NbBundle.getMessage(BugzillaIssueProvider.class, (String)"BugzillaIssueProvider.loadingIssue"));
        } else {
            LOG.log(Level.FINER, "getIssue: getting issue {0} from the cache", bugzillaRepository.getUrl() + "#" + string);
            bugzillaIssueArray[0] = (BugzillaIssue)bugzillaRepository.getIssueCache().getIssue(string);
        }
        return bugzillaIssueArray[0];
    }

    private void fireIssueRemoved(BugzillaLazyIssue bugzillaLazyIssue) {
        BugzillaIssue bugzillaIssue = (BugzillaIssue)((Object)bugzillaLazyIssue.issueRef.get());
        if (bugzillaIssue != null) {
            this.support.firePropertyChange(PROPERTY_ISSUE_REMOVED, (Object)bugzillaIssue, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyKenaiLogin() {
        Object object = this.LOCK;
        synchronized (object) {
            for (BugzillaLazyIssue bugzillaLazyIssue : this.watchedIssues.values()) {
                if (!(bugzillaLazyIssue instanceof KenaiBugzillaLazyIssue)) continue;
                ((KenaiBugzillaLazyIssue)bugzillaLazyIssue).notifyKenaiLogin();
            }
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.Bugzilla.tasklist");
        LOG_LEVEL = BugzillaUtil.isAssertEnabled() ? Level.INFO : Level.FINE;
    }

    private static final class KenaiBugzillaLazyIssue
    extends BugzillaLazyIssue {
        private final String projectName;
        private boolean loginStatusChanged = true;

        public KenaiBugzillaLazyIssue(BugzillaIssue bugzillaIssue, BugzillaIssueProvider bugzillaIssueProvider) throws MalformedURLException {
            super(bugzillaIssue, bugzillaIssueProvider);
            Repository repository = bugzillaIssue.getRepository();
            if (!(repository instanceof KenaiRepository)) {
                throw new IllegalStateException("Cannot instantiate with a non kenai issue: " + (Object)((Object)bugzillaIssue));
            }
            this.projectName = ((KenaiRepository)repository).getProductName();
        }

        public KenaiBugzillaLazyIssue(String string, URL uRL, String string2, String string3, BugzillaIssueProvider bugzillaIssueProvider) {
            super(string, uRL, string2, null, bugzillaIssueProvider);
            this.projectName = string3;
        }

        protected KenaiRepository lookupRepository() {
            KenaiRepository kenaiRepository = null;
            Repository repository = null;
            if (this.loginStatusChanged) {
                try {
                    LOG.log(Level.FINE, "KenaiBugzillaLazyIssue.lookupRepository: getting repository for: " + this.projectName);
                    repository = KenaiUtil.getKenaiBugtrackingRepository((String)this.projectName);
                }
                catch (KenaiException kenaiException) {
                    LOG.log(Level.FINE, "KenaiBugzillaLazyIssue.lookupRepository: getting repository for " + this.projectName, kenaiException);
                }
                this.loginStatusChanged = false;
            }
            if (repository != null && repository instanceof KenaiRepository) {
                kenaiRepository = (KenaiRepository)repository;
            } else {
                LOG.log(Level.FINE, "KenaiBugzillaLazyIssue.lookupRepository: no repository for: " + this.projectName);
            }
            return kenaiRepository;
        }

        protected boolean canBeAutoRemoved() {
            return false;
        }

        public String getRepositoryUrl() {
            KenaiRepository kenaiRepository;
            String string = super.getRepositoryUrl();
            if (string == null && (kenaiRepository = this.lookupRepository()) != null) {
                this.setRepositoryReference(kenaiRepository);
                string = kenaiRepository.getUrl();
            }
            return string;
        }

        private void notifyKenaiLogin() {
            this.loginStatusChanged = true;
            this.setValid(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugzillaLazyIssue
    extends IssueProvider.LazyIssue {
        private final String issueId;
        private WeakReference<BugzillaRepository> repositoryRef;
        private final BugzillaIssueProvider provider;
        private WeakReference<BugzillaIssue> issueRef;
        private PropertyChangeListener issueListener;

        public BugzillaLazyIssue(BugzillaIssue bugzillaIssue, BugzillaIssueProvider bugzillaIssueProvider) throws MalformedURLException {
            super(BugzillaIssueProvider.getUrl(bugzillaIssue), bugzillaIssue.getDisplayName());
            this.issueId = bugzillaIssue.getID();
            this.provider = bugzillaIssueProvider;
            this.repositoryRef = new WeakReference<BugzillaRepository>(bugzillaIssue.getBugzillaRepository());
            this.issueRef = new WeakReference<BugzillaIssue>(bugzillaIssue);
            this.attachIssueListener(bugzillaIssue);
        }

        public BugzillaLazyIssue(String string, URL uRL, String string2, BugzillaRepository bugzillaRepository, BugzillaIssueProvider bugzillaIssueProvider) {
            super(uRL, string);
            this.issueId = string2;
            this.repositoryRef = new WeakReference<BugzillaRepository>(bugzillaRepository);
            this.provider = bugzillaIssueProvider;
            this.issueRef = new WeakReference<Object>(null);
        }

        public BugzillaIssue getIssue() {
            BugzillaIssue bugzillaIssue = (BugzillaIssue)((Object)this.issueRef.get());
            if (bugzillaIssue == null) {
                BugzillaRepository bugzillaRepository = this.getRepository();
                if (bugzillaRepository == null) {
                    LOG.log(Level.INFO, "Repository unavailable for {0}", this.getUrl().toString());
                    if (this.canBeAutoRemoved()) {
                        this.provider.remove(this.getUrl(), true);
                    }
                } else {
                    bugzillaIssue = this.provider.getIssue(bugzillaRepository, this.issueId);
                }
                this.setIssueReference(bugzillaIssue);
            }
            return bugzillaIssue;
        }

        private BugzillaRepository getRepository() {
            BugzillaRepository bugzillaRepository = (BugzillaRepository)((Object)this.repositoryRef.get());
            return bugzillaRepository;
        }

        private void setIssueReference(BugzillaIssue bugzillaIssue) {
            this.issueRef = new WeakReference<BugzillaIssue>(bugzillaIssue);
            if (bugzillaIssue != null) {
                this.applyChangesFor(bugzillaIssue);
                this.attachIssueListener(bugzillaIssue);
            }
        }

        private void attachIssueListener(BugzillaIssue bugzillaIssue) {
            if (this.issueListener == null) {
                this.issueListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        BugzillaIssue bugzillaIssue = (BugzillaIssue)((Object)BugzillaLazyIssue.this.issueRef.get());
                        if ("issue.data_changed".equals(propertyChangeEvent.getPropertyName()) && bugzillaIssue != null) {
                            BugzillaLazyIssue.this.applyChangesFor(bugzillaIssue);
                        }
                    }
                };
            }
            LOG.log(Level.FINE, "attachIssueListener: on issue {0}", bugzillaIssue.toString());
            bugzillaIssue.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.issueListener, (Object)((Object)bugzillaIssue)));
        }

        private void applyChangesFor(BugzillaIssue bugzillaIssue) {
            boolean bl = false;
            if (!this.getName().equals(bugzillaIssue.getDisplayName())) {
                this.setName(bugzillaIssue.getDisplayName());
                bl = true;
            }
            if (bl) {
                this.provider.saveIntern();
            }
        }

        public String getRepositoryUrl() {
            String string = null;
            BugzillaRepository bugzillaRepository = (BugzillaRepository)((Object)this.repositoryRef.get());
            if (bugzillaRepository != null) {
                string = bugzillaRepository.getUrl();
            }
            return string;
        }

        public List<? extends Action> getActions() {
            LinkedList<2> linkedList = new LinkedList<2>();
            linkedList.add(new AbstractAction(NbBundle.getMessage(BugzillaIssueProvider.class, (String)"BugzillaIssueProvider.resolveAction")){

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            final BugzillaIssue bugzillaIssue = BugzillaLazyIssue.this.getIssue();
                            if (bugzillaIssue == null) {
                                LOG.fine("Resole action: null issue returned");
                            } else {
                                if (!bugzillaIssue.isResolveAvailable()) {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BugzillaIssueProvider.class, (String)"BugzillaIssueProvider.resolveAction.notPermitted"), 1));
                                    return;
                                }
                                ResolveIssuePanel resolveIssuePanel = new ResolveIssuePanel(bugzillaIssue);
                                if (resolveIssuePanel.showDialog()) {
                                    LOG.finer("Resolve action: resolving...");
                                    String string = NbBundle.getMessage(BugzillaIssueProvider.class, (String)"BugzillaIssueProvider.resolveIssueMessage");
                                    final String string2 = resolveIssuePanel.getSelectedResolution();
                                    final String string3 = resolveIssuePanel.getDuplicateId();
                                    final String string4 = resolveIssuePanel.getComment();
                                    BugzillaIssueProvider.runCancellableCommand(new Runnable(){

                                        public void run() {
                                            if ("DUPLICATE".equals(string2)) {
                                                bugzillaIssue.duplicate(string3);
                                            } else {
                                                bugzillaIssue.resolve(string2);
                                            }
                                            if (string4.length() > 0) {
                                                bugzillaIssue.addComment(string4);
                                            }
                                            if (bugzillaIssue.submitAndRefresh()) {
                                                bugzillaIssue.open();
                                            }
                                        }
                                    }, MessageFormat.format(string, bugzillaIssue.getID()));
                                }
                            }
                        }
                    });
                }

                public boolean isEnabled() {
                    boolean bl = true;
                    BugzillaIssue bugzillaIssue = (BugzillaIssue)((Object)BugzillaLazyIssue.this.issueRef.get());
                    if (bugzillaIssue != null) {
                        bl = bugzillaIssue.isResolveAvailable();
                    }
                    return bl;
                }
            });
            return linkedList;
        }

        protected boolean canBeAutoRemoved() {
            return true;
        }

        protected void setRepositoryReference(BugzillaRepository bugzillaRepository) {
            if (bugzillaRepository != null) {
                this.repositoryRef = new WeakReference<BugzillaRepository>(bugzillaRepository);
            }
        }
    }
}

