/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.modules.project.rake;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class RakeProjectModule
extends ModuleInstall {
    public void restored() {
        super.restored();
        if (Boolean.getBoolean("netbeans.do.not.check.xalan")) {
            return;
        }
        long l = System.currentTimeMillis();
        boolean bl = this.checkForXalan();
        long l2 = System.currentTimeMillis();
        Logger.getLogger(RakeProjectModule.class.getName()).log(Level.FINE, "check for buggy xalan took %d", l2 - l);
        if (bl) {
            this.showWarning();
        }
    }

    private boolean checkForXalan() {
        try {
            try {
                XMLUtil.class.getClassLoader().loadClass("org.apache.xalan.Version");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            return !this.verifyWriterCorrect();
        }
        catch (Exception exception) {
            Logger.getLogger(RakeProjectModule.class.getName()).log(Level.INFO, "Cannot run JAXP", exception);
        }
        catch (Error error) {
            Logger.getLogger(RakeProjectModule.class.getName()).log(Level.SEVERE, "Cannot run JAXP", error);
        }
        return false;
    }

    private boolean verifyWriterCorrect() throws Exception {
        String string = "<root xmlns='root'/>";
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        document.getDocumentElement().appendChild(document.createElementNS("child", "child"));
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader("<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>")));
        DOMSource dOMSource = new DOMSource(document);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        StreamResult streamResult = new StreamResult(charArrayWriter);
        transformer.transform(dOMSource, streamResult);
        charArrayWriter.close();
        String string2 = charArrayWriter.toString();
        return string2.indexOf("\"child\"") != -1 || string2.indexOf("'child'") != -1;
    }

    private void showWarning() {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RakeProjectModule.class, (String)"LBL_Incompatible_Xalan"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Frame frame = WindowManager.getDefault().getMainWindow();
                if (frame == null || frame.isShowing()) {
                    LifecycleManager.getDefault().exit();
                } else {
                    frame.addWindowListener(new WindowAdapter(){

                        public void windowOpened(WindowEvent windowEvent) {
                            LifecycleManager.getDefault().exit();
                        }
                    });
                }
            }
        });
    }
}

