/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.awt.Container;
import javax.swing.JEditorPane;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.impl.ParametersPanel;
import org.netbeans.modules.refactoring.spi.impl.PreviewManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public abstract class SimpleRefactoringElementImplementation
implements RefactoringElementImplementation {
    private boolean enabled = true;
    private int status = 0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void openInEditor() {
        PositionBounds positionBounds = this.getPosition();
        if (positionBounds == null) {
            return;
        }
        PositionRef positionRef = positionBounds.getBegin();
        CloneableEditorSupport cloneableEditorSupport = positionRef.getCloneableEditorSupport();
        cloneableEditorSupport.edit();
        JEditorPane[] jEditorPaneArray = cloneableEditorSupport.getOpenedPanes();
        if (jEditorPaneArray != null) {
            JumpList.checkAddEntry();
            jEditorPaneArray[0].setCaretPosition(positionBounds.getEnd().getOffset());
            jEditorPaneArray[0].moveCaretPosition(positionRef.getOffset());
            SimpleRefactoringElementImplementation.getTopComponent(jEditorPaneArray[0]).requestActive();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ParametersPanel.class, (String)"ERR_ErrorOpeningEditor")));
        }
    }

    public void showPreview() {
        PreviewManager previewManager = PreviewManager.getDefault();
        previewManager.refresh(this);
    }

    protected String getNewFileContent() {
        return null;
    }

    private static final TopComponent getTopComponent(Container container) {
        while (!(container instanceof TopComponent)) {
            container = container.getParent();
        }
        return (TopComponent)container;
    }

    public void undoChange() {
    }
}

