/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.impl.CheckNode;
import org.netbeans.modules.refactoring.spi.impl.CheckNodeListener;
import org.netbeans.modules.refactoring.spi.impl.CheckRenderer;
import org.netbeans.modules.refactoring.spi.impl.InvalidationListener;
import org.netbeans.modules.refactoring.spi.impl.ParametersPanel;
import org.netbeans.modules.refactoring.spi.impl.PreviewManager;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanelContainer;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.netbeans.modules.refactoring.spi.impl.UndoWatcher;
import org.netbeans.modules.refactoring.spi.ui.RefactoringCustomUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactoryImplementation;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringPanel
extends JPanel
implements InvalidationListener {
    private transient JTree tree = null;
    private transient JButton refreshButton = null;
    private transient JToggleButton expandButton = null;
    private JToolBar toolBar = null;
    private transient JButton refactorButton = null;
    private transient JButton cancelButton = null;
    private transient ButtonL buttonListener = null;
    private transient JButton rerunButton = null;
    private final RefactoringUI ui;
    private final boolean isQuery;
    private transient boolean isVisible = false;
    private transient RefactoringSession session = null;
    private transient ParametersPanel parametersPanel = null;
    private transient JScrollPane scrollPane = null;
    private transient JPanel southPanel;
    public JSplitPane splitPane;
    private JPanel left;
    private Action callback = null;
    private static final int MAX_ROWS = 50;
    private transient JToggleButton logicalViewButton = null;
    private transient JToggleButton physicalViewButton = null;
    private transient JToggleButton customViewButton = null;
    private transient ProgressListener progressListener;
    private transient JButton prevMatch = null;
    private transient JButton nextMatch = null;
    private WeakReference<TopComponent> refCallerTC;
    private boolean inited = false;
    private Component customComponent;
    static Image PACKAGE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    private static final byte LOGICAL = 0;
    private static final byte PHYSICAL = 1;
    private static final byte GRAPHICAL = 2;
    private byte currentView = 1;
    RequestProcessor rp = new RequestProcessor();
    private int location;

    public RefactoringPanel(RefactoringUI refactoringUI) {
        this(refactoringUI, null);
    }

    public RefactoringPanel(RefactoringUI refactoringUI, TopComponent topComponent) {
        if (topComponent != null) {
            this.refCallerTC = new WeakReference<TopComponent>(topComponent);
        }
        this.ui = refactoringUI;
        this.isQuery = refactoringUI.isQuery();
        this.refresh(true);
    }

    public RefactoringPanel(RefactoringUI refactoringUI, RefactoringSession refactoringSession, Action action) {
        this.session = refactoringSession;
        this.ui = refactoringUI;
        this.isQuery = refactoringUI.isQuery();
        this.callback = action;
        this.initialize();
        this.refresh(false);
    }

    public static void checkEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This must happen in event thread!"));
        }
    }

    private void initialize() {
        JToolBar jToolBar;
        GridBagConstraints gridBagConstraints;
        if (this.inited) {
            return;
        }
        RefactoringPanel.checkEventThread();
        this.setFocusCycleRoot(true);
        this.splitPane = new JSplitPane(1);
        this.left = new JPanel();
        this.splitPane.setLeftComponent(this.left);
        this.left.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        if (!this.isQuery) {
            this.splitPane.setRightComponent(new JLabel(NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Preview_not_Available"), 0));
        }
        JButton[] jButtonArray = this.getButtons();
        this.southPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < jButtonArray.length; ++i) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            this.southPanel.add((Component)jButtonArray[i], gridBagConstraints);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.southPanel.add((Component)jPanel, gridBagConstraints);
        if (!this.isQuery || this.callback != null) {
            this.left.add((Component)this.southPanel, "South");
        }
        if ((jToolBar = this.getToolBar()) != null) {
            this.left.add((Component)jToolBar, "West");
        }
        this.validate();
        this.inited = true;
    }

    private JToolBar getToolBar() {
        RefactoringPanel.checkEventThread();
        this.refreshButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/refresh.png", (boolean)false));
        Dimension dimension = new Dimension(24, 24);
        this.refreshButton.setMaximumSize(dimension);
        this.refreshButton.setMinimumSize(dimension);
        this.refreshButton.setPreferredSize(dimension);
        this.refreshButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_refresh"));
        this.refreshButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_refresh").charAt(0));
        this.refreshButton.addActionListener(this.getButtonListener());
        this.expandButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/expandTree.png", (boolean)false));
        this.expandButton.setSelectedIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/colapseTree.png", (boolean)false));
        this.expandButton.setMaximumSize(dimension);
        this.expandButton.setMinimumSize(dimension);
        this.expandButton.setPreferredSize(dimension);
        this.expandButton.setSelected(true);
        this.expandButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_expandAll"));
        this.expandButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_expandAll").charAt(0));
        this.expandButton.addActionListener(this.getButtonListener());
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        this.logicalViewButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/logical_view.png", (boolean)false));
        this.logicalViewButton.setMaximumSize(dimension);
        this.logicalViewButton.setMinimumSize(dimension);
        this.logicalViewButton.setPreferredSize(dimension);
        this.logicalViewButton.setSelected(this.currentView == 0);
        this.logicalViewButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_logicalView"));
        this.logicalViewButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_logicalView").charAt(0));
        this.logicalViewButton.addActionListener(this.getButtonListener());
        this.physicalViewButton = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/file_view.png", (boolean)false));
        this.physicalViewButton.setMaximumSize(dimension);
        this.physicalViewButton.setMinimumSize(dimension);
        this.physicalViewButton.setPreferredSize(dimension);
        this.physicalViewButton.setSelected(this.currentView == 1);
        this.physicalViewButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_physicalView"));
        this.physicalViewButton.setMnemonic(NbBundle.getMessage(RefactoringPanel.class, (String)"MNEM_physicalView").charAt(0));
        this.physicalViewButton.addActionListener(this.getButtonListener());
        if (this.ui instanceof RefactoringCustomUI) {
            this.customViewButton = new JToggleButton(((RefactoringCustomUI)((Object)this.ui)).getCustomIcon());
            this.customViewButton.setMaximumSize(dimension);
            this.customViewButton.setMinimumSize(dimension);
            this.customViewButton.setPreferredSize(dimension);
            this.customViewButton.setSelected(this.currentView == 2);
            this.customViewButton.setToolTipText(((RefactoringCustomUI)((Object)this.ui)).getCustomToolTip());
            this.customViewButton.addActionListener(this.getButtonListener());
        }
        this.nextMatch = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/nextmatch.png", (boolean)false));
        this.nextMatch.setMaximumSize(dimension);
        this.nextMatch.setMinimumSize(dimension);
        this.nextMatch.setPreferredSize(dimension);
        this.nextMatch.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_nextMatch"));
        this.nextMatch.addActionListener(this.getButtonListener());
        this.prevMatch = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/prevmatch.png", (boolean)false));
        this.prevMatch.setMaximumSize(dimension);
        this.prevMatch.setMinimumSize(dimension);
        this.prevMatch.setPreferredSize(dimension);
        this.prevMatch.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_prevMatch"));
        this.prevMatch.addActionListener(this.getButtonListener());
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.expandButton);
        this.toolBar.add(this.logicalViewButton);
        this.toolBar.add(this.physicalViewButton);
        if (this.ui instanceof RefactoringCustomUI) {
            this.toolBar.add(this.customViewButton);
        }
        this.toolBar.add(this.prevMatch);
        this.toolBar.add(this.nextMatch);
        return this.toolBar;
    }

    private JButton[] getButtons() {
        RefactoringPanel.checkEventThread();
        if (this.isQuery) {
            this.refactorButton = null;
            if (this.callback == null) {
                return new JButton[0];
            }
            this.rerunButton = new JButton((String)this.callback.getValue("Name"));
            this.rerunButton.addActionListener(this.getButtonListener());
            return new JButton[]{this.rerunButton};
        }
        this.refactorButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.refactorButton, (String)NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_DoRefactor"));
        this.refactorButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_DoRefactor"));
        this.refactorButton.addActionListener(this.getButtonListener());
        this.cancelButton = new JButton(NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_CancelRefactor"));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_CancelRefactor"));
        this.cancelButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_CancelRefactor"));
        this.cancelButton.addActionListener(this.getButtonListener());
        return new JButton[]{this.refactorButton, this.cancelButton};
    }

    void switchToLogicalView() {
        this.logicalViewButton.setSelected(true);
        if (this.currentView == 0) {
            return;
        }
        this.currentView = 0;
        this.physicalViewButton.setSelected(false);
        if (this.customViewButton != null) {
            this.customViewButton.setSelected(false);
            this.prevMatch.setEnabled(true);
            this.nextMatch.setEnabled(true);
            this.expandButton.setEnabled(true);
        }
        this.refresh(false);
    }

    void switchToPhysicalView() {
        this.physicalViewButton.setSelected(true);
        if (this.currentView == 1) {
            return;
        }
        this.currentView = 1;
        this.logicalViewButton.setSelected(false);
        if (this.customViewButton != null) {
            this.customViewButton.setSelected(false);
            this.prevMatch.setEnabled(true);
            this.nextMatch.setEnabled(true);
            this.expandButton.setEnabled(true);
        }
        this.refresh(false);
    }

    void switchToCustomView() {
        this.customViewButton.setSelected(true);
        if (this.currentView == 2) {
            return;
        }
        this.currentView = (byte)2;
        this.logicalViewButton.setSelected(false);
        this.physicalViewButton.setSelected(false);
        this.prevMatch.setEnabled(false);
        this.nextMatch.setEnabled(false);
        this.expandButton.setEnabled(false);
        this.refresh(false);
    }

    private CheckNode createNode(TreeElement treeElement, Map<Object, CheckNode> map, CheckNode checkNode) {
        boolean bl = this.currentView == 0;
        CheckNode checkNode2 = null;
        checkNode2 = treeElement instanceof SourceGroup ? map.get(((SourceGroup)treeElement).getRootFolder()) : map.get(treeElement);
        if (checkNode2 != null) {
            return checkNode2;
        }
        TreeElement treeElement2 = treeElement.getParent(bl);
        String string = treeElement.getText(bl);
        Icon icon = treeElement.getIcon();
        checkNode2 = new CheckNode(treeElement, string, icon);
        CheckNode checkNode3 = treeElement2 == null ? checkNode : this.createNode(treeElement2, map, checkNode);
        checkNode3.add(checkNode2);
        if (treeElement instanceof SourceGroup) {
            map.put(((SourceGroup)treeElement).getRootFolder(), checkNode2);
        } else {
            map.put(treeElement, checkNode2);
        }
        return checkNode2;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(RefactoringPanel.class, (String)string);
    }

    protected void updateTitle() {
    }

    private void refactor() {
        RefactoringPanel.checkEventThread();
        RefactoringPanel.disableComponents(this);
        this.progressListener = new ProgressL();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RefactoringPanel.this.session.addProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.session.doRefactoring(true);
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                }
                catch (Throwable throwable) {
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.progressListener = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RefactoringPanel.this.close();
                        }
                    });
                    throw throwable;
                }
                RefactoringPanel.this.progressListener = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private int cancel() {
        RefactoringPanel.checkEventThread();
        this.close();
        return 0;
    }

    void close() {
        if (this.isQuery) {
            RefactoringPanelContainer.getUsagesComponent().removePanel(this);
        } else {
            RefactoringPanelContainer.getRefactoringComponent().removePanel(this);
        }
        this.closeNotify();
    }

    private ButtonL getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new ButtonL();
        }
        return this.buttonListener;
    }

    public void expandAll() {
        RefactoringPanel.checkEventThread();
        Cursor cursor = this.getCursor();
        this.expandButton.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.setCursor(cursor);
        this.expandButton.setEnabled(true);
        this.expandButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_collapseAll"));
        this.requestFocus();
    }

    public void collapseAll() {
        RefactoringPanel.checkEventThread();
        this.expandButton.setEnabled(false);
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = this.tree.getRowCount() - 1; i > 0; --i) {
            this.tree.collapseRow(i);
        }
        this.setCursor(cursor);
        this.expandButton.setEnabled(true);
        this.expandButton.setToolTipText(NbBundle.getMessage(RefactoringPanel.class, (String)"HINT_expandAll"));
        this.requestFocus();
    }

    @Override
    public void invalidateObject() {
        if (this.isQuery) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                RefactoringPanel.this.setRefactoringEnabled(false, false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void refresh(boolean bl) {
        Object object;
        Object object2;
        RefactoringPanel.checkEventThread();
        if (!this.isQuery) {
            LifecycleManager.getDefault().saveAll();
        }
        if (bl) {
            if (this.parametersPanel == null) {
                this.parametersPanel = new ParametersPanel(this.ui);
            }
            if ((object2 = this.parametersPanel.showDialog()) == null) {
                if (!this.parametersPanel.isCanceledDialog()) {
                    this.close();
                }
                return;
            }
            this.session = object2;
        }
        this.initialize();
        object2 = this.ui.getDescription();
        this.setToolTipText("<html>" + (String)object2 + "</html>");
        final Collection<RefactoringElement> collection = this.session.getRefactoringElements();
        this.setName(this.ui.getName());
        if (this.ui instanceof RefactoringCustomUI) {
            if (this.customComponent == null) {
                this.customComponent = ((RefactoringCustomUI)((Object)this.ui)).getCustomComponent(collection);
            }
            this.left.remove(this.customComponent);
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RefactoringPanel.class, (String)(this.isQuery ? "LBL_PreparingUsagesTree" : "LBL_PreparingRefactoringTree")));
        if (this.currentView == 2) {
            assert (this.ui instanceof RefactoringCustomUI);
            assert (this.customComponent != null);
            object = (RefactoringCustomUI)((Object)this.ui);
            this.left.remove(this.scrollPane);
            this.left.add(this.customComponent, "Center");
            UI.setComponentForRefactoringPreview(null);
            this.splitPane.validate();
            this.repaint();
            this.tree = null;
        } else {
            RequestProcessor.getDefault().post(new Runnable((String)object2, progressHandle, bl){
                final /* synthetic */ String val$description;
                final /* synthetic */ ProgressHandle val$progressHandle;
                final /* synthetic */ boolean val$showParametersPanel;
                {
                    this.val$description = string;
                    this.val$progressHandle = progressHandle;
                    this.val$showParametersPanel = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object2;
                    HashSet<CloneableEditorSupport> hashSet = new HashSet<CloneableEditorSupport>();
                    int n = 0;
                    if (!RefactoringPanel.this.isQuery) {
                        for (Object object2 : collection) {
                            if (((RefactoringElement)object2).getStatus() != 2 && ((RefactoringElement)object2).getStatus() != 3) continue;
                            ++n;
                        }
                    }
                    int n2 = collection.size();
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(" [" + n2);
                    ((StringBuffer)object2).append(' ');
                    ((StringBuffer)object2).append(n2 == 1 ? NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Occurence") : NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Occurences"));
                    if (n > 0) {
                        ((StringBuffer)object2).append(',');
                        ((StringBuffer)object2).append(' ');
                        ((StringBuffer)object2).append("<font color=#CC0000>" + n);
                        ((StringBuffer)object2).append(' ');
                        ((StringBuffer)object2).append(n == 1 ? NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Error") : NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_Errors"));
                        ((StringBuffer)object2).append("</font>");
                    }
                    ((StringBuffer)object2).append(']');
                    final CheckNode checkNode = new CheckNode(null, this.val$description + ((StringBuffer)object2).toString(), ImageUtilities.loadImageIcon((String)("org/netbeans/modules/refactoring/api/resources/" + (RefactoringPanel.this.isQuery ? "findusages.png" : "refactoring.gif")), (boolean)false));
                    HashMap hashMap = new HashMap();
                    Cursor cursor = RefactoringPanel.this.getCursor();
                    RefactoringPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    this.val$progressHandle.start(collection.size() / 10);
                    int n3 = 0;
                    try {
                        for (RefactoringElement refactoringElement : collection) {
                            RefactoringPanel.this.createNode(TreeElementFactory.getTreeElement(refactoringElement), hashMap, checkNode);
                            PositionBounds positionBounds = refactoringElement.getPosition();
                            if (positionBounds != null) {
                                CloneableEditorSupport cloneableEditorSupport = positionBounds.getBegin().getCloneableEditorSupport();
                                hashSet.add(cloneableEditorSupport);
                            }
                            if (n3 % 10 == 0) {
                                this.val$progressHandle.progress(n3 / 10);
                            }
                            ++n3;
                        }
                        UndoManager.getDefault().watch(hashSet, RefactoringPanel.this);
                    }
                    catch (RuntimeException runtimeException) {
                        RefactoringPanel.this.cleanupTreeElements();
                        throw runtimeException;
                    }
                    catch (Error error) {
                        RefactoringPanel.this.cleanupTreeElements();
                        throw error;
                    }
                    finally {
                        this.val$progressHandle.finish();
                        RefactoringPanel.this.setCursor(cursor);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (RefactoringPanel.this.tree == null) {
                                RefactoringPanel.this.tree = new JTree(checkNode);
                                if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                                    RefactoringPanel.this.tree.setBackground(UIManager.getColor("NbExplorerView.background"));
                                }
                                ToolTipManager.sharedInstance().registerComponent(RefactoringPanel.this.tree);
                                RefactoringPanel.this.tree.setCellRenderer(new CheckRenderer(RefactoringPanel.this.isQuery, RefactoringPanel.this.tree.getBackground()));
                                String string = NbBundle.getMessage(RefactoringPanel.class, (String)"ACSD_usagesTree");
                                RefactoringPanel.this.tree.getAccessibleContext().setAccessibleDescription(string);
                                RefactoringPanel.this.tree.getAccessibleContext().setAccessibleName(string);
                                CheckNodeListener checkNodeListener = new CheckNodeListener(RefactoringPanel.this.isQuery);
                                RefactoringPanel.this.tree.addMouseListener(checkNodeListener);
                                RefactoringPanel.this.tree.addKeyListener(checkNodeListener);
                                RefactoringPanel.this.tree.setToggleClickCount(0);
                                RefactoringPanel.this.scrollPane = new JScrollPane(RefactoringPanel.this.tree);
                                RefactoringPanel.this.left.add((Component)RefactoringPanel.this.scrollPane, "Center");
                                RefactoringPanel.this.validate();
                            } else {
                                RefactoringPanel.this.tree.setModel(new DefaultTreeModel(checkNode));
                            }
                            RefactoringPanel.this.tree.setRowHeight((int)((CheckRenderer)RefactoringPanel.this.tree.getCellRenderer()).getPreferredSize().getHeight());
                            if (val$showParametersPanel) {
                                RefactoringPanel.this.splitPane.setDividerLocation(0.3);
                                if (collection.size() < 50) {
                                    RefactoringPanel.this.expandAll();
                                    if (!RefactoringPanel.this.isQuery) {
                                        RefactoringPanel.this.selectNextUsage();
                                    }
                                } else {
                                    RefactoringPanel.this.expandButton.setSelected(false);
                                }
                            } else if (RefactoringPanel.this.expandButton.isSelected()) {
                                RefactoringPanel.this.expandAll();
                                if (!RefactoringPanel.this.isQuery) {
                                    RefactoringPanel.this.selectNextUsage();
                                }
                            } else {
                                RefactoringPanel.this.expandButton.setSelected(false);
                            }
                            RefactoringPanel.this.tree.setSelectionRow(0);
                            RefactoringPanel.this.requestFocus();
                            RefactoringPanel.this.setRefactoringEnabled(true, true);
                        }
                    });
                }
            });
        }
        if (!this.isVisible) {
            object = this.isQuery ? RefactoringPanelContainer.getUsagesComponent() : RefactoringPanelContainer.getRefactoringComponent();
            object.open();
            object.requestActive();
            ((RefactoringPanelContainer)((Object)object)).addPanel(this);
            this.isVisible = true;
        }
        this.setRefactoringEnabled(false, true);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.refactorButton != null) {
            this.refactorButton.requestFocus();
        } else if (this.tree != null) {
            this.tree.requestFocus();
        }
    }

    void setRefactoringEnabled(boolean bl, boolean bl2) {
        RefactoringPanel.checkEventThread();
        if (this.tree != null) {
            if (!bl) {
                CheckNode checkNode = (CheckNode)this.tree.getModel().getRoot();
                if (!bl2) {
                    checkNode.setNeedsRefresh();
                } else {
                    checkNode.setDisabled();
                }
                this.tree.setModel(new DefaultTreeModel(checkNode, false));
            }
            this.tree.setEnabled(bl);
            if (this.refactorButton != null) {
                this.refactorButton.setEnabled(bl);
            }
        }
    }

    private static void disableComponents(Container container) {
        RefactoringPanel.checkEventThread();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i].isEnabled()) {
                componentArray[i].setEnabled(false);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            RefactoringPanel.disableComponents((Container)componentArray[i]);
        }
    }

    void selectNextUsage() {
        CheckNodeListener.selectNextPrev(true, this.isQuery, this.tree);
    }

    void selectPrevUsage() {
        CheckNodeListener.selectNextPrev(false, this.isQuery, this.tree);
    }

    public void storeDividerLocation() {
        if (this.splitPane.getRightComponent() != null) {
            this.location = this.splitPane.getDividerLocation();
        }
    }

    public void restoreDeviderLocation() {
        if (this.splitPane.getRightComponent() != null) {
            this.splitPane.setDividerLocation(this.location);
        }
    }

    private static String normalize(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        boolean bl = false;
        int n2 = 0;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                if (bl) continue;
                cArray2[n2++] = 32;
                bl = true;
                continue;
            }
            cArray2[n2++] = cArray[i];
            bl = false;
        }
        return new String(cArray2, 0, n2);
    }

    protected void closeNotify() {
        TopComponent topComponent;
        UndoWatcher.stopWatching(this);
        if (this.tree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
            this.scrollPane.getViewport().remove(this.tree);
        }
        if (this.scrollPane != null) {
            this.scrollPane.setViewport(null);
        }
        if (this.refCallerTC != null && (topComponent = (TopComponent)this.refCallerTC.get()) != null && topComponent.isShowing()) {
            topComponent.requestActive();
        }
        this.cleanupTreeElements();
        PreviewManager.getDefault().clean(this);
        this.tree = null;
        this.session = null;
        this.parametersPanel = null;
    }

    private void cleanupTreeElements() {
        for (TreeElementFactoryImplementation treeElementFactoryImplementation : Lookup.getDefault().lookupAll(TreeElementFactoryImplementation.class)) {
            treeElementFactoryImplementation.cleanUp();
        }
    }

    private static class ProgressL
    implements ProgressListener {
        private ProgressHandle handle;
        private Dialog d;
        private int counter;

        private ProgressL() {
        }

        public void start(final ProgressEvent progressEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressL.this.counter = 0;
                    String string = NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_RefactorProgressLabel");
                    ProgressL.this.handle = ProgressHandleFactory.createHandle((String)string);
                    JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)ProgressL.this.handle);
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    jPanel.setBorder(new EmptyBorder(12, 12, 11, 11));
                    JLabel jLabel = new JLabel(string);
                    jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
                    jPanel.add((Component)jLabel, "North");
                    jPanel.add((Component)jComponent, "Center");
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(RefactoringPanel.class, (String)"LBL_RefactoringInProgress"), true, new Object[0], null, 0, null, null);
                    dialogDescriptor.setLeaf(true);
                    ProgressL.this.d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    ((JDialog)ProgressL.this.d).setDefaultCloseOperation(0);
                    ProgressL.this.handle.start(progressEvent.getCount());
                    ProgressL.this.d.setVisible(true);
                }
            });
        }

        public void step(ProgressEvent progressEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ProgressL.this.handle.progress(++ProgressL.this.counter);
                    }
                    catch (Throwable throwable) {
                        ErrorManager.getDefault().notify(1, throwable);
                    }
                }
            });
        }

        public void stop(ProgressEvent progressEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressL.this.handle.finish();
                    ProgressL.this.d.setVisible(false);
                }
            });
        }
    }

    private class ButtonL
    implements ActionListener {
        private ButtonL() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == RefactoringPanel.this.cancelButton) {
                RefactoringPanel.this.cancel();
            } else if (object == RefactoringPanel.this.refactorButton) {
                RefactoringPanel.this.refactor();
            } else if (object == RefactoringPanel.this.rerunButton) {
                RefactoringPanel.this.close();
                RefactoringPanel.this.callback.actionPerformed(actionEvent);
            } else if (object == RefactoringPanel.this.expandButton && RefactoringPanel.this.tree != null) {
                if (RefactoringPanel.this.expandButton.isSelected()) {
                    RefactoringPanel.this.expandAll();
                } else {
                    RefactoringPanel.this.collapseAll();
                }
            } else if (object == RefactoringPanel.this.refreshButton) {
                if (RefactoringPanel.this.callback != null) {
                    RefactoringPanel.this.close();
                    RefactoringPanel.this.callback.actionPerformed(actionEvent);
                } else {
                    RefactoringPanel.this.refresh(true);
                }
            } else if (object == RefactoringPanel.this.physicalViewButton) {
                RefactoringPanel.this.switchToPhysicalView();
            } else if (object == RefactoringPanel.this.logicalViewButton) {
                RefactoringPanel.this.switchToLogicalView();
            } else if (object == RefactoringPanel.this.customViewButton) {
                RefactoringPanel.this.switchToCustomView();
            } else if (object == RefactoringPanel.this.nextMatch) {
                RefactoringPanel.this.selectNextUsage();
            } else if (object == RefactoringPanel.this.prevMatch) {
                RefactoringPanel.this.selectPrevUsage();
            }
        }
    }
}

