/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.refactoring.api.impl.ActionsImplementationFactory;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.spi.impl.RefactoringGlobalAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExtendedDelete;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SafeDeleteAction
extends RefactoringGlobalAction
implements ExtendedDelete {
    private static final Logger LOGGER = Logger.getLogger(SafeDeleteAction.class.getName());
    private boolean regularDelete = false;

    public SafeDeleteAction() {
        super(NbBundle.getMessage(SafeDeleteAction.class, (String)"LBL_SafeDel_Action"), null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public final void performAction(Lookup lookup) {
        ActionsImplementationFactory.doDelete(lookup);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "SafeDeleteAction.performAction", new Exception());
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Lookup lookup) {
        return true;
    }

    protected Lookup getLookup(Node[] nodeArray) {
        Lookup lookup = super.getLookup(nodeArray);
        if (this.regularDelete) {
            ExplorerContext explorerContext = (ExplorerContext)lookup.lookup(ExplorerContext.class);
            if (explorerContext != null) {
                explorerContext.setDelete(true);
            } else {
                explorerContext = new ExplorerContext();
                explorerContext.setDelete(true);
                return new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)explorerContext)});
            }
        }
        return lookup;
    }

    public boolean delete(final Node[] nodeArray) {
        if (nodeArray.length < 2 && ActionsImplementationFactory.canDelete(this.getLookup(nodeArray))) {
            if (EventQueue.isDispatchThread()) {
                this.regularDelete = true;
                this.performAction(nodeArray);
                this.regularDelete = false;
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SafeDeleteAction.this.regularDelete = true;
                        SafeDeleteAction.this.performAction(nodeArray);
                        SafeDeleteAction.this.regularDelete = false;
                    }
                });
            }
            return true;
        }
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getLookup().lookup(DataObject.class) != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            if (this.doConfirm(nodeArray)) {
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            for (int i = 0; i < nodeArray.length; ++i) {
                                try {
                                    nodeArray[i].destroy();
                                    continue;
                                }
                                catch (IOException iOException) {
                                    LOGGER.log(Level.WARNING, null, iOException);
                                }
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
            return true;
        }
        return false;
    }

    private boolean doConfirm(Node[] nodeArray) {
        String string;
        String string2;
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (Boolean.TRUE.equals(nodeArray[i].getValue("customDelete"))) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        if (nodeArray.length == 1) {
            string2 = NbBundle.getMessage(ExtendedDelete.class, (String)"MSG_ConfirmDeleteObject", (Object)nodeArray[0].getDisplayName());
            string = NbBundle.getMessage(ExtendedDelete.class, (String)"MSG_ConfirmDeleteObjectTitle");
        } else {
            string2 = NbBundle.getMessage(ExtendedDelete.class, (String)"MSG_ConfirmDeleteObjects", (Object)nodeArray.length);
            string = NbBundle.getMessage(ExtendedDelete.class, (String)"MSG_ConfirmDeleteObjectsTitle");
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation));
    }
}

