/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.io.File;
import java.util.LinkedHashSet;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class Util {
    private static FileSystem[] fileSystems;

    private static FileSystem[] getFileSystems() {
        if (fileSystems != null) {
            return fileSystems;
        }
        File[] fileArray = File.listRoots();
        LinkedHashSet<FileSystem> linkedHashSet = new LinkedHashSet<FileSystem>();
        assert (fileArray != null && fileArray.length > 0) : "Could not list file roots";
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                linkedHashSet.add(fileSystem);
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new AssertionError((Object)fileStateInvalidException);
            }
        }
        FileSystem[] fileSystemArray = new FileSystem[linkedHashSet.size()];
        linkedHashSet.toArray(fileSystemArray);
        assert (fileSystemArray.length > 0) : "Could not get any filesystem";
        fileSystems = fileSystemArray;
        return fileSystemArray;
    }

    public static void addFileSystemsListener(FileChangeListener fileChangeListener) {
        FileSystem[] fileSystemArray = Util.getFileSystems();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            fileSystemArray[i].addFileChangeListener(fileChangeListener);
        }
    }

    public static void removeFileSystemsListener(FileChangeListener fileChangeListener) {
        FileSystem[] fileSystemArray = Util.getFileSystems();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            fileSystemArray[i].removeFileChangeListener(fileChangeListener);
        }
    }
}

