/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.ui.history.TooltipWindow;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends OutlineView
implements MouseListener,
MouseMotionListener {
    private RevisionsRootNode rootNode;
    private List results;
    private static final Icon NO_ICON = new NoIcon();

    public DiffTreeTable() {
        this.getOutline().setShowHorizontalLines(true);
        this.getOutline().setShowVerticalLines(false);
        this.getOutline().setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
        this.getOutline().addMouseListener((MouseListener)this);
        this.getOutline().addMouseMotionListener((MouseMotionListener)this);
    }

    private SearchHistoryPanel.DispRevision getRevisionWithTagsAt(Point point) {
        SearchHistoryPanel.DispRevision dispRevision = this.getRevisionWithPropertyAt(point, "tagsRevision");
        if (dispRevision != null && dispRevision.getBranches() != null && dispRevision.getBranches().size() + dispRevision.getTags().size() > 1) {
            return dispRevision;
        }
        return null;
    }

    private SearchHistoryPanel.DispRevision getRevisionWithPropertyAt(Point point, String string) {
        int n = this.getOutline().rowAtPoint(point);
        int n2 = this.getOutline().columnAtPoint(point);
        if (n == -1 || n2 == -1) {
            return null;
        }
        Object object = this.getOutline().getValueAt(n, n2);
        if (object instanceof Node.Property) {
            Node.Property property = (Node.Property)object;
            return (SearchHistoryPanel.DispRevision)property.getValue(string);
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Window window;
        Point point = new Point(mouseEvent.getPoint());
        SearchHistoryPanel.DispRevision dispRevision = this.getRevisionWithTagsAt(point);
        if (dispRevision != null) {
            window = SwingUtilities.windowForComponent((Component)this.getOutline());
            SwingUtilities.convertPointToScreen(point, (Component)this.getOutline());
            point.x += 10;
            point.y += 10;
            SummaryView.showAllTags(window, point, dispRevision);
        }
        if ((dispRevision = this.getRevisionWithPropertyAt(point = new Point(mouseEvent.getPoint()), "messageRevision")) != null) {
            window = SwingUtilities.windowForComponent((Component)this.getOutline());
            SwingUtilities.convertPointToScreen(point, (Component)this.getOutline());
            if ((point.x -= 150) < 0) {
                point.x = 10;
            }
            point.y += this.getOutline().getRowHeight() * 3 / 2;
            this.showMessage(window, point, dispRevision);
        }
    }

    private void showMessage(Window window, Point point, SearchHistoryPanel.DispRevision dispRevision) {
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setBackground(SummaryView.darker(UIManager.getColor("List.background")));
        jTextPane.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 0));
        jTextPane.setEditable(false);
        Style style = jTextPane.addStyle("headerStyle", null);
        StyleConstants.setBold(style, true);
        Document document = jTextPane.getDocument();
        try {
            document.insertString(document.getLength(), NbBundle.getMessage(DiffTreeTable.class, (String)"CTL_MessageWindow_Title") + "\n\n", style);
            document.insertString(document.getLength(), dispRevision.getRevision().getMessage() + "\n", null);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(DiffTreeTable.class.getName()).log(Level.WARNING, "Internal error creating commit message popup", badLocationException);
        }
        Dimension dimension = jTextPane.getPreferredSize();
        jTextPane.setPreferredSize(new Dimension(dimension.width * 7 / 6, dimension.height));
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        TooltipWindow tooltipWindow = new TooltipWindow(window, jScrollPane);
        tooltipWindow.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                jTextPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        tooltipWindow.show(point);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getRevisionWithTagsAt(mouseEvent.getPoint()) != null || this.getRevisionWithPropertyAt(mouseEvent.getPoint(), "messageRevision") != null) {
            this.getOutline().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.getOutline().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void setupColumns() {
        Node.Property[] propertyArray;
        ResourceBundle resourceBundle = NbBundle.getBundle(DiffTreeTable.class);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
            propertyArray = new Node.Property[5];
            propertyArray[3] = new ColumnDescriptor("tags", List.class, resourceBundle.getString("LBL_DiffTree_Column_Tags"), resourceBundle.getString("LBL_DiffTree_Column_Tags_Desc"));
            propertyArray[4] = new ColumnDescriptor("message", String.class, resourceBundle.getString("LBL_DiffTree_Column_Message"), resourceBundle.getString("LBL_DiffTree_Column_Message_Desc"));
        } else {
            propertyArray = new Node.Property[4];
            propertyArray[3] = new ColumnDescriptor("message", String.class, resourceBundle.getString("LBL_DiffTree_Column_Message"), resourceBundle.getString("LBL_DiffTree_Column_Message_Desc"));
        }
        propertyArray[0] = new ColumnDescriptor("location", String.class, resourceBundle.getString("LBL_DiffTree_Column_Location"), resourceBundle.getString("LBL_DiffTree_Column_Location_Desc"));
        propertyArray[1] = new ColumnDescriptor("date", String.class, resourceBundle.getString("LBL_DiffTree_Column_Time"), resourceBundle.getString("LBL_DiffTree_Column_Time_Desc"));
        propertyArray[2] = new ColumnDescriptor("username", String.class, resourceBundle.getString("LBL_DiffTree_Column_Username"), resourceBundle.getString("LBL_DiffTree_Column_Username_Desc"));
        this.setProperties(propertyArray);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = DiffTreeTable.this.getWidth();
                if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
                    if (DiffTreeTable.this.getOutline().getColumnModel().getColumnCount() != 6) {
                        return;
                    }
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(n * 15 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(n * 15 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(4).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(5).setPreferredWidth(n * 40 / 100);
                } else {
                    if (DiffTreeTable.this.getOutline().getColumnModel().getColumnCount() != 5) {
                        return;
                    }
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(n * 20 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(n * 20 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(n * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(4).setPreferredWidth(n * 40 / 100);
                }
            }
        });
    }

    void setSelection(int n) {
        this.getOutline().getSelectionModel().setValueIsAdjusting(false);
        this.getOutline().scrollRectToVisible(this.getOutline().getCellRect(n, 1, true));
        this.getOutline().getSelectionModel().setSelectionInterval(n, n);
    }

    void setSelection(SearchHistoryPanel.ResultsContainer resultsContainer) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, resultsContainer);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    void setSelection(SearchHistoryPanel.DispRevision dispRevision) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, dispRevision);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
        }
    }

    private Node getNode(Node node, Object object) {
        Object object2 = node.getLookup().lookup(object.getClass());
        if (object.equals(object2)) {
            return node;
        }
        Enumeration enumeration = node.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            Node node3 = this.getNode(node2, object);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public int[] getSelection() {
        return this.getOutline().getSelectedRows();
    }

    public int getRowCount() {
        return this.getOutline().getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        explorerManager.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List list) {
        this.results = list;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        if (explorerManager != null) {
            explorerManager.setRootContext((Node)this.rootNode);
        }
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    private class NoLeafIconRenderDataProvider
    implements RenderDataProvider {
        private RenderDataProvider delegate;

        public NoLeafIconRenderDataProvider(RenderDataProvider renderDataProvider) {
            this.delegate = renderDataProvider;
        }

        public String getDisplayName(Object object) {
            return this.delegate.getDisplayName(object);
        }

        public boolean isHtmlDisplayName(Object object) {
            return this.delegate.isHtmlDisplayName(object);
        }

        public Color getBackground(Object object) {
            return this.delegate.getBackground(object);
        }

        public Color getForeground(Object object) {
            return this.delegate.getForeground(object);
        }

        public String getTooltipText(Object object) {
            return this.delegate.getTooltipText(object);
        }

        public Icon getIcon(Object object) {
            if (DiffTreeTable.this.getOutline().getOutlineModel().isLeaf(object)) {
                return NO_ICON;
            }
            return null;
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object object) {
            RevisionNode revisionNode = object instanceof SearchHistoryPanel.ResultsContainer ? new RevisionNode((SearchHistoryPanel.ResultsContainer)object) : new RevisionNode((SearchHistoryPanel.DispRevision)object);
            return new Node[]{revisionNode};
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

