/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.lang.annotation.Inherited;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner {
    public static final Set<ElementKind> TYPE_KINDS = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE);
    private static final Logger LOGGER = Logger.getLogger(AnnotationScanner.class.getName());
    private final AnnotationModelHelper helper;

    AnnotationScanner(AnnotationModelHelper annotationModelHelper) {
        this.helper = annotationModelHelper;
    }

    public void findAnnotations(String string, Set<ElementKind> set, AnnotationHandler annotationHandler) throws InterruptedException {
        this.findAnnotations(string, set, annotationHandler, false);
    }

    public void findAnnotations(String string, Set<ElementKind> set, AnnotationHandler annotationHandler, boolean bl) throws InterruptedException {
        boolean bl2;
        Parameters.notNull((CharSequence)"searchedTypeName", (Object)string);
        Parameters.notNull((CharSequence)"kinds", set);
        Parameters.notNull((CharSequence)"handler", (Object)annotationHandler);
        LOGGER.log(Level.FINE, "findAnnotations called with {0} for {1}", new Object[]{string, set});
        if (set.isEmpty()) {
            LOGGER.log(Level.WARNING, "findAnnotations: no kinds given");
            return;
        }
        CompilationController compilationController = this.getHelper().getCompilationController();
        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
        if (typeElement == null) {
            LOGGER.log(Level.FINE, "findAnnotations: could not find type {0}", string);
            return;
        }
        ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
        Set set2 = this.getHelper().getClasspathInfo().getClassIndex().getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (set2 == null) {
            throw new InterruptedException("ClassIndex.getElements() was interrupted");
        }
        EnumSet<ElementKind> enumSet = EnumSet.copyOf(set);
        enumSet.removeAll(TYPE_KINDS);
        EnumSet<ElementKind> enumSet2 = EnumSet.copyOf(set);
        enumSet2.retainAll(TYPE_KINDS);
        boolean bl3 = bl2 = bl || this.checkInheritance(typeElement);
        if (bl2) {
            bl2 = enumSet2.size() > 0;
        }
        for (ElementHandle elementHandle2 : set2) {
            LOGGER.log(Level.FINE, "found element {0}", elementHandle2.getQualifiedName());
            TypeElement typeElement2 = (TypeElement)elementHandle2.resolve((CompilationInfo)compilationController);
            if (typeElement2 == null) continue;
            if (!enumSet2.isEmpty()) {
                this.handleAnnotation(annotationHandler, typeElement2, typeElement2, string, enumSet2, bl2);
            }
            if (enumSet.isEmpty()) continue;
            for (Element element : typeElement2.getEnclosedElements()) {
                if (!enumSet.contains((Object)element.getKind())) continue;
                this.handleAnnotation(annotationHandler, typeElement2, element, string, enumSet, false);
            }
        }
    }

    private void handleAnnotation(AnnotationHandler annotationHandler, TypeElement typeElement, Element element, String string, Set<ElementKind> set, boolean bl) throws InterruptedException {
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            String string2 = this.getHelper().getAnnotationTypeName(declaredType);
            if (string.equals(string2)) {
                LOGGER.log(Level.FINE, "notifying type {0}, element {1}, annotation {2}", new Object[]{typeElement.getQualifiedName(), element.getSimpleName(), annotationMirror});
                if (set.contains((Object)element.getKind())) {
                    annotationHandler.handleAnnotation(typeElement, element, annotationMirror);
                }
                if (!bl || element.getKind() != ElementKind.CLASS) continue;
                this.discoverHierarchy(typeElement, annotationMirror, annotationHandler, set);
                continue;
            }
            LOGGER.log(Level.FINE, "type name mismatch, ignoring type {0}, element {1}, annotation {2}", new Object[]{typeElement.getQualifiedName(), element.getSimpleName(), annotationMirror});
        }
    }

    private void discoverHierarchy(TypeElement typeElement, AnnotationMirror annotationMirror, AnnotationHandler annotationHandler, Set<ElementKind> set) throws InterruptedException {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        hashSet.add(typeElement);
        HashSet<TypeElement> hashSet2 = new HashSet<TypeElement>();
        hashSet2.add(typeElement);
        while (hashSet2.size() > 0) {
            TypeElement typeElement2 = (TypeElement)hashSet2.iterator().next();
            hashSet2.remove(typeElement2);
            Set<TypeElement> object = this.doDiscoverHierarchy(typeElement2, annotationMirror, annotationHandler, set);
            if (object.size() == 0) continue;
            hashSet.addAll(object);
            for (TypeElement typeElement3 : object) {
                hashSet2.add(typeElement3);
            }
        }
        hashSet.remove(typeElement);
        for (TypeElement typeElement4 : hashSet) {
            if (!set.contains((Object)typeElement4.getKind())) continue;
            annotationHandler.handleAnnotation(typeElement4, typeElement4, annotationMirror);
        }
    }

    private Set<TypeElement> doDiscoverHierarchy(TypeElement typeElement, AnnotationMirror annotationMirror, AnnotationHandler annotationHandler, Set<ElementKind> set) throws InterruptedException {
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
        Set set2 = this.getHelper().getClasspathInfo().getClassIndex().getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (set2 == null) {
            throw new InterruptedException("ClassIndex.getElements() was interrupted");
        }
        for (ElementHandle elementHandle2 : set2) {
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle2.getQualifiedName());
            TypeElement typeElement2 = (TypeElement)elementHandle2.resolve((CompilationInfo)this.getHelper().getCompilationController());
            if (typeElement2 == null) continue;
            hashSet.add(typeElement2);
        }
        return hashSet;
    }

    private boolean checkInheritance(TypeElement typeElement) {
        return this.getHelper().hasAnnotation(typeElement.getAnnotationMirrors(), Inherited.class.getCanonicalName());
    }

    private AnnotationModelHelper getHelper() {
        return this.helper;
    }
}

