/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class JavaHudsonLogger
implements HudsonLogger {
    private static final Logger LOG = Logger.getLogger(JavaHudsonLogger.class.getName());
    private static final Pattern STACK_TRACE = Pattern.compile("(?:\t|\\[catch\\] )at ((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");

    public HudsonLogger.HudsonLogSession createSession(HudsonJob hudsonJob) {
        return new Session();
    }

    private static class Hyperlink
    implements OutputListener {
        private final FileObject source;
        private final int lineNumber;

        Hyperlink(FileObject fileObject, int n) {
            this.source = fileObject;
            this.lineNumber = n;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.acted(true);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.acted(false);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        private void acted(final boolean bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    HudsonLogger.Helper.openAt(Hyperlink.this.source, Hyperlink.this.lineNumber - 1, -1, bl);
                }
            });
        }
    }

    private static class Session
    implements HudsonLogger.HudsonLogSession {
        private Session() {
        }

        public boolean handle(String string, OutputWriter outputWriter) {
            Matcher matcher = STACK_TRACE.matcher(string);
            if (!matcher.matches()) {
                return false;
            }
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = string2.replace('.', '/') + string3;
            int n = Integer.parseInt(matcher.group(3));
            FileObject fileObject = GlobalPathRegistry.getDefault().findResource(string4);
            if (fileObject != null) {
                try {
                    outputWriter.println(string, (OutputListener)new Hyperlink(fileObject, n));
                    return true;
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                }
            }
            outputWriter.println(string);
            return true;
        }
    }
}

