/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface HudsonSCM {
    public Configuration forFolder(File var1);

    public String translateWorkspacePath(HudsonJob var1, String var2, File var3);

    public List<? extends HudsonJobChangeItem> parseChangeSet(HudsonJob var1, Element var2);

    public static class Helper {
        private static final Logger LOG = Logger.getLogger(HudsonSCM.class.getName());

        private Helper() {
        }

        public static void addTrigger(Document document) {
            Element element = document.getDocumentElement();
            element.appendChild(document.createElement("triggers")).appendChild(document.createElement("hudson.triggers.SCMTrigger")).appendChild(document.createElement("spec")).appendChild(document.createTextNode("@hourly"));
        }

        public static String xpath(String string, Element element) {
            return Utilities.xpath(string, element);
        }

        public static void noteWillShowDiff(String string) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(HudsonSCM.class, (String)"HudsonSCM.loading_diff", (Object)string));
        }

        public static void showDiff(final StreamSource streamSource, final StreamSource streamSource2, final String string) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        DiffView diffView = Diff.getDefault().createDiff(streamSource, streamSource2);
                        DiffTopComponent diffTopComponent = new DiffTopComponent(diffView);
                        diffTopComponent.setName(string);
                        diffTopComponent.setDisplayName(NbBundle.getMessage(HudsonSCM.class, (String)"HudsonSCM.diffing", (Object)string.replaceFirst(".+/", "")));
                        diffTopComponent.open();
                        diffTopComponent.requestActive();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, null, iOException);
                    }
                }
            });
        }

        private static class DiffTopComponent
        extends TopComponent {
            DiffTopComponent(DiffView diffView) {
                this.setLayout(new BorderLayout());
                this.add(diffView.getComponent(), "Center");
            }

            public int getPersistenceType() {
                return 2;
            }

            protected String preferredID() {
                return "DiffTopComponent";
            }
        }
    }

    public static interface Configuration {
        public void configure(Document var1);

        public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems();
    }
}

