/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class ShowChanges
extends AbstractAction
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ShowChanges.class.getName());
    private final HudsonJobBuild build;

    public ShowChanges(HudsonJobBuild hudsonJobBuild) {
        super(NbBundle.getMessage(ShowChanges.class, (String)"ShowChanges.label"));
        this.build = hudsonJobBuild;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new RequestProcessor(this.build + "changes").post((Runnable)this);
    }

    public void run() {
        String string = NbBundle.getMessage(ShowChanges.class, (String)"ShowChanges.title", (Object)this.build.getDisplayName());
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, new Action[0]);
        inputOutput.select();
        OutputWriter outputWriter = inputOutput.getOut();
        OutputWriter outputWriter2 = inputOutput.getErr();
        Collection<? extends HudsonJobChangeItem> collection = this.build.getChanges();
        boolean bl = true;
        for (HudsonJobChangeItem hudsonJobChangeItem : collection) {
            if (bl) {
                bl = false;
            } else {
                outputWriter.println();
            }
            outputWriter.println(hudsonJobChangeItem.getUser() + ": " + hudsonJobChangeItem.getMessage());
            for (HudsonJobChangeItem.HudsonJobChangeFile hudsonJobChangeFile : hudsonJobChangeItem.getFiles()) {
                switch (hudsonJobChangeFile.getEditType()) {
                    case edit: {
                        outputWriter.print('\u00b1');
                        break;
                    }
                    case add: {
                        outputWriter.print('+');
                        break;
                    }
                    case delete: {
                        outputWriter.print('-');
                    }
                }
                outputWriter.print(' ');
                OutputListener outputListener = hudsonJobChangeFile.hyperlink();
                if (outputListener != null) {
                    try {
                        outputWriter.println(hudsonJobChangeFile.getName(), outputListener);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, null, iOException);
                    }
                    continue;
                }
                outputWriter.println(hudsonJobChangeFile.getName());
            }
        }
        if (bl) {
            outputWriter.println(NbBundle.getMessage(ShowChanges.class, (String)"ShowChanges.no_changes"));
        }
        outputWriter.close();
        outputWriter2.close();
    }
}

