/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.nodes.HudsonArtifactsNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class HudsonMavenModuleBuildNode
extends AbstractNode {
    private final HudsonMavenModuleBuild module;
    private String htmlDisplayName;

    public HudsonMavenModuleBuildNode(HudsonMavenModuleBuild hudsonMavenModuleBuild) {
        super(HudsonMavenModuleBuildNode.makeChildren(hudsonMavenModuleBuild), Lookups.singleton((Object)hudsonMavenModuleBuild));
        this.module = hudsonMavenModuleBuild;
        this.setName(hudsonMavenModuleBuild.getName());
        this.setDisplayName(hudsonMavenModuleBuild.getDisplayName());
        try {
            this.htmlDisplayName = hudsonMavenModuleBuild.getColor().colorizeDisplayName(XMLUtil.toElementContent((String)this.getDisplayName()));
        }
        catch (CharConversionException charConversionException) {
            this.htmlDisplayName = null;
        }
        this.setIconBaseWithExtension(hudsonMavenModuleBuild.getColor().iconBase());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(UI.showConsoleAction(this.module));
        switch (this.module.getColor()) {
            case yellow: 
            case yellow_anime: {
                arrayList.add(UI.showFailuresAction(this.module));
            }
        }
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(OpenUrlAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static Children makeChildren(final HudsonMavenModuleBuild hudsonMavenModuleBuild) {
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object ARTIFACTS = new Object();

            protected boolean createKeys(List<Object> list) {
                list.add(this.ARTIFACTS);
                return true;
            }

            protected Node createNodeForKey(Object object) {
                assert (object == this.ARTIFACTS) : object;
                return new HudsonArtifactsNode(hudsonMavenModuleBuild);
            }
        }, (boolean)false);
    }
}

