/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.notification;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.ui.notification.ProblemPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ProblemNotification {
    private static final Logger LOG = Logger.getLogger(ProblemNotification.class.getName());
    final HudsonJob job;
    private final int build;
    private final boolean failed;
    private Notification notification;

    ProblemNotification(HudsonJob hudsonJob, int n, boolean bl) {
        this.job = hudsonJob;
        this.build = n;
        this.failed = bl;
    }

    private String getTitle() {
        return NbBundle.getMessage(ProblemNotification.class, (String)(this.failed ? "ProblemNotification.title.failed" : "ProblemNotification.title.unstable"), (Object)this.job.getDisplayName(), (Object)this.build);
    }

    String showFailureText() {
        return NbBundle.getMessage(ProblemNotification.class, (String)(this.failed ? "ProblemNotification.description.failed" : "ProblemNotification.description.unstable"));
    }

    void showFailure() {
        UI.selectNode(this.job.getInstance().getUrl(), this.job.getName(), Integer.toString(this.build));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (HudsonJobBuild hudsonJobBuild : ProblemNotification.this.job.getBuilds()) {
                    if (hudsonJobBuild.getNumber() != ProblemNotification.this.build) continue;
                    if (ProblemNotification.this.failed) {
                        UI.showConsoleAction(hudsonJobBuild).actionPerformed(null);
                        break;
                    }
                    if (hudsonJobBuild.getMavenModules().isEmpty()) {
                        UI.showFailuresAction(hudsonJobBuild).actionPerformed(null);
                        break;
                    }
                    for (HudsonMavenModuleBuild hudsonMavenModuleBuild : hudsonJobBuild.getMavenModules()) {
                        switch (hudsonMavenModuleBuild.getColor()) {
                            case yellow: 
                            case yellow_anime: {
                                UI.showFailuresAction(hudsonMavenModuleBuild).actionPerformed(null);
                            }
                        }
                    }
                }
            }
        });
    }

    void ignore() {
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ProblemNotification.class, (String)"ProblemNotification.ignore.question", (Object)this.job.getDisplayName(), (Object)this.job.getInstance().getName()), NbBundle.getMessage(ProblemNotification.class, (String)"ProblemNotification.ignore.title", (Object)this.job.getDisplayName()), 2)) == NotifyDescriptor.OK_OPTION) {
            this.job.setSalient(false);
        }
    }

    private NotificationDisplayer.Priority getPriority() {
        return this.failed ? NotificationDisplayer.Priority.HIGH : NotificationDisplayer.Priority.NORMAL;
    }

    private Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/hudson/ui/resources/notification.png", (boolean)true);
    }

    void add() {
        LOG.log(Level.FINE, "Adding {0}", this);
        this.notification = NotificationDisplayer.getDefault().notify(this.getTitle(), this.getIcon(), (JComponent)new ProblemPanel(this), (JComponent)new ProblemPanel(this), this.getPriority());
    }

    void remove() {
        if (this.notification != null) {
            LOG.log(Level.FINE, "Removing {0}", this);
            this.notification.clear();
            this.notification = null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProblemNotification)) {
            return false;
        }
        ProblemNotification problemNotification = (ProblemNotification)object;
        return this.job.getName().equals(problemNotification.job.getName()) && this.build == problemNotification.build;
    }

    public int hashCode() {
        return this.job.getName().hashCode() ^ this.build;
    }

    public String toString() {
        return "ProblemNotification[" + this.job.getName() + "#" + this.build + "]";
    }
}

