/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.notification;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.notification.ProblemNotification;

public class ProblemNotificationController {
    private static final Logger LOG = Logger.getLogger(ProblemNotificationController.class.getName());
    private final HudsonInstanceImpl instance;
    private final Set<ProblemNotification> notifications = new HashSet<ProblemNotification>();

    public ProblemNotificationController(HudsonInstanceImpl hudsonInstanceImpl) {
        this.instance = hudsonInstanceImpl;
    }

    public synchronized void updateNotifications() {
        LOG.log(Level.FINE, "Updating notifications for {0}", this.instance);
        Preferences preferences = this.instance.prefs().node("notifications");
        for (HudsonJob hudsonJob : this.instance.getJobs()) {
            ProblemNotification problemNotification;
            if (!hudsonJob.isSalient()) {
                LOG.log(Level.FINER, "{0} is not being watched", hudsonJob);
                continue;
            }
            int n = hudsonJob.getLastCompletedBuild();
            if (preferences.getInt(hudsonJob.getName(), 0) >= n) {
                LOG.log(Level.FINER, "{0} was already notified", hudsonJob);
                continue;
            }
            HudsonJob.Color color = hudsonJob.getColor();
            LOG.log(Level.FINER, "{0} has status {1}", new Object[]{hudsonJob, color});
            switch (color) {
                case red: 
                case red_anime: {
                    problemNotification = new ProblemNotification(hudsonJob, n, true);
                    break;
                }
                case yellow: 
                case yellow_anime: {
                    problemNotification = new ProblemNotification(hudsonJob, n, false);
                    break;
                }
                case blue: 
                case blue_anime: {
                    this.removeFormerNotifications(hudsonJob, null);
                    problemNotification = null;
                    break;
                }
                default: {
                    problemNotification = null;
                }
            }
            if (problemNotification == null || !this.notifications.add(problemNotification)) continue;
            preferences.putInt(hudsonJob.getName(), n);
            problemNotification.add();
            this.removeFormerNotifications(hudsonJob, problemNotification);
        }
    }

    private void removeFormerNotifications(HudsonJob hudsonJob, ProblemNotification problemNotification) {
        Iterator<ProblemNotification> iterator = this.notifications.iterator();
        while (iterator.hasNext()) {
            ProblemNotification problemNotification2 = iterator.next();
            if (!problemNotification2.job.getName().equals(hudsonJob.getName()) || problemNotification2.equals(problemNotification)) continue;
            problemNotification2.remove();
            iterator.remove();
        }
    }
}

