/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.wizard;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.wizard.InstancePropertiesVisual;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InstanceDialog
extends DialogDescriptor {
    private static final Logger LOG = Logger.getLogger(InstanceDialog.class.getName());
    private final InstancePropertiesVisual panel;
    private final JButton addButton;
    private Dialog dialog;
    private HudsonInstance created;

    public InstanceDialog() {
        this(new InstancePropertiesVisual());
    }

    private InstanceDialog(InstancePropertiesVisual instancePropertiesVisual) {
        super((Object)instancePropertiesVisual, NbBundle.getMessage(InstanceDialog.class, (String)"LBL_InstanceWiz_Title"));
        this.panel = instancePropertiesVisual;
        this.addButton = new JButton(NbBundle.getMessage(InstanceDialog.class, (String)"InstanceDialog.add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceDialog.this.tryToAdd();
            }
        });
        instancePropertiesVisual.init(this.createNotificationLineSupport(), this.addButton);
        this.setOptions(new Object[]{this.addButton, NotifyDescriptor.CANCEL_OPTION});
        this.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
    }

    public HudsonInstance show() {
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        this.dialog.setVisible(true);
        LOG.log(Level.FINE, "Added Hudson instance: {0}", this.created);
        return this.created;
    }

    private void tryToAdd() {
        this.addButton.setEnabled(false);
        this.panel.showChecking();
        this.dialog.pack();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    URL uRL = new URL(InstanceDialog.this.panel.getUrl());
                    HttpURLConnection httpURLConnection = new ConnectionBuilder().homeURL(uRL).url(new URL(uRL, "?checking=redirects")).httpConnection();
                    String string = httpURLConnection.getHeaderField("X-Hudson");
                    httpURLConnection.disconnect();
                    if (string == null) {
                        this.problem(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_WrongVersion", (Object)HudsonVersion.SUPPORTED_VERSION));
                        return;
                    }
                    HudsonVersion hudsonVersion = new HudsonVersion(string);
                    if (!Utilities.isSupportedVersion(hudsonVersion)) {
                        this.problem(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_WrongVersion", (Object)HudsonVersion.SUPPORTED_VERSION));
                        return;
                    }
                    if (!"checking=redirects".equals(httpURLConnection.getURL().getQuery())) {
                        this.problem(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_incorrect_redirects"));
                        return;
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                    this.problem(NbBundle.getMessage(InstanceDialog.class, (String)"MSG_FailedToConnect"));
                    return;
                }
                InstanceDialog.this.created = HudsonInstanceImpl.createHudsonInstance(InstanceDialog.this.panel.getDisplayName(), InstanceDialog.this.panel.getUrl(), String.valueOf(InstanceDialog.this.panel.getSyncTime()));
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        InstanceDialog.this.dialog.dispose();
                        UI.selectNode(InstanceDialog.this.panel.getUrl());
                    }
                });
            }

            private void problem(final String string) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        InstanceDialog.this.addButton.setEnabled(true);
                        InstanceDialog.this.panel.checkFailed(string);
                        InstanceDialog.this.dialog.pack();
                    }
                });
            }
        });
    }
}

