/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RubyPlatformProvider {
    private static final Logger LOGGER = Logger.getLogger(RubyPlatformProvider.class.getName());
    private final PropertyEvaluator evaluator;

    public RubyPlatformProvider(PropertyEvaluator propertyEvaluator) {
        this.evaluator = propertyEvaluator;
    }

    public RubyPlatform getPlatform() {
        RubyPlatform rubyPlatform;
        this.ensurePlatformsReady();
        String string = this.evaluator.getProperty("platform.active");
        RubyPlatform rubyPlatform2 = rubyPlatform = string == null ? RubyPlatformManager.getDefaultPlatform() : RubyPlatformManager.getPlatformByID(string);
        if (rubyPlatform == null) {
            LOGGER.info("Platform with id '" + string + "' does not exist. Using default platform.");
            rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        }
        return rubyPlatform;
    }

    private void ensurePlatformsReady() {
        if (!RubyPreferences.isFirstPlatformTouch()) {
            return;
        }
        String string = NbBundle.getMessage(RubyPlatformProvider.class, (String)"RubyPlatformProvider.RubyPlatformAutoDetection");
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    RubyPlatformManager.performPlatformDetection();
                }
            }, "Ruby Platform AutoDetection");
            thread.start();
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        progressHandle.finish();
    }
}

