/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+)(-\\S+)?)?");
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String FIRST_TIME_KEY = "platform-manager-called-first-time";
    private static final String FETCH_ALL_VERSIONS = "gem-manager-fetch-all-versions";
    private static final String FETCH_GEM_DESCRIPTIONS = "gem-manager-fetch-descriptions";
    public static final Comparator<String> VERSION_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return Util.compareVersions(string, string2);
        }
    };

    private Util() {
    }

    public static boolean containsAnsiColors(String string) {
        return string.indexOf("\u001b[") != -1;
    }

    public static String stripAnsiColors(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            int n3;
            int n4 = string.indexOf("\u001b[", n);
            if (n4 == -1) {
                n4 = string.length();
            }
            int n5 = n3 = n4 == -1 ? n2 : n4;
            while (n < n3) {
                stringBuilder.append(string.charAt(n));
                ++n;
            }
            if (n4 == -1) continue;
            while (n < n2) {
                n3 = string.charAt(n);
                if (n3 == 109) {
                    ++n;
                    continue block0;
                }
                ++n;
            }
        }
        return stringBuilder.toString();
    }

    public static void adjustProxy(ProcessBuilder processBuilder) {
        Map<String, String> map;
        String string = Util.getNetBeansHttpProxy();
        if (string != null && (map = processBuilder.environment()).get("HTTP_PROXY") == null && map.get("http_proxy") == null) {
            map.put("HTTP_PROXY", string);
            map.put("http_proxy", string);
        }
    }

    private static String getNetBeansHttpProxy() {
        int n;
        String string = System.getProperty("http.proxyHost");
        if (string == null) {
            return null;
        }
        String string2 = System.getProperty("http.proxyPort");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 8080;
        }
        Preferences preferences = NbPreferences.root().node("org/netbeans/core");
        boolean bl = preferences.getBoolean(USE_PROXY_AUTHENTICATION, false);
        String string3 = "";
        if (bl) {
            string3 = preferences.get(PROXY_AUTHENTICATION_USERNAME, "") + ":" + preferences.get(PROXY_AUTHENTICATION_PASSWORD, "") + '@';
        }
        if (string.indexOf(58) == -1) {
            string = "http://" + string3 + string;
        }
        return string + ":" + n;
    }

    public static Iterable<String> dirsOnPath() {
        String string = System.getenv("PATH");
        if (string == null) {
            string = System.getenv("Path");
        }
        if (string == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(string.split(File.pathSeparator)));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (new File(string2).isDirectory()) continue;
            LOGGER.fine(string2 + " found in the PATH environment variable. But is not a valid directory. Ignoring...");
            iterator.remove();
        }
        return NbCollections.iterable(linkedHashSet.iterator());
    }

    public static String findOnPath(String string) {
        for (String string2 : Util.dirsOnPath()) {
            String string3 = string2 + File.separator + string;
            if (!new File(string3).isFile()) continue;
            return string3;
        }
        return null;
    }

    public static void preselectPlatform(JComboBox jComboBox, String string) {
        RubyPlatform rubyPlatform;
        String string2 = RubyPreferences.getPreferences().get(string, null);
        if (string2 != null && (rubyPlatform = RubyPlatformManager.getPlatformByID(string2)) != null) {
            jComboBox.setSelectedItem(rubyPlatform);
        }
    }

    public static void notifyLocalized(Class clazz, String string, int n, Object ... objectArray) {
        String string2 = NbBundle.getMessage((Class)clazz, (String)string, (Object[])objectArray);
        if (n == 0) {
            LOGGER.severe(string2);
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, n));
    }

    public static void notifyLocalized(Class clazz, String string, Object ... objectArray) {
        Util.notifyLocalized(clazz, string, 1, objectArray);
    }

    public static boolean confirmLocalized(Class clazz, String string, Object ... objectArray) {
        String string2 = NbBundle.getMessage((Class)clazz, (String)string, (Object[])objectArray);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string2, 2));
        return object.equals(NotifyDescriptor.OK_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            String string = byteArrayOutputStream.toString("UTF-8");
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static int compareVersions(String string, String string2) {
        if (string.equals(string2)) {
            return 0;
        }
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            int n3 = matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4));
            Matcher matcher2 = VERSION_PATTERN.matcher(string2);
            if (matcher2.matches()) {
                int n4;
                int n5 = Integer.parseInt(matcher2.group(1));
                int n6 = Integer.parseInt(matcher2.group(2));
                int n7 = n4 = matcher2.group(4) == null ? 0 : Integer.parseInt(matcher2.group(4));
                if (n != n5) {
                    return n - n5;
                }
                if (n2 != n6) {
                    return n2 - n6;
                }
                if (n3 != n4) {
                    return n3 - n4;
                }
            }
        }
        return string.compareTo(string2);
    }
}

