/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public class ChatNotifications {
    public static final String NOTIFICATIONS_PREF = "chat.notifications.";
    private static ImageIcon NEWMSG = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png"));
    private static ChatNotifications instance;
    private HashMap<String, MessagingHandleImpl> groupMessages = new HashMap();
    private HashMap<String, Notification> privateNotifications = new HashMap();
    private HashMap<String, Integer> privateMessagesCounter = new HashMap();
    private Preferences preferences = NbPreferences.forModule(ChatNotifications.class);

    private ChatNotifications() {
    }

    public static synchronized ChatNotifications getDefault() {
        if (instance == null) {
            instance = new ChatNotifications();
        }
        return instance;
    }

    public synchronized void removeGroup(String string) {
        MessagingHandleImpl messagingHandleImpl = this.groupMessages.get(string);
        if (messagingHandleImpl != null) {
            messagingHandleImpl.disposeNotification();
            messagingHandleImpl.notifyMessagesRead();
        }
    }

    public synchronized void removePrivate(String string) {
        Notification notification = this.privateNotifications.get(string);
        if (notification != null) {
            notification.clear();
            this.privateNotifications.remove(string);
            this.privateMessagesCounter.remove(string);
        }
    }

    synchronized void addGroupMessage(Message message) {
        assert (SwingUtilities.isEventDispatchThread());
        String string = StringUtils.parseName((String)message.getFrom());
        if (string.contains("@")) {
            string = StringUtils.parseName((String)string);
        }
        final String string2 = string;
        MessagingHandleImpl messagingHandleImpl = this.getMessagingHandle(string2);
        messagingHandleImpl.notifyMessageReceived(message);
        String string3 = null;
        try {
            int n = messagingHandleImpl.getMessageCount();
            string3 = n == 1 ? NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotification", (Object[])new Object[]{Kenai.getDefault().getProject(string2).getDisplayName(), n}) : NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotifications", (Object[])new Object[]{Kenai.getDefault().getProject(string2).getDisplayName(), n});
            String string4 = NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ReadIt");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChatTopComponent chatTopComponent = ChatTopComponent.findInstance();
                    ChatTopComponent.openAction((TopComponent)chatTopComponent, (String)"", (String)"", (boolean)false).actionPerformed(actionEvent);
                    chatTopComponent.setActiveGroup(string2);
                }
            };
            if (messagingHandleImpl.getMessageCount() > 0) {
                Notification notification = NotificationDisplayer.getDefault().notify(string3, this.getIcon(), string4, actionListener, NotificationDisplayer.Priority.NORMAL);
                messagingHandleImpl.updateNotification(notification);
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        ChatTopComponent.refreshContactList();
    }

    synchronized void addPrivateMessage(Message message) {
        assert (SwingUtilities.isEventDispatchThread());
        final String string = StringUtils.parseName((String)message.getFrom());
        Notification notification = this.privateNotifications.get(string);
        if (notification != null) {
            notification.clear();
            this.privateNotifications.remove(string);
        }
        this.increasePrivateMessagesCount(string);
        int n = this.getPrivateMessagesCount(string);
        String string2 = n == 1 ? NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotification", (Object[])new Object[]{string, n}) : NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ChatNotifications", (Object[])new Object[]{string, n});
        String string3 = NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ReadIt");
        notification = NotificationDisplayer.getDefault().notify(string2, this.getIcon(), string3, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatTopComponent chatTopComponent = ChatTopComponent.findInstance();
                chatTopComponent.open();
                chatTopComponent.setActivePrivate(string);
            }
        }, NotificationDisplayer.Priority.NORMAL);
        this.privateNotifications.put(string, notification);
        ChatTopComponent.refreshContactList();
        DashboardImpl.getInstance().getComponent().repaint();
    }

    public synchronized boolean hasNewPrivateMessages(String string) {
        return this.privateNotifications.get(string) != null;
    }

    public synchronized MessagingHandleImpl getMessagingHandle(String string) {
        MessagingHandleImpl messagingHandleImpl = this.groupMessages.get(string);
        if (messagingHandleImpl == null) {
            messagingHandleImpl = new MessagingHandleImpl(string);
            this.groupMessages.put(string, messagingHandleImpl);
        }
        return messagingHandleImpl;
    }

    synchronized void clearAll() {
        for (MessagingHandleImpl messagingHandleImpl : this.groupMessages.values()) {
            messagingHandleImpl.disposeNotification();
            messagingHandleImpl.setMessageCount(0);
            messagingHandleImpl.setOnlineCount(-1);
        }
        this.groupMessages.clear();
    }

    boolean isEnabled(String string) {
        assert (string != null);
        return this.preferences.getBoolean(NOTIFICATIONS_PREF + string, true);
    }

    void setEnabled(String string, boolean bl) {
        assert (string != null);
        this.preferences.putBoolean(NOTIFICATIONS_PREF + string, bl);
    }

    private Icon getIcon() {
        return NEWMSG;
    }

    private void increasePrivateMessagesCount(String string) {
        this.privateMessagesCounter.put(string, this.getPrivateMessagesCount(string) + 1);
    }

    private int getPrivateMessagesCount(String string) {
        Integer n = this.privateMessagesCounter.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }
}

