/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class CompoundUndoManager
extends UndoManager
implements UndoableEditListener,
DocumentListener {
    public CompoundEdit compoundEdit;
    private JTextComponent editor;
    private int lastOffset;
    private int lastLength;

    public CompoundUndoManager(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
        jTextComponent.getDocument().addUndoableEditListener(this);
    }

    public void undo() {
        this.editor.getDocument().addDocumentListener(this);
        super.undo();
        this.editor.getDocument().removeDocumentListener(this);
    }

    public void redo() {
        this.editor.getDocument().addDocumentListener(this);
        super.redo();
        this.editor.getDocument().removeDocumentListener(this);
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            this.lastLength = this.editor.getDocument().getLength();
            return;
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
        if (defaultDocumentEvent.getType().equals(DocumentEvent.EventType.CHANGE)) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            return;
        }
        int n = this.editor.getCaretPosition() - this.lastOffset;
        int n2 = this.editor.getDocument().getLength() - this.lastLength;
        if (Math.abs(n) == 1 && Math.abs(n2) == 1) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.lastOffset = this.editor.getCaretPosition();
            this.lastLength = this.editor.getDocument().getLength();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
    }

    public void startNewCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.compoundEdit = null;
        }
    }

    private CompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.lastLength = this.editor.getDocument().getLength();
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(undoableEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public void insertUpdate(final DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = documentEvent.getOffset() + documentEvent.getLength();
                n = Math.min(n, CompoundUndoManager.this.editor.getDocument().getLength());
                CompoundUndoManager.this.editor.setCaretPosition(n);
            }
        });
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.editor.setCaretPosition(documentEvent.getOffset());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        public boolean isInProgress() {
            return false;
        }

        public void undo() throws CannotUndoException {
            if (CompoundUndoManager.this.compoundEdit != null) {
                CompoundUndoManager.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoManager.this.compoundEdit = null;
        }
    }
}

