/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class InsertLinkAction
extends AbstractAction {
    private String outText;
    private JTextPane out;

    public InsertLinkAction(JTextComponent jTextComponent, JTextPane jTextPane, boolean bl, boolean bl2) {
        Project project;
        assert (jTextComponent != null);
        Document document = jTextComponent.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)jTextComponent.getCaretPosition()) + 1;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (bl) {
            this.putValue("Name", fileObject.getNameExt() + ":" + n);
            if (bl2) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 128));
            }
        } else {
            this.putValue("Name", fileObject.getNameExt());
        }
        this.outText = classPath != null ? classPath.getResourceName(fileObject) : ((project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null ? "{$" + ProjectUtils.getInformation((Project)project).getName() + "}/" + FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fileObject) : fileObject.getPath());
        if (bl) {
            this.outText = this.outText + ":" + n;
        }
        this.out = jTextPane;
        this.outText = "FILE:" + this.outText;
    }

    public InsertLinkAction(KenaiIssueAccessor.IssueHandle issueHandle, JTextPane jTextPane, boolean bl) {
        this.putValue("Name", issueHandle.getShortDisplayName());
        if (bl) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 128));
        }
        this.out = jTextPane;
        this.outText = "ISSUE:" + issueHandle.getID();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.out.getDocument().insertString(this.out.getCaretPosition(), this.outText, null);
            this.out.requestFocus();
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }
}

