/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.api.NbModuleOwnerSupport;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class KenaiPopupMenu
extends AbstractAction
implements ContextAwareAction,
PropertyChangeListener {
    private static Map<Project, String> repoForProjCache = new WeakHashMap<Project, String>();
    private static KenaiPopupMenu inst = null;

    private KenaiPopupMenu() {
    }

    public static synchronized KenaiPopupMenu getDefault() {
        if (inst == null) {
            inst = new KenaiPopupMenu();
            Kenai.getDefault().addPropertyChangeListener("url", (PropertyChangeListener)inst);
        }
        return inst;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new KenaiPopupMenuPresenter(lookup);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("url".equals(propertyChangeEvent.getPropertyName())) {
            repoForProjCache.clear();
        }
    }

    class LazyOpenKenaiProjectAction
    extends JMenuItem {
        public LazyOpenKenaiProjectAction(final String string) {
            super(NbBundle.getMessage(KenaiPopupMenu.class, (String)"OPEN_CORRESPONDING_KENAI_PROJ"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            KenaiTopComponent.findInstance().open();
                            KenaiTopComponent.findInstance().requestActive();
                        }
                    });
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            block7: {
                                ProgressHandle progressHandle = null;
                                try {
                                    progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CTL_OpenKenaiProjectAction"));
                                    progressHandle.start();
                                    KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
                                    if (kenaiProject != null) {
                                        ProjectHandleImpl projectHandleImpl = new ProjectHandleImpl(kenaiProject);
                                        DashboardImpl.getInstance().addProject(projectHandleImpl, false, true);
                                    }
                                }
                                catch (KenaiException kenaiException) {
                                    String string = kenaiException.getLocalizedMessage();
                                    if (string == null) {
                                        string = kenaiException.getCause().getLocalizedMessage();
                                    }
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)string)));
                                }
                                finally {
                                    if (progressHandle == null) break block7;
                                    progressHandle.finish();
                                    return;
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    class LazyNewIssuesAction
    extends JMenuItem {
        public LazyNewIssuesAction(Project project, final String string) {
            super(NbBundle.getMessage(KenaiPopupMenu.class, (String)"NEW_ISSUE"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(final ActionEvent actionEvent) {
                    new RequestProcessor("__ISSUETRACKER", 1).post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                            progressHandle.start();
                            try {
                                KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
                                if (kenaiProject != null) {
                                    if (kenaiProject.getFeatures(KenaiService.Type.ISSUES).length > 0) {
                                        ProjectHandleImpl projectHandleImpl = new ProjectHandleImpl(kenaiProject);
                                        DashboardImpl.getInstance().addProject(projectHandleImpl, false, true);
                                        QueryAccessor.getDefault().getCreateIssueAction(projectHandleImpl).actionPerformed(actionEvent);
                                        return;
                                    }
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_ISSUETRACKER")));
                                    return;
                                }
                            }
                            catch (KenaiException kenaiException) {
                                String string = kenaiException.getLocalizedMessage();
                                if (string == null) {
                                    string = kenaiException.getCause().getLocalizedMessage();
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)string)));
                            }
                            finally {
                                progressHandle.finish();
                            }
                        }
                    });
                }
            });
        }
    }

    class LazyFindIssuesAction
    extends JMenuItem {
        public LazyFindIssuesAction(Project project, final String string) {
            super(NbBundle.getMessage(KenaiPopupMenu.class, (String)"FIND_ISSUE"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(final ActionEvent actionEvent) {
                    new RequestProcessor("__ISSUETRACKER", 1).post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                            progressHandle.start();
                            try {
                                KenaiProject kenaiProject = Kenai.getDefault().getProject(string);
                                if (kenaiProject != null) {
                                    if (kenaiProject.getFeatures(KenaiService.Type.ISSUES).length > 0) {
                                        ProjectHandleImpl projectHandleImpl = new ProjectHandleImpl(kenaiProject);
                                        DashboardImpl.getInstance().addProject(projectHandleImpl, false, true);
                                        QueryAccessor.getDefault().getFindIssueAction(projectHandleImpl).actionPerformed(actionEvent);
                                        return;
                                    }
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_ISSUETRACKER")));
                                    return;
                                }
                            }
                            catch (KenaiException kenaiException) {
                                String string = kenaiException.getLocalizedMessage();
                                if (string == null) {
                                    string = kenaiException.getCause().getLocalizedMessage();
                                }
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)string)));
                            }
                            finally {
                                progressHandle.finish();
                            }
                        }
                    });
                }
            });
        }
    }

    private final class KenaiPopupMenuPresenter
    extends AbstractAction
    implements Presenter.Popup {
        private final Project proj;

        private KenaiPopupMenuPresenter(Lookup lookup) {
            this.proj = (Project)lookup.lookup(Project.class);
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu();
            Node[] nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
            jMenu.setVisible(false);
            if (this.proj == null || !this.isKenaiProject(this.proj) || nodeArray.length > 1) {
                if (repoForProjCache.get(this.proj) == null && nodeArray.length == 1) {
                    final JMenu jMenu2 = new JMenu(NbBundle.getMessage(KenaiPopupMenu.class, (String)"LBL_CHECKING"));
                    jMenu2.setVisible(true);
                    jMenu2.setEnabled(false);
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            String string = (String)KenaiPopupMenuPresenter.this.proj.getProjectDirectory().getAttribute("ProvidedExtensions.RemoteLocation");
                            if (string == null || KenaiProject.getNameForRepository((String)string) == null) {
                                repoForProjCache.put(KenaiPopupMenuPresenter.this.proj, "");
                                jMenu2.setVisible(false);
                            } else {
                                repoForProjCache.put(KenaiPopupMenuPresenter.this.proj, string);
                                final JMenu jMenu = KenaiPopupMenuPresenter.this.constructKenaiMenu();
                                final Component[] componentArray = jMenu.getMenuComponents();
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        jMenu.revalidate();
                                        jMenu2.setText(NbBundle.getMessage(KenaiPopupMenu.class, (String)"KENAI_POPUP"));
                                        jMenu2.setEnabled(true);
                                        for (int i = 0; i < componentArray.length; ++i) {
                                            Component component = componentArray[i];
                                            jMenu2.add(component);
                                        }
                                        jMenu2.getParent().validate();
                                    }
                                });
                            }
                        }
                    });
                    return jMenu2;
                }
            } else {
                jMenu = this.constructKenaiMenu();
            }
            return jMenu;
        }

        private JMenu constructKenaiMenu() {
            Object object;
            Object object2;
            JMenu jMenu = new JMenu(NbBundle.getMessage(KenaiPopupMenu.class, (String)"KENAI_POPUP"));
            jMenu.setVisible(true);
            String string = null;
            NbModuleOwnerSupport.OwnerInfo ownerInfo = NbModuleOwnerSupport.getInstance().getOwnerInfo(this.proj);
            if (ownerInfo != null) {
                try {
                    object2 = Kenai.getDefault().getProject(ownerInfo.getOwner());
                    if (object2 != null) {
                        string = object2.getName();
                    }
                }
                catch (KenaiException kenaiException) {
                    object = kenaiException.getLocalizedMessage();
                    if (object == null) {
                        object = kenaiException.getCause().getLocalizedMessage();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(KenaiPopupMenu.class, (String)"ERROR_CONNECTION", (Object)object)));
                }
            }
            if (string == null) {
                object2 = (String)repoForProjCache.get(this.proj);
                string = KenaiProject.getNameForRepository((String)object2);
            }
            jMenu.add(new LazyOpenKenaiProjectAction(string));
            jMenu.addSeparator();
            if (string != null) {
                jMenu.add(new LazyFindIssuesAction(this.proj, string));
                jMenu.add(new LazyNewIssuesAction(this.proj, string));
                jMenu.addSeparator();
                object2 = VersioningSupport.getOwner((File)FileUtil.toFile((FileObject)this.proj.getProjectDirectory()));
                object = new JMenu(NbBundle.getMessage(KenaiPopupMenu.class, (String)"MSG_VERSIONING"));
                JComponent[] jComponentArray = this.createVersioningSystemItems((VersioningSystem)object2, WindowManager.getDefault().getRegistry().getActivatedNodes());
                for (int i = 0; i < jComponentArray.length; ++i) {
                    JComponent jComponent = jComponentArray[i];
                    if (jComponent == null) continue;
                    ((JMenu)object).add(jComponent);
                }
                jMenu.add((JMenuItem)object);
            } else {
                jMenu.setVisible(false);
            }
            return jMenu;
        }

        private JComponent[] createVersioningSystemItems(VersioningSystem versioningSystem, Node[] nodeArray) {
            VCSAnnotator vCSAnnotator = versioningSystem.getVCSAnnotator();
            if (vCSAnnotator == null) {
                return null;
            }
            VCSContext vCSContext = VCSContext.forNodes((Node[])nodeArray);
            Action[] actionArray = vCSAnnotator.getActions(vCSContext, VCSAnnotator.ActionDestination.PopupMenu);
            JComponent[] jComponentArray = new JComponent[actionArray.length];
            int n = 0;
            for (Action action : actionArray) {
                if (action != null) {
                    JMenuItem jMenuItem = this.createmenuItem(action);
                    jComponentArray[n++] = jMenuItem;
                    continue;
                }
                jComponentArray[n++] = this.createJSeparator();
            }
            return jComponentArray;
        }

        public JSeparator createJSeparator() {
            JMenu jMenu = new JMenu();
            jMenu.addSeparator();
            return (JSeparator)jMenu.getPopupMenu().getComponent(0);
        }

        private JMenuItem createmenuItem(Action action) {
            JMenuItem jMenuItem;
            if (action instanceof SystemAction) {
                final SystemAction systemAction = (SystemAction)action;
                jMenuItem = new JMenuItem(new AbstractAction(systemAction.getName()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        systemAction.actionPerformed(actionEvent);
                    }
                });
            } else {
                jMenuItem = new JMenuItem(action);
            }
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)((String)action.getValue("Name")));
            return jMenuItem;
        }

        boolean isKenaiProject(Project project) {
            assert (project != null);
            String string = (String)repoForProjCache.get(project);
            if (string == null) {
                return false;
            }
            if (!string.equals("")) {
                return KenaiProject.getNameForRepository((String)string) != null;
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

