/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.beans.PropertyChangeListener;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.ui.spi.MemberHandle;
import org.openide.util.NbBundle;

public class MemberHandleImpl
extends MemberHandle {
    private KenaiProjectMember delegate;
    private boolean isOwner;

    public MemberHandleImpl(KenaiProjectMember kenaiProjectMember, boolean bl) {
        this.delegate = kenaiProjectMember;
        this.isOwner = bl;
    }

    public String getDisplayName() {
        return this.delegate.getKenaiUser().getUserName();
    }

    public String getName() {
        return this.delegate.getKenaiUser().getUserName();
    }

    public String getRole() {
        KenaiProjectMember.Role role = this.delegate.getRole();
        String string = null;
        if (role != null) {
            switch (role) {
                case ADMIN: {
                    string = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Admin");
                    break;
                }
                case DEVELOPER: {
                    string = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Developer");
                    break;
                }
                case CONTENT: {
                    string = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Content");
                    break;
                }
                case OBSERVER: {
                    string = NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Observer");
                }
            }
        }
        if (this.isOwner) {
            string = string + ", " + NbBundle.getMessage(MemberHandleImpl.class, (String)"Role.Owner");
        }
        return string;
    }

    public boolean hasMessages() {
        return ChatNotifications.getDefault().hasNewPrivateMessages(this.getName());
    }

    public boolean isOnline() {
        return this.delegate.getKenaiUser().isOnline();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.delegate.getKenaiUser().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.delegate.getKenaiUser().removePropertyChangeListener(propertyChangeListener);
    }

    public String getFullName() {
        return this.delegate.getKenaiUser().getFirstName() + " " + this.delegate.getKenaiUser().getLastName();
    }

    public int compareTo(MemberHandle memberHandle) {
        MemberHandleImpl memberHandleImpl = (MemberHandleImpl)memberHandle;
        if (this.isOwner) {
            return -1;
        }
        if (memberHandleImpl.isOwner) {
            return 1;
        }
        int n = this.delegate.getRole().compareTo((Enum)memberHandleImpl.delegate.getRole());
        if (n == 0) {
            return this.getDisplayName().compareToIgnoreCase(memberHandle.getDisplayName());
        }
        return n;
    }
}

