/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.OpenKenaiProjectAction;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.RemoveProjectAction;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.project.DetailsAction;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAccessorImpl
extends ProjectAccessor {
    private Kenai kenai = Kenai.getDefault();

    @Override
    public List<ProjectHandle> getMemberProjects(LoginHandle loginHandle, boolean bl) {
        try {
            LinkedList<ProjectHandle> linkedList = new LinkedList<ProjectHandle>();
            for (KenaiProject kenaiProject : this.kenai.getMyProjects(bl)) {
                linkedList.add(new ProjectHandleImpl(kenaiProject));
                for (KenaiFeature kenaiFeature : kenaiProject.getFeatures(KenaiService.Type.SOURCE)) {
                    if ("subversion".equals(kenaiFeature.getService())) {
                        try {
                            Subversion.addRecentUrl((String)kenaiFeature.getLocation());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                        continue;
                    }
                    if (!"mercurial".equals(kenaiFeature.getService())) continue;
                    try {
                        Mercurial.addRecentUrl((String)kenaiFeature.getLocation());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            }
            return linkedList;
        }
        catch (KenaiException kenaiException) {
            Logger.getLogger(ProjectAccessorImpl.class.getName()).log(Level.INFO, "getMyProject() failed", kenaiException);
            return null;
        }
    }

    @Override
    public ProjectHandle getNonMemberProject(String string, boolean bl) {
        try {
            return new ProjectHandleImpl(this.kenai.getProject(string, bl));
        }
        catch (KenaiException kenaiException) {
            Logger.getLogger(ProjectAccessorImpl.class.getName()).log(Level.INFO, "getProject() " + string + " failed", kenaiException);
            return null;
        }
    }

    @Override
    public Action getOpenNonMemberProjectAction() {
        return new OpenKenaiProjectAction();
    }

    @Override
    public Action getDetailsAction(ProjectHandle projectHandle) {
        return DetailsAction.forProject(projectHandle.getId());
    }

    private Action getOpenAction(final ProjectHandle projectHandle) {
        return new AbstractAction(NbBundle.getMessage(ProjectAccessorImpl.class, (String)"CTL_OpenProject")){

            public void actionPerformed(ActionEvent actionEvent) {
                Dashboard.getDefault().addProject(projectHandle, false, true);
            }
        };
    }

    @Override
    public Action getDefaultAction(ProjectHandle projectHandle, boolean bl) {
        return bl ? this.getDetailsAction(projectHandle) : this.getOpenAction(projectHandle);
    }

    @Override
    public Action[] getPopupActions(ProjectHandle projectHandle, boolean bl) {
        if (!bl) {
            return new Action[]{this.getOpenAction(projectHandle), new RefreshAction(projectHandle), this.getDetailsAction(projectHandle)};
        }
        return new Action[]{new RemoveProjectAction(projectHandle), new RefreshAction(projectHandle), this.getDetailsAction(projectHandle)};
    }

    @Override
    public Action getOpenWikiAction(ProjectHandle projectHandle) {
        try {
            KenaiFeature[] kenaiFeatureArray = ((ProjectHandleImpl)projectHandle).getKenaiProject().getFeatures(KenaiService.Type.WIKI);
            if (kenaiFeatureArray.length == 1) {
                return new URLDisplayerAction(kenaiFeatureArray[0].getDisplayName(), kenaiFeatureArray[0].getWebLocation());
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        return null;
    }

    @Override
    public Action getOpenDownloadsAction(ProjectHandle projectHandle) {
        try {
            KenaiFeature[] kenaiFeatureArray = ((ProjectHandleImpl)projectHandle).getKenaiProject().getFeatures(KenaiService.Type.DOWNLOADS);
            if (kenaiFeatureArray.length == 1) {
                return new URLDisplayerAction(kenaiFeatureArray[0].getDisplayName(), kenaiFeatureArray[0].getWebLocation());
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        return null;
    }

    @Override
    public Action getBookmarkAction(ProjectHandle projectHandle) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                throw new UnsupportedOperationException("Not supported yet. Please vote for http://kenai.com/jira/browse/KENAI-735");
            }
        };
    }

    @Override
    public Action getNewKenaiProjectAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                new NewKenaiProjectAction().actionPerformed(null);
            }
        };
    }

    private static class RefreshAction
    extends AbstractAction {
        private final ProjectHandle project;

        public RefreshAction(ProjectHandle projectHandle) {
            super(NbBundle.getMessage(ProjectAccessorImpl.class, (String)"CTL_RefreshProject"));
            this.project = projectHandle;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        Kenai.getDefault().getProject(RefreshAction.this.project.getId(), true);
                        RefreshAction.this.project.firePropertyChange("content", null, RefreshAction.this.project);
                    }
                    catch (KenaiException kenaiException) {
                        Exceptions.printStackTrace((Throwable)kenaiException);
                    }
                }
            });
        }
    }
}

