/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultButtonModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiAction;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.kenaiProjectTopComponent;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SourcesInformationPanel
extends JPanel
implements RefreshableContentPanel {
    public static final int MAX_ENTRIES = 20;
    private final String WAIT_STRING = String.format("<html><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td width=\"30\"><img src=\"%s\"></td><td>%s</td></tr></table></html>", SourcesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/wait.gif"), NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_WAIT"));
    private List<String> registeredButtonID = new LinkedList<String>();
    private HashMap<String, KenaiFeature> repoMap = new HashMap();
    private JTextPane srcFeedPane;

    public SourcesInformationPanel(JScrollBar jScrollBar) {
        this.initComponents();
        this.srcFeedPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    SourcesInformationPanel.this.srcFeedPane.setCursor(Cursor.getPredefinedCursor(12));
                    if (hyperlinkEvent.getDescription().startsWith("http://") || hyperlinkEvent.getDescription().startsWith("https://")) {
                        SourcesInformationPanel.this.srcFeedPane.setToolTipText(hyperlinkEvent.getDescription());
                    }
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    SourcesInformationPanel.this.srcFeedPane.setCursor(Cursor.getDefaultCursor());
                    SourcesInformationPanel.this.srcFeedPane.setToolTipText("");
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
                    return;
                }
            }
        });
    }

    private void registerHTMLButton(HTMLDocument hTMLDocument, String string, ActionListener actionListener) {
        Element element = hTMLDocument.getElement(string);
        if (element != null) {
            AttributeSet attributeSet = element.getAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                if (!"model".equals(obj.toString())) continue;
                DefaultButtonModel defaultButtonModel = (DefaultButtonModel)object;
                defaultButtonModel.setActionCommand(string);
                defaultButtonModel.addActionListener(actionListener);
            }
        }
    }

    private String addRepoHeaderWithButton(KenaiFeature kenaiFeature, String string, int n) {
        String string2 = "";
        if (kenaiFeature.getService().equals("subversion") || kenaiFeature.getService().equals("mercurial")) {
            String string3 = "MSG_MERCURIAL";
            if (kenaiFeature.getService().equals("subversion")) {
                string3 = "MSG_SUBVERSION";
            }
            string2 = string2 + String.format("<a name=\"repo%d\"></a><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td><h3>%s (%s)</h3></td><td width=\"200\" align=\"right\"><input type=\"reset\" id=\"%s\" value=\"%s\"></td></tr></table>", n, kenaiFeature.getDisplayName(), NbBundle.getMessage(SourcesInformationPanel.class, (String)string3), string, NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_GET_THIS_REPO"));
        } else {
            String string4 = "MSG_UNKNOWN_SCM";
            if (kenaiFeature.getService().equals("git")) {
                string4 = "MSG_GIT";
            }
            string2 = string2 + String.format("<a name=\"repo%d\"></a><h3>%s (%s)</h3>", n, kenaiFeature.getDisplayName(), NbBundle.getMessage(SourcesInformationPanel.class, (String)string4));
        }
        return string2;
    }

    private void initComponents() {
        this.srcFeedPane = new JTextPane();
        this.setLayout(new BorderLayout());
        this.srcFeedPane.setContentType(NbBundle.getMessage(SourcesInformationPanel.class, (String)"SourcesInformationPanel.srcFeedPane.contentType"));
        this.srcFeedPane.setEditable(false);
        this.srcFeedPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SourcesInformationPanel.this.srcFeedPaneFocusGained(focusEvent);
            }
        });
        this.add((Component)this.srcFeedPane, "Center");
    }

    private void srcFeedPaneFocusGained(FocusEvent focusEvent) {
        this.srcFeedPane.getCaret().setVisible(false);
    }

    public String loadRepoFeeds(KenaiProject kenaiProject) throws DOMException {
        this.registeredButtonID.clear();
        this.repoMap.clear();
        String string = "<div class=\"section\">";
        try {
            Object object;
            KenaiFeature kenaiFeature;
            int n;
            KenaiFeature[] kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.SOURCE);
            if (kenaiFeatureArray.length == 0) {
                return String.format("<div class=\"section\"><i>%s</i></div>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_NO_REPOS"));
            }
            if (kenaiFeatureArray.length > 1) {
                string = string + String.format("<h3>%s</h3>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_REPO_LIST"));
                for (n = 0; n < kenaiFeatureArray.length; ++n) {
                    if (Thread.interrupted()) {
                        return this.WAIT_STRING;
                    }
                    kenaiFeature = kenaiFeatureArray[n];
                    object = "MSG_UNKNOWN_SCM";
                    if (kenaiFeature.getService().equals("subversion")) {
                        object = "MSG_SUBVERSION";
                    } else if (kenaiFeature.getService().equals("git")) {
                        object = "MSG_GIT";
                    } else if (kenaiFeature.getService().equals("mercurial")) {
                        object = "MSG_MERCURIAL";
                    }
                    string = string + String.format("<div class=\"item\">-&nbsp;%s <i>(%s)</i></div>", kenaiFeature.getDisplayName(), NbBundle.getMessage(SourcesInformationPanel.class, (String)object));
                }
            }
            for (n = 0; n < kenaiFeatureArray.length; ++n) {
                if (Thread.interrupted()) {
                    return this.WAIT_STRING;
                }
                kenaiFeature = kenaiFeatureArray[n];
                if (kenaiFeature == null) continue;
                object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                String string2 = Kenai.getDefault().getUrl().toString().replaceFirst("https://", "http://");
                String string3 = string2 + kenaiFeature.getWebLocation().getPath().replaceAll("/show$", "/history.atom");
                int n2 = 0;
                NodeList nodeList = null;
                String string4 = kenaiFeature.getName().replaceAll("[^a-zA-Z0-9]", "_") + "_" + n + "__" + kenaiProject.getName().replace('-', '_');
                this.repoMap.put(string4, kenaiFeature);
                this.registeredButtonID.add(string4);
                try {
                    new URL(string3).openStream();
                    if (Thread.interrupted()) {
                        return this.WAIT_STRING;
                    }
                    Document document = ((DocumentBuilder)object).parse(string3);
                    nodeList = document.getElementsByTagName("entry");
                    n2 = nodeList.getLength();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    string = string + "<br>" + this.addRepoHeaderWithButton(kenaiFeature, string4, n);
                    string = string + String.format("<i>%s</i><br>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_REPO_NOT_ON_KENAI"));
                    string = string + String.format("<p>&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;<a href=\"%s\">%s</a></p>", kenaiProjectTopComponent.linkImageHTML, kenaiFeature.getWebLocation(), kenaiFeature.getWebLocation());
                    string = string + "<br><div style=\"height: 0px; font-size: 0px; border-width: 1px; border-style: solid; border-color: silver\"></div><br>";
                    continue;
                }
                catch (IOException iOException) {
                    string = string + "<br>" + this.addRepoHeaderWithButton(kenaiFeature, string4, n);
                    string = string + String.format("<i>%s</i><br>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_CANNOT_OPEN_FEED", (Object)string3));
                    string = string + String.format("<p>&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;<a href=\"%s\">%s</a></p>", kenaiProjectTopComponent.linkImageHTML, kenaiFeature.getWebLocation(), kenaiFeature.getWebLocation());
                    string = string + "<br><div style=\"height: 0px; font-size: 0px; border-width: 1px; border-style: solid; border-color: silver\"></div><br>";
                    continue;
                }
                if (Thread.interrupted()) {
                    return this.WAIT_STRING;
                }
                string = string + this.addRepoHeaderWithButton(kenaiFeature, string4, n);
                if (Thread.interrupted()) {
                    return this.WAIT_STRING;
                }
                string = string + "<table cellspacing=\"0\" border=\"0\" cellpadding=\"0\">";
                string = string + String.format("<tr><td colspan=\"4\"><h4>%s</h4></td></tr>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_RECENT_CHANGES"));
                if (n2 > 0 && nodeList != null) {
                    string = string + "<tr>";
                    for (int i = 0; i < n2 && i < 20; ++i) {
                        if (Thread.interrupted()) {
                            return this.WAIT_STRING;
                        }
                        Node node = nodeList.item(i);
                        NodeList nodeList2 = node.getChildNodes();
                        String string5 = null;
                        String string6 = "";
                        String string7 = String.format("<i>%s</i>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_NO_COMMIT_MSG"));
                        String string8 = null;
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Node node2;
                            if (Thread.interrupted()) {
                                return this.WAIT_STRING;
                            }
                            Node node3 = nodeList2.item(j);
                            if (node3.getNodeName().equals("title")) {
                                node2 = node3.getFirstChild();
                                if (node2 == null) continue;
                                string5 = node2.getNodeValue();
                                continue;
                            }
                            if (node3.getNodeName().equals("updated")) {
                                string6 = node3.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (node3.getNodeName().equals("link")) {
                                string8 = node3.getAttributes().getNamedItem("href").getNodeValue();
                                if (string8.startsWith(string2)) continue;
                                string8 = string2 + string8;
                                continue;
                            }
                            if (!node3.getNodeName().equals("content") || (node2 = node3.getFirstChild()) == null) continue;
                            string7 = node2.getNodeValue();
                        }
                        if (string5 == null || string8 == null) continue;
                        string = string + String.format("<td style=\"padding-top: 4px;\" valign=\"top\">%s</td><td valign=\"top\" style=\"padding-left: 3px;\"><a title=\"test\" href=\"%s\">%s</a></td><td style=\"padding-left: 4px\" valign=\"top\"><i>%s:</i></td><td style=\"padding-left: 4px\" valign=\"top\">%s</td></tr>", kenaiProjectTopComponent.linkImageHTML, string8, string5, string6.replaceAll("[a-zA-Z]", "&nbsp;"), string7);
                    }
                } else {
                    string = string + String.format("<tr><td colspan=\"4\"><i>%s</i></td></tr>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_NO_CHANGES"));
                }
                string = string + "</table><br><div style=\"height: 0px; font-size: 0px; border-width: 1px; border-style: solid; border-color: silver\"></div><br>";
            }
            string = string + "</div>";
            return string;
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
            return null;
        }
        catch (SAXException sAXException) {
            Exceptions.printStackTrace((Throwable)sAXException);
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
            return null;
        }
    }

    public void resetContent(final KenaiProject kenaiProject) {
        Font font = UIManager.getFont("Label.font");
        String string = "body { background-color: white; font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; padding: 10px;}";
        StyleSheet styleSheet = ((HTMLDocument)this.srcFeedPane.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
        styleSheet.addRule("div.section {margin-bottom: 10px;}");
        styleSheet.addRule("div.item {margin-bottom: 5px;}");
        styleSheet.addRule("i {color: gray}");
        styleSheet.addRule("h2 {color: rgb(0,22,103)}; font-size: 18pt");
        styleSheet.addRule("h3 {font-size: 15pt");
        styleSheet.addRule("h4 {font-size: 12pt");
        styleSheet.addRule("h3 a {border: 0; font-weight: normal; text-decoration: none; font-size: smaller}");
        styleSheet.addRule("h3 a img {color: white; border: 0}");
        final String string2 = this.loadRepoFeeds(kenaiProject);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (string2 != null) {
                    SourcesInformationPanel.this.srcFeedPane.setText(String.format("<html><h2>%s</h2>%s</html>", NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_PROJECT_SOURCES"), string2));
                    SourcesInformationPanel.this.srcFeedPane.validate();
                    SourcesInformationPanel.this.srcFeedPane.setCaretPosition(0);
                    for (final String string : SourcesInformationPanel.this.registeredButtonID) {
                        SourcesInformationPanel.this.registerHTMLButton((HTMLDocument)SourcesInformationPanel.this.srcFeedPane.getDocument(), string, new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                new GetSourcesFromKenaiAction(new SourceAccessorImpl.ProjectAndFeature(kenaiProject.getName(), (KenaiFeature)SourcesInformationPanel.this.repoMap.get(string), null), null).actionPerformed(actionEvent);
                            }
                        });
                    }
                }
            }
        });
    }

    public void clearContent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourcesInformationPanel.this.srcFeedPane.setText(SourcesInformationPanel.this.WAIT_STRING);
            }
        });
    }
}

