/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.spi;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.PresenceIndicator;
import org.netbeans.modules.kenai.ui.KenaiLoginTask;
import org.netbeans.modules.kenai.ui.LoginPanel;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.dashboard.UserNode;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.Scrambler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class UIUtils {
    public static final String ONLINE_ON_CHAT_PREF = ".online_chat";
    private static final String KENAI_PASSWORD_PREF = ".password";
    private static final String KENAI_USERNAME_PREF = ".username";
    public static final String ONLINE_STATUS_PREF = ".online";
    public static final String LOGIN_STATUS_PREF = ".login";
    private static Logger metricsLogger;
    private static final String USG_KENAI = "USG_KENAI";
    private static Set<String> loggedParams;

    public static String getPrefName(String string) {
        return Kenai.getDefault().getUrl().getHost() + string;
    }

    public static void waitStartupFinished() {
        KenaiLoginTask.waitStartupFinished();
    }

    private UIUtils() {
    }

    @Deprecated
    public static synchronized boolean tryLogin(boolean bl) {
        String string;
        if (Kenai.getDefault().getPasswordAuthentication() != null) {
            return true;
        }
        Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        if (!bl && !Boolean.parseBoolean(string = preferences.get(UIUtils.getPrefName(LOGIN_STATUS_PREF), "false"))) {
            return false;
        }
        string = preferences.get(UIUtils.getPrefName(KENAI_USERNAME_PREF), null);
        if (string == null) {
            return false;
        }
        String string2 = preferences.get(UIUtils.getPrefName(KENAI_PASSWORD_PREF), null);
        PresenceIndicator.getDefault().init();
        try {
            KenaiConnection.getDefault();
            Kenai.getDefault().login(string, Scrambler.getInstance().descramble(string2).toCharArray(), bl ? true : Boolean.parseBoolean(preferences.get(UIUtils.getPrefName(ONLINE_STATUS_PREF), String.valueOf(Utilities.isChatSupported()))));
        }
        catch (KenaiException kenaiException) {
            return false;
        }
        return true;
    }

    public static boolean showLogin() {
        PresenceIndicator.getDefault().init();
        final LoginPanel loginPanel = new LoginPanel();
        final Preferences preferences = NbPreferences.forModule(LoginPanel.class);
        final String string = NbBundle.getMessage(Utilities.class, (String)"CTL_Login");
        String string2 = NbBundle.getMessage(Utilities.class, (String)"CTL_Cancel");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)loginPanel, NbBundle.getMessage(Utilities.class, (String)"CTL_LoginToKenai"), true, new Object[]{string, string2}, (Object)string, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(string)) {
                    UIUtils.logKenaiUsage("LOGIN");
                    loginPanel.showProgress();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                KenaiConnection.getDefault();
                                Kenai.getDefault().login(loginPanel.getUsername(), loginPanel.getPassword(), loginPanel.isOnline());
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JDialog jDialog;
                                        JRootPane jRootPane = loginPanel.getRootPane();
                                        if (jRootPane != null && (jDialog = (JDialog)jRootPane.getParent()) != null) {
                                            jDialog.setVisible(false);
                                            jDialog.dispose();
                                        }
                                    }
                                });
                            }
                            catch (KenaiException kenaiException) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        loginPanel.showError(kenaiException);
                                    }
                                });
                            }
                        }
                    });
                    if (loginPanel.isStorePassword()) {
                        preferences.put(UIUtils.getPrefName(UIUtils.KENAI_USERNAME_PREF), loginPanel.getUsername());
                        preferences.put(UIUtils.getPrefName(UIUtils.KENAI_PASSWORD_PREF), Scrambler.getInstance().scramble(new String(loginPanel.getPassword())));
                    } else {
                        preferences.remove(UIUtils.getPrefName(UIUtils.KENAI_USERNAME_PREF));
                        preferences.remove(UIUtils.getPrefName(UIUtils.KENAI_PASSWORD_PREF));
                    }
                } else {
                    loginPanel.putClientProperty("cancel", "true");
                    JDialog jDialog = (JDialog)loginPanel.getRootPane().getParent();
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            }
        });
        dialogDescriptor.setClosingOptions(new Object[]{string2});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        String string3 = preferences.get(UIUtils.getPrefName(KENAI_USERNAME_PREF), null);
        String string4 = preferences.get(UIUtils.getPrefName(KENAI_PASSWORD_PREF), null);
        if (string3 != null && string4 != null) {
            loginPanel.setUsername(string3);
            loginPanel.setPassword(Scrambler.getInstance().descramble(string4).toCharArray());
        }
        dialog.pack();
        dialog.setResizable(false);
        loginPanel.clearStatus();
        dialog.setVisible(true);
        return loginPanel.getClientProperty("cancel") == null;
    }

    public static JLabel createUserWidget(String string) {
        return UIUtils.createUserWidget(new KenaiUserUI(string));
    }

    static JLabel createUserWidget(final KenaiUserUI kenaiUserUI) {
        final JLabel jLabel = new JLabel(kenaiUserUI.getUserName());
        jLabel.setIcon(kenaiUserUI.getIcon());
        final String string = kenaiUserUI.getKenaiUser().getFirstName() + " " + kenaiUserUI.getKenaiUser().getLastName();
        jLabel.setToolTipText(NbBundle.getMessage(UserNode.class, (String)(kenaiUserUI.getKenaiUser().isOnline() ? "LBL_ONLINE_MEMBER_TOOLTIP" : "LBL_OFFLINE_MEMBER_TOOLTIP"), (Object)kenaiUserUI.getUserName(), (Object)string));
        kenaiUserUI.user.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("Presence".equals(propertyChangeEvent.getPropertyName())) {
                    jLabel.firePropertyChange("Presence", (Boolean)propertyChangeEvent.getOldValue(), (Boolean)propertyChangeEvent.getNewValue());
                    jLabel.setToolTipText(NbBundle.getMessage(UserNode.class, (String)(kenaiUserUI.getKenaiUser().isOnline() ? "LBL_ONLINE_MEMBER_TOOLTIP" : "LBL_OFFLINE_MEMBER_TOOLTIP"), (Object)kenaiUserUI.getUserName(), (Object)string));
                    jLabel.repaint();
                }
            }
        });
        jLabel.addMouseListener(new MouseAdapter(){
            private Cursor oldCursor;

            public void mouseEntered(MouseEvent mouseEvent) {
                this.oldCursor = jLabel.getCursor();
                jLabel.setCursor(new Cursor(12));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setCursor(this.oldCursor);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    kenaiUserUI.startChat();
                }
            }
        });
        return jLabel;
    }

    public static synchronized void logKenaiUsage(Object ... objectArray) {
        String string = UIUtils.getParamString(objectArray);
        if (loggedParams == null || !loggedParams.contains(string)) {
            if (metricsLogger == null) {
                metricsLogger = Logger.getLogger("org.netbeans.ui.metrics.kenai");
            }
            LogRecord logRecord = new LogRecord(Level.INFO, USG_KENAI);
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(metricsLogger.getName());
            metricsLogger.log(logRecord);
            if (loggedParams == null) {
                loggedParams = new HashSet<String>();
            }
            loggedParams.add(string);
        }
    }

    private static String getParamString(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "";
        }
        if (objectArray.length == 1) {
            return objectArray[0].toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object.toString());
        }
        return stringBuilder.toString();
    }
}

