/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.derby;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDataStorage
extends SQLDataStorage {
    private static final Logger logger;
    private static final String SQL_QUERY_DELIMETER = "";
    private static final String tmpDir;
    private static final AtomicInteger dbIndex;
    private static boolean driverLoaded;
    private final List<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();
    private String dbURL;
    private final List<DataTableMetadata> tableMetadatas;

    public DerbyDataStorage() throws SQLException {
        this("jdbc:derby:DerbyDlight" + dbIndex.incrementAndGet() + ";create=true;user=dbuser;password=dbuserpswd");
    }

    private void initStorageTypes() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql:derby"));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    private DerbyDataStorage(String string) throws SQLException {
        super(string);
        this.dbURL = string;
        this.tableMetadatas = new ArrayList<DataTableMetadata>();
        this.initStorageTypes();
        this.connection.setHoldability(1);
    }

    public boolean shutdown() {
        boolean bl = super.shutdown();
        String string = this.dbURL.substring(this.dbURL.lastIndexOf(":") + 1, this.dbURL.indexOf(";"));
        bl = bl && Util.deleteLocalDirectory((File)new File(tmpDir + "/derby_dlight/" + string));
        return bl;
    }

    protected String classToType(Class clazz) {
        if (clazz == Integer.class) {
            return "integer";
        }
        return super.classToType(clazz);
    }

    protected void connect(String string) throws SQLException {
        this.connection = DriverManager.getConnection(string);
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    public void createTables(List<DataTableMetadata> list) {
        for (DataTableMetadata dataTableMetadata : list) {
            this.tableMetadatas.add(dataTableMetadata);
            this.createTable(dataTableMetadata);
        }
    }

    protected String getSQLQueriesDelimeter() {
        return SQL_QUERY_DELIMETER;
    }

    public boolean hasData(DataTableMetadata dataTableMetadata) {
        return dataTableMetadata.isProvidedBy(this.tableMetadatas);
    }

    public boolean supportsType(DataStorageType dataStorageType) {
        return this.getStorageTypes().contains(dataStorageType);
    }

    static {
        Serializable serializable;
        Object object;
        logger = DLightLogger.getLogger(DerbyDataStorage.class);
        dbIndex = new AtomicInteger();
        driverLoaded = false;
        String string = null;
        try {
            object = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            string = object.getTempDir();
            if (object.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                string = WindowsSupport.getInstance().convertToWindowsPath(string);
            }
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (string == null) {
            string = System.getProperty("java.io.tmpdir");
        }
        tmpDir = string;
        object = tmpDir + "/derby_dlight";
        try {
            System.setProperty("derby.system.home", (String)object);
            serializable = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            logger.info("Driver for Derby(JavaDB) (" + ((Class)serializable).getName() + ") Loaded ");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, null, exception);
        }
        serializable = new File((String)object);
        if (((File)serializable).exists()) {
            File[] fileArray = ((File)serializable).listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return file.isDirectory() && string.startsWith("DerbyDlight");
                }
            });
            int n = "DerbyDlight".length();
            int n2 = 0;
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getName().substring(n);
                try {
                    n2 = Math.max(n2, Integer.valueOf(string2));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            dbIndex.getAndSet(n2);
        }
    }
}

