/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.dlight.visualizers.TableSorter;

class MultiSortTableCellHeaderRenderer
extends DefaultTableCellRenderer {
    protected SortIcon sortIcon = new SortIcon(8);

    public MultiSortTableCellHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(10);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        Color color = null;
        Color color2 = null;
        Border border = null;
        Icon icon = null;
        if (bl2) {
            color = UIManager.getColor("TableHeader.focusCellForeground");
            color2 = UIManager.getColor("TableHeader.focusCellBackground");
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (color == null) {
            color = jTableHeader.getForeground();
        }
        if (color2 == null) {
            color2 = jTableHeader.getBackground();
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        icon = this.getSortIcon(jTable, jTable.convertColumnIndexToModel(n2));
        this.setFont(jTableHeader.getFont());
        this.setText(object != null && object != "" ? object.toString() : " ");
        this.setBorder(border);
        this.setIcon(icon);
        return this;
    }

    protected Icon getSortIcon(JTable jTable, int n) {
        if (!(jTable.getModel() instanceof TableSorter)) {
            return null;
        }
        TableSorter tableSorter = (TableSorter)jTable.getModel();
        List<Integer> list = tableSorter.getSortingColumns();
        if (list == null || list.size() == 0) {
            return null;
        }
        int n2 = 0;
        this.sortIcon.setPriority(n2);
        int n3 = list.indexOf(n);
        if (n3 == -1) {
            return null;
        }
        this.sortIcon.setSortOrder(tableSorter.sortingColumnsOrder.get(n3));
        return this.sortIcon;
    }

    static final class SortIcon
    implements Icon,
    SwingConstants {
        private static int NONE = 0;
        private int baseSize;
        private int size;
        private int direction = NONE;
        private BasicArrowButton iconRenderer;
        private double[] sizePercentages = new double[]{1.0, 0.85, 0.7, 0.55, 0.4, 0.25, 0.1};

        public SortIcon(int n) {
            this.baseSize = this.size = n;
            this.iconRenderer = new BasicArrowButton(this.direction);
        }

        public void setPriority(int n) {
            this.size = (int)((double)this.baseSize * this.sizePercentages[n]);
        }

        public void setSortOrder(boolean bl) {
            this.direction = bl ? 5 : 1;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.direction != NONE) {
                this.iconRenderer.paintTriangle(graphics, n, n2, this.size, this.direction, true);
            }
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size / 2;
        }
    }
}

