/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;

final class VisualizersSupport
implements SessionStateListener,
DLightSessionListener {
    private DLightSession.SessionState currentSessionState = null;
    private final SessionStateListener sessionStateListener;

    VisualizersSupport(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
        DLightManager dLightManager = DLightManager.getDefault();
        DLightSession dLightSession = dLightManager.getActiveSession();
        dLightManager.addDLightSessionListener((DLightSessionListener)this);
        dLightSession.addSessionStateListener((SessionStateListener)this);
        this.currentSessionState = dLightSession.getState();
    }

    protected boolean isSessionRunning() {
        return this.currentSessionState == DLightSession.SessionState.RUNNING;
    }

    protected boolean isSessionPaused() {
        return this.currentSessionState == DLightSession.SessionState.PAUSED;
    }

    protected boolean isSessionAnalyzed() {
        return this.currentSessionState == DLightSession.SessionState.ANALYZE;
    }

    public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        this.currentSessionState = sessionState2;
        if (sessionState2 == DLightSession.SessionState.PAUSED || sessionState2 == DLightSession.SessionState.ANALYZE) {
            this.sessionStateListener.sessionStateChanged(dLightSession, sessionState, sessionState2);
            return;
        }
        if (sessionState2 == DLightSession.SessionState.STARTING || sessionState2 == DLightSession.SessionState.RUNNING) {
            this.sessionStateListener.sessionStateChanged(dLightSession, sessionState, sessionState2);
            return;
        }
    }

    public void activeSessionChanged(DLightSession dLightSession, DLightSession dLightSession2) {
        if (dLightSession != null) {
            dLightSession.removeSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(dLightSession, dLightSession.getState(), dLightSession.getState());
        }
        if (dLightSession2 != null) {
            dLightSession2.addSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(dLightSession2, DLightSession.SessionState.CONFIGURATION, dLightSession2.getState());
        }
    }

    public void sessionAdded(DLightSession dLightSession) {
    }

    public void sessionRemoved(DLightSession dLightSession) {
        if (dLightSession != null) {
            dLightSession.removeSessionStateListener((SessionStateListener)this);
            this.sessionStateListener.sessionStateChanged(dLightSession, dLightSession.getState(), DLightSession.SessionState.CLOSED);
        }
    }
}

