/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackActionsProvider;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ThreadStackVisualizerConfiguration
implements TableBasedVisualizerConfiguration {
    public static final String ID = "ThreadStackVisualizerConfiguration.id";
    private ThreadDump threadDump;
    private long dumpTime;
    private StackNameProvider stackNameProvider;
    private long preferredSelection;
    private ThreadStackActionsProvider actionsProvider;
    private ExpansionMode expansionMode;
    private StackNameProvider defaultStackNameProvider = new StackNameProvider(){

        public String getStackName(ThreadSnapshot threadSnapshot) {
            String string = "";
            ThreadState.MSAState mSAState = threadSnapshot.getState();
            ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
            if (threadStateResources != null) {
                string = threadStateResources.name;
            }
            long l = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadSnapshot.getTimestamp());
            String string2 = TimeLineUtils.getMillisValue(l);
            return NbBundle.getMessage(ThreadStackVisualizerConfiguration.class, (String)"ThreadStackVisualizerStackAt1", (Object)string, (Object)threadSnapshot.getThreadInfo().getThreadName(), (Object)string2);
        }
    };

    public ThreadStackVisualizerConfiguration(long l, ThreadDump threadDump, StackNameProvider stackNameProvider, long l2, ThreadStackActionsProvider threadStackActionsProvider) {
        this.dumpTime = l;
        this.threadDump = threadDump;
        this.stackNameProvider = stackNameProvider;
        this.preferredSelection = l2;
        this.actionsProvider = threadStackActionsProvider;
        int n = NbPreferences.forModule(ThreadStackVisualizerConfiguration.class).getInt("expansionMode", 1);
        n = Math.max(Math.min(n, 2), 0);
        this.expansionMode = ExpansionMode.values()[n];
    }

    void update(ThreadStackVisualizerConfiguration threadStackVisualizerConfiguration) {
        this.dumpTime = threadStackVisualizerConfiguration.dumpTime;
        this.threadDump = threadStackVisualizerConfiguration.threadDump;
        this.stackNameProvider = threadStackVisualizerConfiguration.stackNameProvider;
        this.preferredSelection = threadStackVisualizerConfiguration.preferredSelection;
        this.actionsProvider = threadStackVisualizerConfiguration.actionsProvider;
        this.expansionMode = threadStackVisualizerConfiguration.expansionMode;
    }

    ThreadDump getThreadDump() {
        return this.threadDump;
    }

    long getDumpTime() {
        return this.dumpTime;
    }

    ThreadStackActionsProvider getStackNodeActionsProvider() {
        return this.actionsProvider;
    }

    StackNameProvider getStackNameProvider() {
        if (this.stackNameProvider == null) {
            return this.defaultStackNameProvider;
        }
        return this.stackNameProvider;
    }

    long getPreferredSelection() {
        return this.preferredSelection;
    }

    ExpansionMode getPrefferedExpansion() {
        return this.expansionMode;
    }

    public DataModelScheme getSupportedDataScheme() {
        return DataModelSchemeProvider.getInstance().getScheme("model:stack");
    }

    public String getID() {
        return ID;
    }

    public DataTableMetadata getMetadata() {
        return CpuSamplingSupport.CPU_SAMPLE_TABLE;
    }

    public static interface StackNameProvider {
        public String getStackName(ThreadSnapshot var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpansionMode {
        ExpandAll,
        ExpandCurrent,
        CollapseAll;

    }
}

