/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateHeaderRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadStateCellRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private Color unselectedBackground;
    private Color unselectedForeground;
    private ThreadStateColumnImpl threadData;
    private ThreadsPanel viewManager;
    private long dataEnd;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private TimeLine timeLine;
    private Collection<TimeIntervalDataFilter> timeFilters;
    private EnumMap<ThreadState.MSAState, AtomicInteger> map = new EnumMap(ThreadState.MSAState.class);
    private JTable table;
    private boolean isShiftCounted;
    private float BorderDarkerFactor = 0.9f;
    private float AlphaCompositeConstant = 0.5f;
    private Color TIME_SELECTION_BORDER = new Color(255, 150, 150);

    public ThreadStateCellRenderer(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.isFocusOwner() ? jTable.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            super.setBackground(jTable.isFocusOwner() ? jTable.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if ((n & 1) == 0) {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(UIUtils.getDarker(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground()));
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        if (object instanceof ThreadStateColumnImpl) {
            this.threadData = (ThreadStateColumnImpl)object;
        }
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.dataEnd = this.viewManager.getDataEnd();
        this.timeLine = this.viewManager.getTimeLine();
        this.timeFilters = this.viewManager.getTimeIntervalSelection();
        this.table = jTable;
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = this.getToolTipText(mouseEvent.getPoint());
        if (string != null) {
            return string;
        }
        return super.getToolTipText(mouseEvent);
    }

    public String getToolTipText(Point point) {
        int n = this.getStateIndex(point);
        if (n >= 0) {
            ThreadState threadState = this.threadData.getThreadStateAt(n);
            long l = ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) - this.dataStart;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(NbBundle.getMessage(ThreadStateCellRenderer.class, (String)"StateColumnTimeTip", (Object)TimeLineUtils.getMillisValue(l)));
            EnumMap<ThreadState.MSAState, AtomicInteger> enumMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
            ThreadStateColumnImpl.fillMap(this.viewManager, threadState, enumMap);
            ThreadStateColumnImpl.roundMap(enumMap);
            stringBuilder.append("<table>");
            OrderedEnumStateIterator orderedEnumStateIterator = new OrderedEnumStateIterator(enumMap);
            while (orderedEnumStateIterator.hasNext()) {
                Object object = orderedEnumStateIterator.next();
                int n2 = ((AtomicInteger)object.getValue()).get();
                ThreadState.MSAState mSAState = (ThreadState.MSAState)object.getKey();
                ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
                if (threadStateResources == null) continue;
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>");
                stringBuilder.append("<font bgcolor=\"#");
                stringBuilder.append(ThreadStateCellRenderer.colorToHexString(threadStateResources.color));
                stringBuilder.append("\">&nbsp;&nbsp;");
                stringBuilder.append("</font></td>");
                stringBuilder.append("<td>");
                stringBuilder.append(threadStateResources.name);
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append("" + n2 + "%");
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        return null;
    }

    private int getStateIndex(Point point) {
        int n;
        if (this.threadData != null && (n = this.getFirstVisibleDataUnit()) != -1) {
            int n2 = Math.abs(this.getX());
            if (this.viewEnd - this.viewStart > 0L) {
                float f = (float)n2 / (float)(this.viewEnd - this.viewStart);
                while (n < this.threadData.size() && ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(n).getTimeStamp()) <= this.viewEnd) {
                    if (this.threadData.isAlive(n)) {
                        int n3;
                        ThreadState threadState = this.threadData.getThreadStateAt(n);
                        int n4 = Math.max((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) - this.viewStart) * f), 0);
                        if (n < this.threadData.size() - 1) {
                            n3 = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(n + 1).getTimeStamp()) - this.viewStart) * f), n2);
                        } else {
                            int n5 = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadState.getMSASamplePeriod());
                            n3 = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) + (long)n5 - this.viewStart) * f + 0.5f), n2);
                        }
                        if (n4 <= point.x && point.x < n3) {
                            return n;
                        }
                    }
                    ++n;
                }
            }
        }
        return -1;
    }

    private static String colorToHexString(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    private void calculateShift() {
        if (!this.isShiftCounted) {
            Point point = this.table.getTableHeader().getLocationOnScreen();
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, this);
            int n = this.table.getTableHeader().getColumnModel().getColumn(0).getWidth();
            int n2 = point2.x - point.x - n;
            this.isShiftCounted = true;
            ThreadStateHeaderRenderer.shift = n2;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.calculateShift();
        this.paintTimeMarks(graphics);
        if (this.threadData != null) {
            int n = this.getFirstVisibleDataUnit();
            if (n != -1) {
                int n2 = this.getWidth();
                if (this.viewEnd - this.viewStart > 0L) {
                    float f = (float)n2 / (float)(this.viewEnd - this.viewStart);
                    while (n < this.threadData.size() && ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(n).getTimeStamp()) <= this.viewEnd) {
                        if (this.threadData.isAlive(n)) {
                            this.paintThreadState(graphics, n, this.threadData.getThreadStateAt(n), f, n2);
                        }
                        ++n;
                    }
                }
            }
            this.paintGray(graphics);
        }
        this.paintTimeLine(graphics);
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public void validate() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    private int getFirstVisibleDataUnit() {
        for (int i = 0; i < this.threadData.size(); ++i) {
            long l = ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(i).getTimeStamp());
            if (l <= this.viewEnd && i == this.threadData.size() - 1) {
                return i;
            }
            if (!(l <= this.viewStart ? ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(i + 1).getTimeStamp()) > this.viewStart : l <= this.viewEnd)) continue;
            return i;
        }
        return -1;
    }

    private List<Range<Long>> getGray() {
        Collection<TimeIntervalDataFilter> collection = this.timeFilters;
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        Range range = new Range((Number)ThreadStateColumnImpl.timeInervalToNanoSeconds(this.viewStart - this.dataStart), (Number)ThreadStateColumnImpl.timeInervalToNanoSeconds(this.viewEnd - this.dataStart));
        ArrayList<Range> arrayList = new ArrayList<Range>(this.timeFilters.size());
        for (TimeIntervalDataFilter timeIntervalDataFilter : collection) {
            arrayList.add(timeIntervalDataFilter.getInterval());
        }
        return range.subtract(arrayList);
    }

    private void paintThreadState(Graphics graphics, int n, ThreadState threadState, float f, int n2) {
        int n3;
        int n4;
        int n5 = Math.max((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) - this.viewStart) * f), 0);
        if (n < this.threadData.size() - 1) {
            n4 = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(this.threadData.getThreadStateAt(n + 1).getTimeStamp()) - this.viewStart) * f), n2);
        } else {
            n3 = ThreadStateColumnImpl.timeInervalToMilliSeconds(threadState.getMSASamplePeriod());
            n4 = Math.min((int)((float)(ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp()) + (long)n3 - this.viewStart) * f + 0.5f), n2);
        }
        n3 = this.getHeight() - 6;
        if (this.viewManager.isMSAMode()) {
            for (AtomicInteger atomicInteger : this.map.values()) {
                atomicInteger.set(0);
            }
            ThreadStateColumnImpl.fillMap(this.viewManager, threadState, this.map);
            ThreadStateColumnImpl.roundMap(this.map);
            int n6 = 0;
            int n7 = 50;
            int n8 = 0;
            OrderedEnumStateIterator orderedEnumStateIterator = new OrderedEnumStateIterator(this.map);
            while (orderedEnumStateIterator.hasNext()) {
                Object object = orderedEnumStateIterator.next();
                int n9 = ((AtomicInteger)object.getValue()).get();
                Color color = ThreadStateColumnImpl.getThreadStateColor((ThreadState.MSAState)object.getKey());
                n8 = n7;
                n7 = (n9 * n3 + n8) % 100;
                int n10 = (n9 * n3 + n8) / 100;
                n6 += n10;
                if (n10 <= 0) continue;
                graphics.setColor(color);
                graphics.fillRect(n5, 3 + n3 - n6, n4 - n5, n10);
            }
        } else {
            Color color = ThreadStateColumnImpl.getThreadStateColor(threadState.getMSAState(threadState.getSamplingStateIndex(this.viewManager.isFullMode()), this.viewManager.isFullMode()));
            graphics.setColor(color);
            graphics.fillRect(n5, 3, n4 - n5, n3);
        }
    }

    private void paintGray(Graphics graphics) {
        if (this.viewEnd - this.viewStart > 0L) {
            int n = this.getWidth();
            float f = (float)n / (float)(this.viewEnd - this.viewStart);
            long l = this.viewStart - this.dataStart;
            int n2 = 0;
            for (Range<Long> range : this.getGray()) {
                graphics.setColor(UIUtils.getDarker(this.getBackground(), this.BorderDarkerFactor));
                int n3 = (int)((float)((long)ThreadStateColumnImpl.timeInervalToMilliSeconds((Long)range.getStart()) - l) * f);
                int n4 = (int)((float)((long)ThreadStateColumnImpl.timeInervalToMilliSeconds((Long)range.getEnd()) - l) * f);
                Composite composite = ((Graphics2D)graphics).getComposite();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, this.AlphaCompositeConstant));
                graphics.fillRect(n3, 0, n4, this.getHeight() - 1);
                ((Graphics2D)graphics).setComposite(composite);
                graphics.setColor(this.TIME_SELECTION_BORDER);
                if (n3 > 0) {
                    graphics.drawLine(n3, 0, n3, this.getHeight() - 1);
                }
                if (n4 < n) {
                    graphics.drawLine(n4, 0, n4, this.getHeight() - 1);
                }
                ++n2;
            }
        }
    }

    private void paintTimeMarks(Graphics graphics) {
        if (this.viewEnd - this.viewStart > 0L) {
            int n = (int)(this.viewStart - this.dataStart);
            int n2 = (int)(this.viewEnd - this.dataStart);
            float f = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int n3 = TimeLineUtils.getOptimalUnits(f);
            int n4 = Math.max((int)(Math.ceil((double)n / (double)n3) * (double)n3), 0);
            for (int i = n4 - n3; i <= n2 + n3; i += n3) {
                if (i < 0) continue;
                float f2 = i - n;
                int n5 = (int)(f2 * f);
                this.paintTimeTicks(graphics, (int)(f2 * f), (int)((f2 + (float)n3) * f), TimeLineUtils.getTicksCount(n3));
                graphics.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                graphics.drawLine(n5, 0, n5, this.getHeight() - 1);
            }
        }
    }

    private void paintTimeLine(Graphics graphics) {
        long l;
        if (this.viewEnd - this.viewStart > 0L && this.timeLine != null && this.viewStart < (l = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && l < this.viewEnd) {
            int n = (int)((long)this.getWidth() * (l - this.viewStart) / (this.viewEnd - this.viewStart));
            graphics.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
            graphics.drawLine(n, 0, n, this.getHeight() - 1);
        }
    }

    private void paintTimeTicks(Graphics graphics, int n, int n2, int n3) {
        float f = (float)(n2 - n) / (float)n3;
        graphics.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
        for (int i = 1; i < n3; ++i) {
            int n4 = n + (int)((float)i * f);
            graphics.drawLine(n4, 0, n4, this.getHeight() - 1);
        }
    }
}

