/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.CallStackTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.CustomTimeLineViewport;
import org.netbeans.modules.dlight.visualizers.threadmap.DataManagerListener;
import org.netbeans.modules.dlight.visualizers.threadmap.JExtendedTable;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadNameCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadNameHeaderRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackActionsProvider;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateHeaderRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateIcon;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsDataManager;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadsPanel
extends JPanel
implements AdjustmentListener,
ActionListener,
TableColumnModelListener,
DataManagerListener,
ThreadStackActionsProvider {
    private static final String QUERY_STATE_ACTION_COMMAND = "query_state";
    private static final ResourceBundle messages = NbBundle.getBundle(ThreadsPanel.class);
    private static final String VIEW_THREADS_ALL = messages.getString("ThreadsPanel_ViewThreadsAll");
    private static final String VIEW_THREADS_LIVE = messages.getString("ThreadsPanel_ViewThreadsLive");
    private static final String VIEW_THREADS_FINISHED = messages.getString("ThreadsPanel_ViewThreadsFinished");
    private static final String VIEW_THREADS_SELECTION = messages.getString("ThreadsPanel_ViewThreadsSelection");
    private static final String THREADS_TABLE = messages.getString("ThreadsPanel_ThreadsTable");
    private static final String ENABLE_THREADS_PROFILING = messages.getString("ThreadsPanel_EnableThreadsProfiling");
    private static final String ZOOM_IN_TOOLTIP = messages.getString("ThreadsPanel_ZoomInToolTip");
    private static final String ZOOM_OUT_TOOLTIP = messages.getString("ThreadsPanel_ZoomOutToolTip");
    private static final String FIXED_SCALE_TOOLTIP = messages.getString("ThreadsPanel_FixedScaleToolTip");
    private static final String SCALE_TO_FIT_TOOLTIP = messages.getString("ThreadsPanel_ScaleToFitToolTip");
    private static final String THREADS_COLUMN_NAME = messages.getString("ThreadsPanel_ThreadsColumnName");
    private static final String TIMELINE_COLUMN_NAME = messages.getString("ThreadsPanel_TimelineColumnName");
    private static final String SUMMARY_COLUMN_NAME = messages.getString("ThreadsPanel_SummaryColumnName");
    private static final String SELECTED_THREADS_ITEM = messages.getString("ThreadsPanel_SelectedThreadsItem");
    private static final String SHOW_LEGEND = messages.getString("ThreadsPanel_ShowLegend");
    private static final String HIDE_LEGEND = messages.getString("ThreadsPanel_HideLegend");
    private static final String SELECT_THREAD_NAME = messages.getString("ThreadsPanel_SelectThreadName");
    static final String THREAD_NAME_ID = messages.getString("ThreadsPanel_ThreadNameId");
    static final String THREAD_NAME_CALLEE = messages.getString("ThreadsPanel_ThreadNameCallee");
    static final String THREAD_NAME_CALLEE_CALLEE = messages.getString("ThreadsPanel_ThreadNameCalleeCallee");
    static final String THREAD_NAME_FORMAT_TOOL_TIP = messages.getString("ThreadsPanel_ChangeThreadNameFormatToolTip");
    private static final String NAVIGATE = messages.getString("ThreadsPanel_Navigate");
    private static final String NAVIGATE_CARET_LEFT = messages.getString("ThreadsPanel_NavigateCaretLeft");
    private static final String NAVIGATE_CARET_RIGHT = messages.getString("ThreadsPanel_NavigateCaretRight");
    private static final String NAVIGATE_SET_CARET = messages.getString("ThreadsPanel_NavigateSetCaret");
    private static final String NAVIGATE_STACK_VIEW = messages.getString("ThreadsPanel_NavigateStackView");
    private static final String CLOSE_LEGEND_TOOLTIP = messages.getString("ThreadsPanel_CloseLegendToolTip");
    private static final String TABLE_ACCESS_NAME = messages.getString("ThreadsPanel_TableAccessName");
    private static final String TABLE_ACCESS_DESCR = messages.getString("ThreadsPanel_TableAccessDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ComboAccessDescr");
    private static final String VIEW_MODE_SIMPLE = messages.getString("ThreadsPanel_SimpleViewMode");
    private static final String VIEW_MODE_MSA = messages.getString("ThreadsPanel_SimpleMSAViewMode");
    private static final String VIEW_MODE_MSA_FULL = messages.getString("ThreadsPanel_FulleMSAViewMode");
    private static final String VIEW_MODE_COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ViewModeComboAccessName");
    private static final String VIEW_MODE_COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ViewModeComboAccessDescr");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");
    private static final String VIEW_MODE_LABEL_TEXT = messages.getString("ThreadsPanel_ViewModeLabelText");
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int DISPLAY_COLUMN_INDEX = 1;
    private static final int SUMMARY_COLUMN_INDEX = 2;
    private static final int RIGHT_DISPLAY_MARGIN = 20;
    private static final int LEFT_DISPLAY_MARGIN = 20;
    private static final int NAME_COLUMN_WIDTH = 100;
    private static final int MIN_NAME_COLUMN_WIDTH = 55;
    static final int MIN_SUMMARY_COLUMN_WIDTH = 72;
    static final int TABLE_ROW_HEIGHT = 18;
    static final int THREAD_LINE_TOP_BOTTOM_MARGIN = 3;
    private ArrayList<Integer> filteredDataToDataIndex = new ArrayList();
    private CustomTimeLineViewport viewPort;
    private DefaultComboBoxModel comboModel;
    private DefaultComboBoxModel viewModeComboModel;
    private DefaultComboBoxModel comboModelWithSelection;
    private JButton scaleToFitButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JComboBox threadsSelectionCombo;
    private JComboBox viewModeSelectionCombo;
    private JPanel legendPanel;
    private JMenuItem showOnlySelectedThreads;
    private JMenuItem showLegend;
    private JMenuItem hideLegend;
    private JMenu selectThreadName;
    private JRadioButtonMenuItem idThreadName;
    private JRadioButtonMenuItem calleeThreadName;
    private JRadioButtonMenuItem calleeCalleeThreadName;
    private JPanel contentPanel;
    private JPanel notificationPanel;
    private JPopupMenu popupMenu;
    private JScrollBar scrollBar;
    private JScrollPane tableScroll;
    private JTable table;
    private JToolBar buttonsToolBar;
    private ThreadsDataManager manager;
    private ThreadsDetailsCallback detailsCallback;
    private Collection<TimeIntervalDataFilter> timeFilters;
    private boolean internalChange = false;
    private boolean internalScrollbarChange = false;
    private boolean scaleToFit = false;
    private boolean threadsMonitoringEnabled = false;
    private boolean trackingEnd = true;
    private float zoomResolutionPerPixel = 50.0f;
    private long viewEnd;
    private long viewStart = -1L;
    private int sortedColum = -1;
    private int sortedOrder = 0;
    private TimeLine timeLine;
    private String selectedViewMode = VIEW_MODE_SIMPLE;
    private final List<String> fullMSAModeValues = Arrays.asList(VIEW_MODE_MSA_FULL);
    private final List<String> msaModeValues = Arrays.asList(VIEW_MODE_MSA, VIEW_MODE_MSA_FULL);
    private boolean isShowLegend = true;
    private RequestProcessor.Task showStackTask = null;

    public ThreadsPanel(ThreadsDataManager threadsDataManager, ThreadsDetailsCallback threadsDetailsCallback) {
        this.manager = threadsDataManager;
        this.detailsCallback = threadsDetailsCallback;
        this.contentPanel = new JPanel(new CardLayout());
        this.table = this.createViewTable();
        this.table.setGridColor(UIUtils.TABLE_VERTICAL_GRID_COLOR);
        this.table.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.table.getAccessibleContext().setAccessibleDescription(TABLE_ACCESS_DESCR);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.table.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.performDefaultAction();
            }
        });
        this.scrollBar = new ThreadsScrollBar();
        this.zoomInButton = new JButton(new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoomIn.png")));
        this.zoomOutButton = new JButton(new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoomOut.png")));
        this.scaleToFitButton = new JButton(new ImageIcon(this.getClass().getResource(this.scaleToFit ? "/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoom.png" : "/org/netbeans/modules/dlight/visualizers/threadmap/resources/scaleToFit.png")));
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED});
        this.comboModelWithSelection = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED, VIEW_THREADS_SELECTION});
        this.threadsSelectionCombo = new JComboBox(this.comboModel){

            public Dimension getMaximumSize() {
                return new Dimension(120, this.getPreferredSize().height);
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)SHOW_LABEL_TEXT);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jLabel.setLabelFor(this.threadsSelectionCombo);
        this.viewModeComboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_MODE_SIMPLE, VIEW_MODE_MSA, VIEW_MODE_MSA_FULL});
        this.viewModeSelectionCombo = new JComboBox(this.viewModeComboModel){

            public Dimension getMaximumSize() {
                return new Dimension(120, this.getPreferredSize().height);
            }
        };
        this.viewModeSelectionCombo.getAccessibleContext().setAccessibleName(VIEW_MODE_COMBO_ACCESS_NAME);
        this.viewModeSelectionCombo.getAccessibleContext().setAccessibleDescription(VIEW_MODE_COMBO_ACCESS_DESCR);
        JLabel jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)VIEW_MODE_LABEL_TEXT);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jLabel2.setLabelFor(this.viewModeSelectionCombo);
        this.buttonsToolBar = new JToolBar(0){

            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)component);
                }
                return super.add(component);
            }
        };
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.zoomInButton.setEnabled(!this.scaleToFit);
        this.zoomOutButton.setEnabled(!this.scaleToFit);
        this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
        this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
        this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        this.zoomInButton.getAccessibleContext().setAccessibleName(this.zoomInButton.getToolTipText());
        this.zoomOutButton.getAccessibleContext().setAccessibleName(this.zoomOutButton.getToolTipText());
        this.scaleToFitButton.getAccessibleContext().setAccessibleName(this.scaleToFitButton.getToolTipText());
        this.table.setSelectionMode(2);
        this.table.setSelectionBackground(UIUtils.TABLE_SELECTION_BACKGROUND_COLOR);
        this.table.setSelectionForeground(UIUtils.TABLE_SELECTION_FOREGROUND_COLOR);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setRowHeight(18);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setBackground(Color.WHITE);
                component.setFont(jTable.getFont().deriveFont(1));
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(new EmptyBorder(0, 3, 0, 3));
                    if (component instanceof JLabel) {
                        if (n2 == ThreadsPanel.this.sortedColum && ThreadsPanel.this.sortedOrder != 0) {
                            ((JLabel)component).setIcon(this.getProperIcon(ThreadsPanel.this.sortedOrder == -1));
                        } else {
                            ((JLabel)component).setIcon(null);
                        }
                    }
                }
                return component;
            }

            private ImageIcon getProperIcon(boolean bl) {
                if (bl) {
                    return new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/columnsSortedDesc.png"));
                }
                return new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/columnsSortedAsc.png"));
            }
        };
        this.table.getTableHeader().setDefaultRenderer(defaultTableCellRenderer);
        this.table.getTableHeader().setReorderingAllowed(false);
        ThreadNameHeaderRenderer threadNameHeaderRenderer = new ThreadNameHeaderRenderer(this);
        threadNameHeaderRenderer.setBackground(Color.WHITE);
        this.table.setAutoResizeMode(1);
        this.table.getColumnModel().getColumn(0).setHeaderRenderer(threadNameHeaderRenderer);
        this.table.getColumnModel().getColumn(0).setMinWidth(55);
        this.table.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        ThreadStateHeaderRenderer threadStateHeaderRenderer = new ThreadStateHeaderRenderer(this);
        threadStateHeaderRenderer.setBackground(Color.WHITE);
        this.table.getColumnModel().getColumn(1).setHeaderRenderer(threadStateHeaderRenderer);
        this.table.getColumnModel().getColumn(2).setMinWidth(72);
        this.table.getColumnModel().getColumn(2).setMaxWidth(72);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(72);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.setColumnSelectionAllowed(false);
        tableColumnModel.setColumnMargin(0);
        this.table.setDefaultRenderer(ThreadNameCellRenderer.class, new ThreadNameCellRenderer(this));
        this.table.setDefaultRenderer(ThreadStateCellRenderer.class, new ThreadStateCellRenderer(this));
        this.table.setDefaultRenderer(ThreadSummaryCellRenderer.class, new ThreadSummaryCellRenderer(this));
        this.buttonsToolBar.setFloatable(false);
        this.buttonsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        this.buttonsToolBar.add(this.zoomInButton);
        this.buttonsToolBar.add(this.zoomOutButton);
        this.buttonsToolBar.add(this.scaleToFitButton);
        this.buttonsToolBar.addSeparator();
        this.buttonsToolBar.add(jLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        this.buttonsToolBar.add(jLabel2);
        this.buttonsToolBar.add(this.viewModeSelectionCombo);
        jPanel2.add((Component)this.scrollBar, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.WHITE);
        jPanel3.setPreferredSize(new Dimension(72, 0));
        jPanel2.add((Component)jPanel3, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBackground(Color.WHITE);
        jPanel2.add((Component)jPanel4, "Center");
        jPanel4.add((Component)this.scrollBar, "East");
        this.legendPanel = new JPanel();
        this.legendPanel.setLayout(new BorderLayout());
        this.legendPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initLegend(this.isFullMode());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel5.add((Component)this.legendPanel, "East");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createBevelBorder(1));
        this.tableScroll = new JScrollPane();
        this.tableScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tableScroll.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.tableScroll.getCorner("UPPER_RIGHT_CORNER").setBackground(Color.WHITE);
        this.viewPort = new CustomTimeLineViewport(this);
        this.viewPort.setView(this.table);
        this.viewPort.setBackground(this.table.getBackground());
        this.tableScroll.setViewport(this.viewPort);
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.tableScroll.setVerticalScrollBarPolicy(20);
        jPanel6.add((Component)this.tableScroll, "Center");
        jPanel6.add((Component)jPanel2, "South");
        jPanel.add((Component)jPanel6, "Center");
        jPanel.add((Component)jPanel5, "South");
        this.notificationPanel = new JPanel(new FlowLayout(3, 0, 15));
        this.notificationPanel.setBorder(jPanel6.getBorder());
        this.notificationPanel.setBackground(this.table.getBackground());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.notificationPanel, ENABLE_THREADS_PROFILING);
        this.contentPanel.add((Component)jPanel, THREADS_TABLE);
        this.add((Component)this.buttonsToolBar, "North");
        this.add((Component)this.contentPanel, "Center");
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                if (mouseWheelEvent.getScrollType() == 0 && (n = mouseWheelEvent.getUnitsToScroll()) != 0) {
                    int n2 = n < 0 ? -1 : 1;
                    int n3 = ThreadsPanel.this.scrollBar.getUnitIncrement(n2);
                    int n4 = ThreadsPanel.this.scrollBar.getValue();
                    int n5 = n4 + n3 * n;
                    if (n4 != (n5 = Math.max(Math.min(n5, ThreadsPanel.this.scrollBar.getMaximum() - ThreadsPanel.this.scrollBar.getVisibleAmount()), ThreadsPanel.this.scrollBar.getMinimum()))) {
                        ThreadsPanel.this.scrollBar.setValue(n5);
                    }
                }
            }
        });
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.scaleToFitButton.addActionListener(this);
        this.threadsSelectionCombo.addActionListener(this);
        this.viewModeSelectionCombo.addActionListener(this);
        this.viewModeSelectionCombo.setSelectedIndex(Math.min(NbPreferences.forModule(this.getClass()).getInt("ViewMode", 0), this.viewModeComboModel.getSize() - 1));
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ThreadsPanel.this.refreshViewData();
                ThreadsPanel.this.updateScrollbar();
                ThreadsPanel.this.updateZoomButtonsEnabledState();
                ThreadsPanel.this.revalidate();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ThreadsPanel.this.table.getSelectedRow()) != -1) {
                    Rectangle rectangle = ThreadsPanel.this.table.getCellRect(n, 0, false);
                    ThreadsPanel.this.showLegend.setVisible(!ThreadsPanel.this.isShowLegend);
                    ThreadsPanel.this.hideLegend.setVisible(ThreadsPanel.this.isShowLegend);
                    ThreadsPanel.this.popupMenu.show(keyEvent.getComponent(), rectangle.x + ((ThreadsPanel)ThreadsPanel.this).table.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if ((mouseEvent.getModifiers() & 4) != 0 && (n = ThreadsPanel.this.table.rowAtPoint(mouseEvent.getPoint())) != -1 && !ThreadsPanel.this.table.isRowSelected(n)) {
                    if (mouseEvent.isControlDown()) {
                        ThreadsPanel.this.table.addRowSelectionInterval(n, n);
                    } else {
                        ThreadsPanel.this.table.setRowSelectionInterval(n, n);
                    }
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ThreadsPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        ThreadsPanel.this.showLegend.setVisible(!ThreadsPanel.this.isShowLegend);
                        ThreadsPanel.this.hideLegend.setVisible(ThreadsPanel.this.isShowLegend);
                        ThreadsPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getModifiers() == 16) {
                        if (mouseEvent.getClickCount() == 1) {
                            ThreadsPanel.this.onClickAction(mouseEvent);
                        } else if (mouseEvent.getClickCount() == 2) {
                            ThreadsPanel.this.performDefaultAction();
                        }
                    }
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = ThreadsPanel.this.table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = ThreadsPanel.this.table.convertColumnIndexToModel(n);
                if (mouseEvent.getModifiers() == 16) {
                    ThreadNameHeaderRenderer threadNameHeaderRenderer;
                    Rectangle rectangle;
                    if (n2 == 0 && (rectangle = (threadNameHeaderRenderer = (ThreadNameHeaderRenderer)ThreadsPanel.this.table.getColumnModel().getColumn(0).getHeaderRenderer()).getFormatRectangle()) != null && rectangle.getX() <= (double)mouseEvent.getX() && (double)mouseEvent.getX() <= rectangle.getX() + rectangle.getWidth()) {
                        ThreadsPanel.this.setThreadNameFormat(ThreadsPanel.this.getThreadNameFormat() + 1);
                        return;
                    }
                    if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                        ThreadsPanel.this.sortByColumn(n2);
                    }
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && ThreadsPanel.this.isShowing()) {
                    ThreadsPanel.this.dataChanged();
                }
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.table.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.table.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.table.setFocusTraversalKeys(1, hashSet);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(49, 8, true), "ascSortFor1");
        this.table.getActionMap().put("ascSortFor1", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.sortByColumn(0);
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(51, 8, true), "ascSortFor3");
        this.table.getActionMap().put("ascSortFor3", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.sortByColumn(2);
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(37, 2, true), "leftTimeLine");
        AbstractAction abstractAction = new AbstractAction(NAVIGATE_CARET_LEFT){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.shiftTimeLine(-1);
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 2, true));
        this.table.getActionMap().put("leftTimeLine", abstractAction);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(39, 2, true), "rightTimeLine");
        abstractAction = new AbstractAction(NAVIGATE_CARET_RIGHT){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.shiftTimeLine(1);
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 2, true));
        this.table.getActionMap().put("rightTimeLine", abstractAction);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(40, 2, true), "newTimeLine");
        abstractAction = new AbstractAction(NAVIGATE_SET_CARET){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.shiftTimeLine(0);
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 2, true));
        this.table.getActionMap().put("newTimeLine", abstractAction);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(40, 8, true), "focuseStack");
        abstractAction = new AbstractAction(NAVIGATE_STACK_VIEW){

            public void actionPerformed(ActionEvent actionEvent) {
                CallStackTopComponent.getDefault().requestFocus(false);
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 8, true));
        this.table.getActionMap().put("focuseStack", abstractAction);
        this.scrollBar.setFocusable(true);
        this.popupMenu = this.initPopupMenu();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        threadsDataManager.addDataListener(this);
    }

    private void initLegend(boolean bl) {
        this.legendPanel.removeAll();
        if (!this.isShowLegend) {
            return;
        }
        JButton jButton = new JButton((Icon)new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/win_close_enabled.png"))){

            public Dimension getPreferredSize() {
                return new Dimension(12, 12);
            }
        };
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsPanel.this.isShowLegend = false;
                ThreadsPanel.this.initLegend(ThreadsPanel.this.isFullMode());
                ThreadsPanel.this.refreshUI();
                ThreadsPanel.this.viewPort.repaint();
            }
        });
        jButton.setToolTipText(CLOSE_LEGEND_TOOLTIP);
        this.legendPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 6, 0, 0), 0, 0);
        this.legendPanel.add((Component)jButton, gridBagConstraints);
        if (!bl) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.Running, ThreadStateResources.THREAD_RUNNING));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.Blocked, ThreadStateResources.THREAD_BLOCKED));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.Waiting, ThreadStateResources.THREAD_WAITING));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.Sleeping, ThreadStateResources.THREAD_SLEEPING));
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.legendPanel.add((Component)jPanel, gridBagConstraints);
        } else {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.RunningUser, ThreadStateResources.THREAD_RUNNING_USER));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.RunningSystemCall, ThreadStateResources.THREAD_RUNNING_SYSTEM));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.RunningOther, ThreadStateResources.THREAD_RUNNING_OTHER));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.WaitingCPU, ThreadStateResources.THREAD_WAITING_CPU));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.SleepingUserLock, ThreadStateResources.THREAD_SLEEP_USE_LOCK));
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.legendPanel.add((Component)jPanel, gridBagConstraints);
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.ThreadStopped, ThreadStateResources.THREAD_THREAD_STOPPED));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.SleepingOther, ThreadStateResources.THREAD_SLEEPING_OTHER));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.SleepingUserDataPageFault, ThreadStateResources.THREAD_SLEEPING_USER_DATA_PAGE_FAULT));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.SleepingUserTextPageFault, ThreadStateResources.THREAD_SLEEPING_USER_TEXT_PAGE_FAULT));
            jPanel.add(this.createLegendLabel(ThreadState.MSAState.SleepingKernelPageFault, ThreadStateResources.THREAD_SLEEPING_KERNEL_PAGE_FAULT));
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.legendPanel.add((Component)jPanel, gridBagConstraints);
        }
    }

    private JLabel createLegendLabel(ThreadState.MSAState mSAState, ThreadStateResources threadStateResources) {
        ThreadStateIcon threadStateIcon = new ThreadStateIcon(mSAState, 10, 10);
        JLabel jLabel = new JLabel(threadStateResources.name, threadStateIcon, 10);
        jLabel.setToolTipText(threadStateResources.tooltip);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return jLabel;
    }

    private void sortByColumn(int n) {
        if (n == 0 || n == 2) {
            if (this.sortedColum == n) {
                if (this.sortedOrder == 1) {
                    this.sortedOrder = -1;
                } else if (this.sortedOrder == -1) {
                    this.sortedOrder = 0;
                } else if (this.sortedOrder == 0) {
                    this.sortedOrder = 1;
                }
            } else {
                this.sortedColum = n;
                this.sortedOrder = 1;
            }
        }
        this.refreshUI();
    }

    private void shiftTimeLine(int n) {
        long l;
        long l2;
        Object object;
        int n2;
        long l3;
        int n3 = this.table.getSelectedRow();
        if (n3 < 0) {
            return;
        }
        int n4 = this.filteredDataToDataIndex.get(n3);
        ThreadStateColumnImpl threadStateColumnImpl = null;
        ThreadState threadState = null;
        if (this.timeLine == null || n == 0) {
            l3 = (this.getViewStart() + this.getViewEnd()) / 2L;
            if (l3 == 0L) {
                return;
            }
            threadStateColumnImpl = this.manager.getThreadData(n4);
            for (n2 = 0; n2 < threadStateColumnImpl.size(); ++n2) {
                object = threadStateColumnImpl.getThreadStateAt(n2);
                if (threadState == null) {
                    threadState = object;
                }
                l2 = ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp());
                l = ThreadStateColumnImpl.timeStampToMilliSeconds(object.getTimeStamp());
                if (Math.abs(l3 - l2) <= Math.abs(l3 - l)) continue;
                threadState = object;
            }
            if (threadState == null) {
                return;
            }
            this.timeLine = new TimeLine(threadState.getTimeStamp(), this.manager.getStartTime(), (int)threadState.getMSASamplePeriod());
        } else {
            l3 = this.timeLine.getTimeStamp();
            if (n < 0) {
                l3 -= (long)this.timeLine.getInterval();
            } else if (n > 0) {
                l3 += (long)this.timeLine.getInterval();
            }
            threadStateColumnImpl = this.manager.getThreadData(n4);
            for (n2 = 0; n2 < threadStateColumnImpl.size(); ++n2) {
                object = threadStateColumnImpl.getThreadStateAt(n2);
                if (threadState == null) {
                    threadState = object;
                }
                l2 = ThreadStateColumnImpl.timeStampToMilliSeconds(threadState.getTimeStamp());
                l = ThreadStateColumnImpl.timeStampToMilliSeconds(object.getTimeStamp());
                if (Math.abs(l3 - l2) <= Math.abs(l3 - l)) continue;
                threadState = object;
            }
            if (threadState == null) {
                return;
            }
            this.timeLine = new TimeLine(threadState.getTimeStamp(), this.manager.getStartTime(), (int)threadState.getMSASamplePeriod());
        }
        ThreadState.MSAState mSAState = null;
        EnumMap<ThreadState.MSAState, AtomicInteger> enumMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        ThreadStateColumnImpl.fillMap(this, threadState, enumMap);
        ThreadStateColumnImpl.roundMap(enumMap);
        n2 = 0;
        object = new OrderedEnumStateIterator(enumMap);
        while (((OrderedEnumStateIterator)object).hasNext()) {
            Object object2 = ((OrderedEnumStateIterator)object).next();
            ThreadState.MSAState mSAState2 = (ThreadState.MSAState)object2.getKey();
            if (mSAState == null) {
                mSAState = mSAState2;
                n2 = ((AtomicInteger)object2.getValue()).intValue();
            }
            if (n2 >= ((AtomicInteger)object2.getValue()).intValue()) continue;
            mSAState = mSAState2;
            n2 = ((AtomicInteger)object2.getValue()).intValue();
        }
        threadState.getMSAState(n3, this.isFullMode());
        this.showStacksAtTimeLine(threadStateColumnImpl, threadState, mSAState);
    }

    public long getDataEnd() {
        return this.manager.getEndTime();
    }

    public long getDataStart() {
        return this.manager.getStartTime();
    }

    public int getDisplayColumnWidth() {
        return this.table.getTableHeader().getHeaderRect((int)1).width;
    }

    public int getDisplayColumnRest() {
        return this.table.getTableHeader().getHeaderRect((int)2).width;
    }

    public ThreadStateColumnImpl getThreadData(int n) {
        return this.manager.getThreadData(n);
    }

    public ThreadSummaryColumnImpl getThreadSummary(int n) {
        return this.manager.getThreadSummary(n);
    }

    public int getSortedColumn() {
        return this.sortedColum;
    }

    public int getSortedOrder() {
        return this.sortedOrder;
    }

    public String getThreadName(int n) {
        return this.manager.getThreadName(n);
    }

    public long getViewEnd() {
        return this.viewEnd;
    }

    public long getViewStart() {
        return this.viewStart;
    }

    public TimeLine getTimeLine() {
        return this.timeLine;
    }

    private void queryChanged(final ThreadDumpQuery threadDumpQuery, final ThreadState threadState) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ThreadsPanel.this.detailsCallback.showStack(threadState.getTimeStamp(), threadDumpQuery);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem;
        Object object;
        if (this.internalChange) {
            return;
        }
        if (actionEvent.getSource() == this.scaleToFitButton) {
            if (!this.scaleToFit) {
                this.scrollBar.setVisible(true);
                this.scaleToFitButton.setIcon(new ImageIcon(ThreadsPanel.class.getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/zoom.png")));
                this.scaleToFit = true;
            } else {
                this.scaleToFit = false;
                this.scaleToFitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/dlight/visualizers/threadmap/resources/scaleToFit.png")));
                this.scrollBar.setVisible(false);
                this.scrollBar.setValues(0, 0, 0, 0);
            }
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.zoomInButton) {
            this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
            this.zoomResolutionPerPixel /= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.zoomOutButton) {
            this.zoomResolutionPerPixel *= 2.0f;
            this.refreshViewData();
            this.updateScrollbar();
            this.updateZoomButtonsEnabledState();
            this.table.getTableHeader().repaint();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.threadsSelectionCombo) {
            if (this.threadsSelectionCombo.getModel() == this.comboModelWithSelection && this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
                this.internalChange = true;
                Object object2 = this.threadsSelectionCombo.getSelectedItem();
                this.threadsSelectionCombo.setModel(this.comboModel);
                this.threadsSelectionCombo.setSelectedItem(object2);
                this.internalChange = false;
            }
            this.table.clearSelection();
            this.dataChanged();
        } else if (actionEvent.getSource() == this.showOnlySelectedThreads) {
            for (int i = this.filteredDataToDataIndex.size() - 1; i >= 0; --i) {
                if (this.table.isRowSelected(i)) continue;
                this.filteredDataToDataIndex.remove(i);
            }
            this.threadsSelectionCombo.setModel(this.comboModelWithSelection);
            this.threadsSelectionCombo.setSelectedItem(VIEW_THREADS_SELECTION);
            this.table.clearSelection();
        } else if (actionEvent.getSource() == this.showLegend) {
            this.isShowLegend = true;
            this.initLegend(this.isFullMode());
            this.refreshUI();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.hideLegend) {
            this.isShowLegend = false;
            this.initLegend(this.isFullMode());
            this.refreshUI();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.viewModeSelectionCombo) {
            this.selectedViewMode = this.viewModeSelectionCombo.getSelectedItem() + "";
            NbPreferences.forModule(this.getClass()).putInt("ViewMode", this.viewModeSelectionCombo.getSelectedIndex());
            this.initLegend(this.isFullMode());
            this.refreshUI();
            this.viewPort.repaint();
        } else if (actionEvent.getSource() == this.idThreadName) {
            this.setThreadNameFormat(0);
        } else if (actionEvent.getSource() == this.calleeThreadName) {
            this.setThreadNameFormat(1);
        } else if (actionEvent.getSource() == this.calleeCalleeThreadName) {
            this.setThreadNameFormat(2);
        } else if (actionEvent.getSource() instanceof JMenuItem && (object = (jMenuItem = (JMenuItem)actionEvent.getSource()).getClientProperty("query")) instanceof ThreadDumpQuery) {
            ThreadDumpQuery threadDumpQuery = (ThreadDumpQuery)object;
            ThreadState threadState = (ThreadState)jMenuItem.getClientProperty("state");
            this.queryChanged(threadDumpQuery, threadState);
        }
    }

    public int getThreadNameFormat() {
        return this.manager.getThreadNameFormat();
    }

    public void setThreadNameFormat(int n) {
        switch (n) {
            case 1: {
                NbPreferences.forModule(this.getClass()).putInt("ThreadName", 1);
                this.manager.setThreadNameFormat(1, false);
                this.idThreadName.setSelected(false);
                this.calleeThreadName.setSelected(true);
                this.calleeCalleeThreadName.setSelected(false);
                break;
            }
            case 2: {
                NbPreferences.forModule(this.getClass()).putInt("ThreadName", 2);
                this.manager.setThreadNameFormat(2, false);
                this.idThreadName.setSelected(false);
                this.calleeThreadName.setSelected(false);
                this.calleeCalleeThreadName.setSelected(true);
                break;
            }
            default: {
                NbPreferences.forModule(this.getClass()).putInt("ThreadName", 0);
                this.manager.setThreadNameFormat(0, false);
                this.idThreadName.setSelected(true);
                this.calleeThreadName.setSelected(false);
                this.calleeCalleeThreadName.setSelected(false);
            }
        }
    }

    boolean isFullMode() {
        return this.fullMSAModeValues.contains(this.selectedViewMode);
    }

    boolean isMSAMode() {
        return this.msaModeValues.contains(this.selectedViewMode);
    }

    public void addSaveViewAction(AbstractAction abstractAction) {
        JButton jButton = this.buttonsToolBar.add(abstractAction);
        this.buttonsToolBar.remove(jButton);
        this.buttonsToolBar.add((Component)jButton, 0);
        this.buttonsToolBar.add((Component)new JToolBar.Separator(), 1);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.internalScrollbarChange) {
            if (this.scrollBar.getValue() + this.scrollBar.getVisibleAmount() == this.scrollBar.getMaximum()) {
                this.trackingEnd = true;
            } else {
                this.trackingEnd = false;
                this.viewStart = this.manager.getStartTime() + (long)this.scrollBar.getValue();
                this.viewEnd = this.viewStart + (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
                this.repaint();
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        if (this.viewPort != null) {
            this.viewPort.repaint();
        }
        this.scrollBar.invalidate();
        this.revalidate();
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void dataChanged() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ThreadsPanel.this.refreshUI();
            }
        });
    }

    @Override
    public void dataReset() {
        this.filteredDataToDataIndex.clear();
        UIUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ThreadsPanel.this.refreshUI();
            }
        });
    }

    public boolean fitsVisibleArea() {
        return !this.tableScroll.getVerticalScrollBar().isVisible();
    }

    public boolean hasView() {
        return !this.notificationPanel.isShowing();
    }

    public void threadsMonitoringDisabled() {
        this.threadsMonitoringEnabled = false;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, ENABLE_THREADS_PROFILING);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(false);
    }

    public void threadsMonitoringEnabled() {
        this.threadsMonitoringEnabled = true;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, THREADS_TABLE);
        this.updateZoomButtonsEnabledState();
        this.threadsSelectionCombo.setEnabled(true);
    }

    private JTable createViewTable() {
        return new JExtendedTable(new ThreadsTableModel());
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showOnlySelectedThreads = new JMenuItem(SELECTED_THREADS_ITEM);
        this.showLegend = new JMenuItem(SHOW_LEGEND);
        this.hideLegend = new JMenuItem(HIDE_LEGEND);
        this.selectThreadName = new JMenu(SELECT_THREAD_NAME);
        this.idThreadName = new JRadioButtonMenuItem(THREAD_NAME_ID);
        this.calleeThreadName = new JRadioButtonMenuItem(THREAD_NAME_CALLEE);
        this.calleeCalleeThreadName = new JRadioButtonMenuItem(THREAD_NAME_CALLEE_CALLEE);
        this.selectThreadName.add(this.idThreadName);
        this.selectThreadName.add(this.calleeThreadName);
        this.selectThreadName.add(this.calleeCalleeThreadName);
        switch (NbPreferences.forModule(this.getClass()).getInt("ThreadName", 0)) {
            case 1: {
                this.calleeThreadName.setSelected(true);
                this.manager.setThreadNameFormat(1, true);
                break;
            }
            case 2: {
                this.calleeCalleeThreadName.setSelected(true);
                this.manager.setThreadNameFormat(2, true);
                break;
            }
            default: {
                this.idThreadName.setSelected(true);
                this.manager.setThreadNameFormat(0, true);
            }
        }
        jPopupMenu.add(this.showOnlySelectedThreads);
        jPopupMenu.add(this.showLegend);
        jPopupMenu.add(this.hideLegend);
        jPopupMenu.add(this.selectThreadName);
        JMenu jMenu = new JMenu(NAVIGATE);
        jMenu.add(this.table.getActionMap().get("leftTimeLine"));
        jMenu.add(this.table.getActionMap().get("rightTimeLine"));
        jMenu.add(this.table.getActionMap().get("newTimeLine"));
        jMenu.add(this.table.getActionMap().get("focuseStack"));
        jPopupMenu.add(jMenu);
        this.showOnlySelectedThreads.addActionListener(this);
        this.showLegend.addActionListener(this);
        this.hideLegend.addActionListener(this);
        this.idThreadName.addActionListener(this);
        this.calleeThreadName.addActionListener(this);
        this.calleeCalleeThreadName.addActionListener(this);
        return jPopupMenu;
    }

    private void performDefaultAction() {
    }

    @Override
    public Action[] getStackNodeActions(int n) {
        ArrayList<StackAction> arrayList = new ArrayList<StackAction>();
        LinkedHashMap<Integer, ThreadState> linkedHashMap = this.prepareAllStacks();
        if (linkedHashMap.size() == 0) {
            return new Action[0];
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Map.Entry<Integer, ThreadState> entry : linkedHashMap.entrySet()) {
            ThreadState threadState = entry.getValue();
            arrayList2.add(this.manager.getThreadData(entry.getKey()).getThreadID());
            if (n != this.manager.getThreadData(entry.getKey()).getThreadID()) continue;
            EnumMap<ThreadState.MSAState, AtomicInteger> enumMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
            ThreadStateColumnImpl.fillMap(this, threadState, enumMap);
            ThreadStateColumnImpl.roundMap(enumMap);
            OrderedEnumStateIterator orderedEnumStateIterator = new OrderedEnumStateIterator(enumMap);
            while (orderedEnumStateIterator.hasNext()) {
                Object object = orderedEnumStateIterator.next();
                ThreadState.MSAState mSAState = (ThreadState.MSAState)object.getKey();
                ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
                if (threadStateResources == null) continue;
                ThreadDumpQuery threadDumpQuery = new ThreadDumpQuery((long)this.manager.getThreadData(entry.getKey()).getThreadID(), threadState, arrayList2, mSAState, this.isMSAMode(), this.isFullMode(), this.manager.getStartTime());
                StackAction stackAction = new StackAction(threadState, mSAState, threadDumpQuery);
                arrayList.add(stackAction);
            }
        }
        return arrayList.toArray(new Action[0]);
    }

    private LinkedHashMap<Integer, ThreadState> prepareAllStacks() {
        LinkedHashMap<Integer, ThreadState> linkedHashMap = new LinkedHashMap<Integer, ThreadState>();
        if (this.timeLine != null) {
            long l = this.timeLine.getTimeStamp() + (long)this.timeLine.getInterval();
            for (Integer n : this.filteredDataToDataIndex) {
                ThreadStateColumnImpl threadStateColumnImpl = this.manager.getThreadData(n);
                ThreadState threadState = null;
                for (int i = 0; i < threadStateColumnImpl.size(); ++i) {
                    ThreadState threadState2 = threadStateColumnImpl.getThreadStateAt(i);
                    long l2 = ThreadStateColumnImpl.timeStampToMilliSeconds(threadState2.getTimeStamp());
                    if (i < threadStateColumnImpl.size() - 1) {
                        if (l2 > l || l > ThreadStateColumnImpl.timeStampToMilliSeconds(threadStateColumnImpl.getThreadStateAt(i + 1).getTimeStamp())) continue;
                        threadState = threadState2;
                        break;
                    }
                    if (l2 > l || l > l2 + (long)ThreadStateColumnImpl.timeInervalToMilliSeconds(threadState2.getMSASamplePeriod())) continue;
                    threadState = threadState2;
                    break;
                }
                if (threadState == null) continue;
                linkedHashMap.put(n, threadState);
            }
        }
        return linkedHashMap;
    }

    private void onClickAction(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0) {
            int n2 = this.filteredDataToDataIndex.get(n);
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n3 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n4 = this.table.convertColumnIndexToModel(n3);
            if (n4 == 1) {
                ThreadState.MSAState mSAState;
                ThreadStateColumnImpl threadStateColumnImpl = this.manager.getThreadData(n2);
                Rectangle rectangle = this.table.getCellRect(n, n3, false);
                Point point = new Point(mouseEvent.getPoint().x - rectangle.x, mouseEvent.getPoint().y - rectangle.y);
                int n5 = ThreadStateColumnImpl.point2index(this.manager, this, threadStateColumnImpl, point, rectangle.width);
                if (n5 >= 0 && (mSAState = ThreadStateColumnImpl.point2MSA(this, threadStateColumnImpl.getThreadStateAt(n5), point)) != null) {
                    ThreadState threadState = threadStateColumnImpl.getThreadStateAt(n5);
                    int n6 = (int)threadState.getMSASamplePeriod();
                    this.timeLine = new TimeLine(threadState.getTimeStamp(), this.manager.getStartTime(), n6);
                    this.showStacksAtTimeLine(threadStateColumnImpl, threadState, mSAState);
                }
            }
        }
    }

    private void showStacksAtTimeLine(final ThreadStateColumnImpl threadStateColumnImpl, final ThreadState threadState, final ThreadState.MSAState mSAState) {
        if (this.timeLine != null && (this.getViewStart() > this.timeLine.getTime() || this.timeLine.getTime() > this.getViewEnd()) && this.scrollBar.isVisible()) {
            int n = this.scrollBar.getValue();
            int n2 = (int)(this.timeLine.getTime() - (long)(this.scrollBar.getVisibleAmount() / 2));
            if (n != (n2 = Math.max(Math.min(n2, this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()), this.scrollBar.getMinimum()))) {
                this.scrollBar.setValue(n2);
            }
        }
        this.refreshUI();
        if (this.detailsCallback != null) {
            if (this.showStackTask != null) {
                this.showStackTask.cancel();
            }
            this.showStackTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LinkedHashMap linkedHashMap = ThreadsPanel.this.prepareAllStacks();
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            for (Map.Entry entry : linkedHashMap.entrySet()) {
                                arrayList.add(ThreadsPanel.this.manager.getThreadData((Integer)entry.getKey()).getThreadID());
                            }
                            ThreadDumpQuery threadDumpQuery = new ThreadDumpQuery((long)threadStateColumnImpl.getThreadID(), threadState, arrayList, mSAState, ThreadsPanel.this.isMSAMode(), ThreadsPanel.this.isFullMode(), ThreadsPanel.this.manager.getStartTime());
                            ThreadsPanel.this.detailsCallback.showStack(threadState.getTimeStamp(), threadDumpQuery);
                        }
                    });
                }
            }, 1000);
        }
    }

    private void refreshUI() {
        if (!this.isShowing()) {
            return;
        }
        this.updateFilteredData();
        this.refreshViewData();
        this.updateScrollbar();
        this.updateZoomButtonsEnabledState();
        this.table.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void refreshViewData() {
        if (this.scaleToFit) {
            long l = this.manager.getEndTime() - this.manager.getStartTime();
            int n = this.table.getTableHeader().getHeaderRect((int)1).width;
            float f = (float)l / (float)Math.max(n - 20 - 20, 1);
            this.viewStart = this.manager.getStartTime() - (long)(f * 20.0f);
            this.viewEnd = this.manager.getEndTime() + (long)(f * 20.0f);
        } else {
            long l = (long)(this.zoomResolutionPerPixel * 20.0f);
            long l2 = (long)(this.zoomResolutionPerPixel * 20.0f);
            long l3 = (long)(this.zoomResolutionPerPixel * (float)this.table.getTableHeader().getHeaderRect((int)1).width);
            if (this.viewStart == -1L) {
                this.viewStart = this.manager.getStartTime() - l2;
                this.viewEnd = this.viewStart + l3;
            }
            if (this.trackingEnd) {
                this.viewEnd = this.manager.getEndTime() + l;
                this.viewStart = this.viewEnd - l3;
                if (this.viewStart < this.manager.getStartTime() - l2) {
                    this.viewStart = this.manager.getStartTime() - l2;
                    this.viewEnd = this.viewStart + l3;
                }
            } else {
                long l4 = this.viewEnd - this.viewStart;
                if (l4 != 0L) {
                    long l5 = (this.viewEnd + this.viewStart) / 2L;
                    if (this.timeLine != null && this.viewStart < this.timeLine.getTime() + (long)(this.timeLine.getInterval() / 2) && this.timeLine.getTime() + (long)(this.timeLine.getInterval() / 2) < this.viewEnd) {
                        l5 = this.timeLine.getTime() + (long)(this.timeLine.getInterval() / 2);
                    }
                    this.viewStart = l5 - l3 * (l5 - this.viewStart) / l4;
                }
                if (this.viewStart < this.manager.getStartTime()) {
                    this.viewStart = this.manager.getStartTime() - l;
                }
                this.viewEnd = this.viewStart + l3;
            }
        }
    }

    private void updateFilteredData() {
        Object object;
        if (this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
            this.filteredDataToDataIndex.clear();
            for (int i = 0; i < this.manager.getThreadsCount(); ++i) {
                if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_ALL)) {
                    this.filteredDataToDataIndex.add(i);
                    continue;
                }
                if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_LIVE)) {
                    object = this.manager.getThreadData(i);
                    if (((ThreadStateColumnImpl)object).size() <= 0 || !((ThreadStateColumnImpl)object).isAlive()) continue;
                    this.filteredDataToDataIndex.add(i);
                    continue;
                }
                if (!this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_FINISHED)) continue;
                object = this.manager.getThreadData(i);
                if (((ThreadStateColumnImpl)object).size() > 0) {
                    if (((ThreadStateColumnImpl)object).isAlive()) continue;
                    this.filteredDataToDataIndex.add(i);
                    continue;
                }
                this.filteredDataToDataIndex.add(i);
            }
        }
        if ((this.sortedColum == 0 || this.sortedColum == 2) && this.sortedOrder != 0) {
            TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
            for (Integer object2 : this.filteredDataToDataIndex) {
                ThreadStateColumnImpl n = this.manager.getThreadData(object2);
                if (this.sortedColum == 0) {
                    treeMap.put(n.getName() + n.getThreadID(), object2);
                    continue;
                }
                long l = 0L;
                ThreadSummaryColumnImpl threadSummaryColumnImpl = this.manager.getThreadSummary(object2);
                if (threadSummaryColumnImpl != null) {
                    l = threadSummaryColumnImpl.getRunning();
                }
                l = (l << 32) + (long)n.getThreadID();
                treeMap.put(l, object2);
            }
            this.filteredDataToDataIndex.clear();
            if (this.sortedOrder == 1) {
                this.filteredDataToDataIndex.addAll(treeMap.values());
            } else {
                object = new LinkedList();
                Iterator iterator = treeMap.values().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    ((LinkedList)object).addFirst(n);
                }
                this.filteredDataToDataIndex.addAll((Collection<Integer>)object);
            }
        }
    }

    private void updateScrollbar() {
        this.internalScrollbarChange = true;
        if (this.scrollBar.isVisible() == this.scaleToFit) {
            this.scrollBar.setVisible(!this.scaleToFit);
        }
        if (!this.scaleToFit) {
            int n = (int)(this.zoomResolutionPerPixel * 20.0f);
            int n2 = (int)(this.zoomResolutionPerPixel * 20.0f);
            int n3 = (int)(this.viewStart - this.manager.getStartTime()) + n2;
            int n4 = (int)(this.viewEnd - this.viewStart);
            int n5 = (int)(this.manager.getEndTime() - this.manager.getStartTime()) + n;
            boolean bl = true;
            if (n3 == 0 && n5 - (n3 + n4) <= 0) {
                bl = false;
            }
            if (this.scrollBar.isVisible() != bl) {
                this.scrollBar.setVisible(bl);
            }
            if (bl) {
                this.scrollBar.setValues(n3, n4, -n2, n5);
                this.scrollBar.setBlockIncrement((int)((float)n4 * 0.95f));
                this.scrollBar.setUnitIncrement(Math.max((int)(this.zoomResolutionPerPixel * 5.0f), 1));
            }
        }
        this.internalScrollbarChange = false;
    }

    private void updateZoomButtonsEnabledState() {
        if (!this.threadsMonitoringEnabled) {
            this.zoomInButton.setEnabled(false);
            this.zoomOutButton.setEnabled(false);
            this.scaleToFitButton.setEnabled(false);
        } else {
            if (this.scaleToFit) {
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.zoomInButton.setEnabled((double)this.zoomResolutionPerPixel > 0.1);
                int n = this.table.getTableHeader().getHeaderRect((int)1).width;
                this.zoomOutButton.setEnabled(this.zoomResolutionPerPixel * (float)n < 2.0f * (float)(this.manager.getEndTime() - this.manager.getStartTime()));
            }
            this.scaleToFitButton.setEnabled(true);
            this.scaleToFitButton.setToolTipText(this.scaleToFit ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
        }
    }

    void setTimeIntervalSelection(Collection<TimeIntervalDataFilter> collection) {
        this.timeFilters = collection;
        UIThread.invoke((Runnable)new Runnable(){

            public void run() {
                ThreadsPanel.this.updateUI();
            }
        });
    }

    Collection<TimeIntervalDataFilter> getTimeIntervalSelection() {
        return this.timeFilters;
    }

    private class StackAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenuItem menuItem;
        private final ThreadDumpQuery query;
        private final ThreadState state;

        public StackAction(ThreadState threadState, ThreadState.MSAState mSAState, ThreadDumpQuery threadDumpQuery) {
            this.putValue("Name", ThreadStateResources.forState((ThreadState.MSAState)mSAState).name);
            this.putValue("ShortDescription", ThreadStateResources.forState((ThreadState.MSAState)mSAState).tooltip);
            this.putValue("SmallIcon", new ThreadStateIcon(mSAState, 10, 10));
            this.putValue("ActionCommandKey", ThreadsPanel.QUERY_STATE_ACTION_COMMAND);
            this.menuItem = new JMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
            this.query = threadDumpQuery;
            this.state = threadState;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThreadsPanel.this.queryChanged(this.query, this.state);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadsTableModel
    extends AbstractTableModel {
        private ThreadsTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return ThreadNameCellRenderer.class;
                }
                case 1: {
                    return ThreadStateCellRenderer.class;
                }
                case 2: {
                    return ThreadSummaryCellRenderer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return THREADS_COLUMN_NAME;
                }
                case 1: {
                    return TIMELINE_COLUMN_NAME;
                }
                case 2: {
                    return SUMMARY_COLUMN_NAME;
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return ThreadsPanel.this.filteredDataToDataIndex.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ThreadsPanel.this.filteredDataToDataIndex.get(n);
                }
                case 1: {
                    return ThreadsPanel.this.getThreadData((Integer)ThreadsPanel.this.filteredDataToDataIndex.get(n));
                }
                case 2: {
                    return ThreadsPanel.this.getThreadSummary((Integer)ThreadsPanel.this.filteredDataToDataIndex.get(n));
                }
            }
            return null;
        }
    }

    class ThreadsScrollBar
    extends JScrollBar {
        public ThreadsScrollBar() {
            super(0);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(((ThreadsPanel)ThreadsPanel.this).table.getTableHeader().getHeaderRect((int)1).width, dimension.height);
        }
    }

    public static interface ThreadsDetailsCallback {
        public void showStack(long var1, ThreadDumpQuery var3);
    }
}

