/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider2;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public final class JavaSourceNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        Project project2 = (Project)project.getLookup().lookup(Project.class);
        assert (project2 != null);
        return new SourcesNodeList(project2);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        public PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(JavaSourceNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProvider2 customizerProvider2 = (CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class);
            if (customizerProvider2 != null) {
                customizerProvider2.showCustomizer(this.nodeName, this.panelName);
            } else {
                CustomizerProvider customizerProvider = (CustomizerProvider)this.project.getLookup().lookup(CustomizerProvider.class);
                if (customizerProvider != null) {
                    customizerProvider.showCustomizer();
                }
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private final String nodeName;
        private final Project project;
        private final boolean trueSource;

        public PackageViewFilterNode(SourceGroupKey sourceGroupKey, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroupKey.group));
            this.project = project;
            this.nodeName = "Sources";
            this.trueSource = sourceGroupKey.trueSource;
        }

        public Action[] getActions(boolean bl) {
            ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(super.getActions(bl)));
            if (this.trueSource) {
                arrayList.add(null);
                arrayList.add(new PreselectPropertiesAction(this.project, this.nodeName));
            } else {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Action action = (Action)iterator.next();
                    if (action == null || !action.getClass().getName().equals("org.netbeans.modules.project.ui.actions.NewFile$WithSubMenu")) continue;
                    iterator.remove();
                }
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        public String getHtmlDisplayName() {
            if (this.trueSource) {
                return super.getHtmlDisplayName();
            }
            String string = this.getOriginal().getHtmlDisplayName();
            if (string == null) {
                try {
                    string = XMLUtil.toElementContent((String)super.getDisplayName());
                }
                catch (CharConversionException charConversionException) {
                    return null;
                }
            }
            return "<font color='!controlShadow'>" + string + "</font>";
        }
    }

    private static class GeneratedSourceGroup
    implements SourceGroup {
        private final FileObject child;

        GeneratedSourceGroup(FileObject fileObject) {
            this.child = fileObject;
        }

        public FileObject getRootFolder() {
            return this.child;
        }

        public String getName() {
            return this.child.getNameExt();
        }

        public String getDisplayName() {
            try {
                return NbBundle.getBundle((String)("org.netbeans.modules.java.api.common.project.ui.gensrc-" + this.getName())).getString("label");
            }
            catch (MissingResourceException missingResourceException) {
                return NbBundle.getMessage(JavaSourceNodeFactory.class, (String)"JavaSourceNodeFactory.gensrc", (Object)this.getName());
            }
        }

        public Icon getIcon(boolean bl) {
            return null;
        }

        public boolean contains(FileObject fileObject) throws IllegalArgumentException {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;
        public final boolean trueSource;

        SourceGroupKey(SourceGroup sourceGroup, boolean bl) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
            this.trueSource = bl;
        }

        public int hashCode() {
            int n = 5;
            String string = this.group.getDisplayName();
            n = 79 * n + (this.fileObject != null ? this.fileObject.hashCode() : 0);
            n = 79 * n + (string != null ? string.hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            if (!(this.fileObject == sourceGroupKey.fileObject || this.fileObject != null && this.fileObject.equals(sourceGroupKey.fileObject))) {
                return false;
            }
            String string = this.group.getDisplayName();
            String string2 = sourceGroupKey.group.getDisplayName();
            boolean bl2 = string == null;
            boolean bl3 = bl = string2 == null;
            return bl2 == bl && string.equals(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private final Project project;
        private final File genSrcDir;
        private final FileChangeListener genSrcDirListener;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourcesNodeList(Project project) {
            this.project = project;
            this.genSrcDirListener = new FileChangeAdapter(){

                public void fileFolderCreated(FileEvent fileEvent) {
                    SourcesNodeList.this.stateChanged(null);
                }

                public void fileDeleted(FileEvent fileEvent) {
                    SourcesNodeList.this.stateChanged(null);
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    SourcesNodeList.this.stateChanged(null);
                }
            };
            File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
            this.genSrcDir = file != null ? new File(file, "build/generated-sources") : null;
        }

        public List<SourceGroupKey> keys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>();
            for (SourceGroup sourceGroup : this.getSources().getSourceGroups("java")) {
                arrayList.add(new SourceGroupKey(sourceGroup, true));
            }
            FileObject fileObject = FileUtil.toFileObject((File)this.genSrcDir);
            if (fileObject != null) {
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    if (!fileObject2.isFolder()) continue;
                    arrayList.add(new SourceGroupKey(new GeneratedSourceGroup(fileObject2), false));
                }
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
            FileUtil.addFileChangeListener((FileChangeListener)this.genSrcDirListener, (File)this.genSrcDir);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
            FileUtil.removeFileChangeListener((FileChangeListener)this.genSrcDirListener, (File)this.genSrcDir);
        }

        public Node node(SourceGroupKey sourceGroupKey) {
            return new PackageViewFilterNode(sourceGroupKey, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourcesNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

